#include "cdevReactor.h"
#include "cdevEventHandler.h"
#include <math.h>

cdevEventHandler::cdevEventHandler ( void )
	: mask(0), 
	  next(NULL), 
	  timeoutRate(0, 0),
	  nextTimeout(0, 0),
	  reactor(NULL)
	{
	}
	

cdevEventHandler::~cdevEventHandler ( void )
	{
	if(reactor!=NULL) reactor->extractHandler(this);
	handleClose();
	}

void cdevEventHandler::setHandle ( int )
	{
	}

int cdevEventHandler::getHandle ( void ) const
	{
	return -1;
	}

void cdevEventHandler::setReactor (cdevReactor * r)
	{
	reactor = r;
	}


cdevEventHandler * cdevEventHandler::getNext (void )
	{
	return next;
	}


void cdevEventHandler::setNext (cdevEventHandler * n) 
	{
	next = n; 
	}

		
int cdevEventHandler::getMask ( void ) 
	{ 
	return mask; 
	}
	
	
cdevReactor * cdevEventHandler::getReactor ( void ) 
	{ 
	return reactor; 
	}


cdevTime & cdevEventHandler::getTimeoutRate ( void ) 
	{ 
	return timeoutRate; 
	}

cdevTime & cdevEventHandler::getNextTimeout ( void )
	{
	return nextTimeout;
	}
	

void cdevEventHandler::setMask ( unsigned Mask )
	{
	mask = (Mask&(READ_MASK|WRITE_MASK|EXCEPT_MASK|DONT_CALL));
	}


void cdevEventHandler::setTimeoutRate ( cdevTime time ) 
	{ 
	timeoutRate = time;
	resetTimer();
	}


void cdevEventHandler::resetTimer ( void )
	{
	nextTimeout.setTime();
	nextTimeout = nextTimeout+getTimeoutRate();
	}

int cdevEventHandler::handleInput   ( void ) { return  0; }
int cdevEventHandler::handleOutput  ( void ) { return  0; }
int cdevEventHandler::handleExcept  ( void ) { return  0; }
int cdevEventHandler::handleTimeout ( void ) { return  0; }
int cdevEventHandler::handleSignal  ( void ) { return -1; }
int cdevEventHandler::handleClose   ( void ) { return  0; }

