#include <cdevStreamQueue.h>

class TestNode : public cdevStreamNode
{
private:
	static TestNode * freeList;
	TestNode        * freeListNext;		

	char buf[75];
	size_t len;
	
public:
	TestNode ( void )
		: len(0), freeListNext(NULL)
		{
		}
	size_t getLen ( void ) const { return len; }
	void   setLen ( size_t size ) { len = size; }
	char * getBuf ( void ) const { return (char *)buf; }
	void   setBuf ( char * buffer, size_t size)
		{
		strcpy(buf, buffer);
		len = size;
		}
		
	void * operator new ( size_t )
		{
		TestNode * node;
		if(freeList==NULL)
			{
			freeList = ::new TestNode[1000];
			for(int i=0; i<999; i++)
				{
				freeList[i].freeListNext = &freeList[i+1];
				}
			}
		node     = freeList;
		freeList = node->freeListNext;
		return node;
		}
		
	void operator delete ( void * ptr )
		{
		TestNode * node = (TestNode *)ptr;
		node->freeListNext = freeList;
		freeList = node;
		}
};
