#include "cdevMonitorTable.h"
#include "cdevTagMap.h"

cdevTagMap myMap;

class myMonitorTable : public cdevMonitorTable
{
public :
	int fireCallback (cdevMessage * message )
		{
		char      * str;
		size_t      len;
		cdevMessage message2;
		cdevData   *data = message->getData();
		if(data) myMap.localToRemote(*data);
		
		message->streamOut(&str, &len);
		message2.streamIn(str, len);
		message2.asciiDump();
		if(str!=NULL) delete str;
		
		if(data) myMap.remoteToLocal(*data);

		return 0;
		}
};

myMonitorTable mTbl;


char * tagNames[7]=
	{
	"value",
	"status",
	"controlHigh",
	"controlLow",
	"time",
	"alarmHigh",
	"alarmLow"
	};

int    tagValues[7]=
	{
	9001,
	9002,
	9003,
	9004,
	9005,
	9006,
	9007
	};
	
char * deviceList[10] =
	{
	"device1",
	"device2",
	"device3",
	"device4",
	"device5",
	"device6",
	"device7", 
	"device8",
	"device9",
	"device10"
	};

int main()
{
cdevMessage * message;
cdevData      context;
cdevData    * triggers[10];
cdevData      trigger;

myMap.updateTagMap(tagNames, tagValues, 7);

cdevData::insertTag(9001, "value1");
cdevData::insertTag(9002, "status1");
cdevData::insertTag(9003, "controlHigh1");
cdevData::insertTag(9004, "controlLow1");
cdevData::insertTag(9005, "time1");
cdevData::insertTag(9006, "alarmHigh1");
cdevData::insertTag(9007, "alarmLow1");

context.insert("value", 3);
context.insert("status", 3);
context.insert("controlHigh", 2);
context.insert("controlLow", 2);
context.insert("time", 1);
context.insert("alarmHigh", 1);
context.insert("alarmLow", 1);  

trigger.insert("value", 100);
trigger.insert("status", 0);
trigger.insert("controlHigh", 1000);
trigger.insert("controlLow", 0);
trigger.insert("time", 100);
trigger.insert("alarmHigh", 999);
trigger.insert("alarmLow", 1);

for(int i=0; i<10; i++) triggers[i] = &trigger;
message = new cdevMessage(1, 1, 0, 0, 0, 0, 0, 10, deviceList, "monitorOn attrib", NULL, &context);
cdevMessage message2(*message);

message2.setCancelTransIndex(message2.getTransIndex());
mTbl.insertMonitor(message, triggers, 10);

fprintf(stdout, "***************** Firing a monitor *****************\n");
mTbl.fireMonitor  ("device1", "attrib", "controlHigh", &trigger);

mTbl.removeMonitor(&message2);

fprintf(stdout, "*************** Firing Four Monitors ***************\n");
mTbl.fireMonitor  ("device1",  "attrib", "controlHigh", &trigger);
mTbl.fireMonitor  ("device2",  "attrib", "controlHigh", &trigger);
mTbl.fireMonitor  ("device3",  "attrib", "controlHigh", &trigger);
mTbl.fireMonitor  ("device10", "attrib", "controlHigh", &trigger);

context.remove();
context.insert("value", 3);

cdevMessage *message3 = new cdevMessage(2, 2, 0, 0, 0, 0, 0, 10, deviceList, "monitorOn attrib", NULL, &context);
mTbl.insertMonitor(message3, &trigger);

for(i=0; i<100; i++)
	{
	trigger.insert("value", i);
	mTbl.fireMonitor("device1", "attrib", "value", &trigger);
	}

mTbl.removeClientMonitors(2);
mTbl.fireMonitor("device1", "attrib", "value", &trigger);
return 0;
}
