%{

/*----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//----------------------------------------------------------------------------
//
// Description:    
//   Parser rsvc logic expression
//                                                  
// Author:  Jie Chen  
//       
// Revision History:
//   rsvc_logic.y,v
// Revision 1.2  1998/01/23  13:50:10  akers
// Ongoing development
//
 * Revision 1.1  1998/01/22  17:08:28  akers
 * Addition of new NameServer
 *
//                                       
//---------------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifndef _WIN32
#include <unistd.h>
#endif

#include <fcntl.h>
#include <rsvcLogic.h>

#ifdef __VMS
/* VMS does not have unlink but it does have the function remove().
   Note that remove() may not be able to delete directory files . */
#define unlink(tmp) (remove((tmp)))
#endif

%}

%union {
  rsvc_logic_data* data;
  rsvcLogicInst*   inst;
}

%token <data> TAGNAME, CSTRING, DVALUE, IVALUE
%token EQUAL, LESS, GREATER, NOTEQUAL
%token LESSOREQUAL, GREATEROREQUAL
%token LEFTP, RIGHTP, OR, AND, LIKE, NOT, CERROR
%type <ival> logic_exp, rsvc_logic

%left OR
%left AND
%left NOT
%left EQUAL LESS GREATER NOTEQUAL LESSOREQUAL GREATEROREQUAL LIKE

%%
rsvc_logic_parse: rsvc_logic {logic_code (rsvc_logic_end);
                                logic_code (RSVC_LOGIC_STOP);
                               }

rsvc_logic: logic_exp { }
      | rsvc_logic AND rsvc_logic {logic_code (rsvc_logic_and);}
      | rsvc_logic OR rsvc_logic {logic_code (rsvc_logic_or);}
      | NOT rsvc_logic {logic_code (rsvc_logic_neg);}
      | LEFTP rsvc_logic RIGHTP {}
      ;

logic_exp: TAGNAME EQUAL IVALUE {logic_code (logic_val_push);
                                 logic_code ((rsvcLogicInst)$1);
                                 logic_code ((rsvcLogicInst)$3);
				 logic_code (rsvc_data_equal_int);
                                 }
      | TAGNAME EQUAL DVALUE    {logic_code (logic_val_push);
                                 logic_code ((rsvcLogicInst)$1);
                                 logic_code ((rsvcLogicInst)$3);
				 logic_code (rsvc_data_equal_dbl);
                                }
      | TAGNAME EQUAL CSTRING   {logic_code (logic_val_push);
                                 logic_code ((rsvcLogicInst)$1);
                                 logic_code ((rsvcLogicInst)$3);
				 logic_code (rsvc_data_equal_str);
                                }
      | TAGNAME LESS  IVALUE    {logic_code (logic_val_push);
                                 logic_code ((rsvcLogicInst)$1);
                                 logic_code ((rsvcLogicInst)$3);
				 logic_code (rsvc_data_less_int);
                                 }
      | TAGNAME LESS  DVALUE    {logic_code (logic_val_push);
                                 logic_code ((rsvcLogicInst)$1);
                                 logic_code ((rsvcLogicInst)$3);
				 logic_code (rsvc_data_less_dbl);
                                }
	
      | TAGNAME GREATER IVALUE  {logic_code (logic_val_push);
                                 logic_code ((rsvcLogicInst)$1);
                                 logic_code ((rsvcLogicInst)$3);
				 logic_code (rsvc_data_greater_int);
                                }
      | TAGNAME GREATER DVALUE  {logic_code (logic_val_push);
                                 logic_code ((rsvcLogicInst)$1);
                                 logic_code ((rsvcLogicInst)$3);
				 logic_code (rsvc_data_greater_dbl);
                                 }
      | TAGNAME LESSOREQUAL IVALUE{logic_code (logic_val_push);
                                 logic_code ((rsvcLogicInst)$1);
                                 logic_code ((rsvcLogicInst)$3);
				 logic_code (rsvc_data_lesseq_int);
                                 }
      | TAGNAME LESSOREQUAL DVALUE{logic_code (logic_val_push);
                                 logic_code ((rsvcLogicInst)$1);
                                 logic_code ((rsvcLogicInst)$3);
				 logic_code (rsvc_data_lesseq_dbl);
                                 }
      | TAGNAME GREATEROREQUAL IVALUE{logic_code (logic_val_push);
                                 logic_code ((rsvcLogicInst)$1);
                                 logic_code ((rsvcLogicInst)$3);
				 logic_code (rsvc_data_greatereq_int);
                                 }
      | TAGNAME GREATEROREQUAL DVALUE{logic_code (logic_val_push);
                                 logic_code ((rsvcLogicInst)$1);
                                 logic_code ((rsvcLogicInst)$3);
				 logic_code (rsvc_data_greatereq_dbl);
                                 }
      | TAGNAME NOTEQUAL IVALUE{logic_code (logic_val_push);
                                 logic_code ((rsvcLogicInst)$1);
                                 logic_code ((rsvcLogicInst)$3);
				 logic_code (rsvc_data_noequal_int);
                                }
      | TAGNAME NOTEQUAL DVALUE{logic_code (logic_val_push);
                                 logic_code ((rsvcLogicInst)$1);
                                 logic_code ((rsvcLogicInst)$3);
				 logic_code (rsvc_data_noequal_dbl);
                               }
      | TAGNAME NOTEQUAL CSTRING{logic_code (logic_val_push);
                                 logic_code ((rsvcLogicInst)$1);
                                 logic_code ((rsvcLogicInst)$3);
				 logic_code (rsvc_data_noequal_str);
                                }
      | TAGNAME LIKE CSTRING   {logic_code (logic_val_push);
                                 logic_code ((rsvcLogicInst)$1);
                                 logic_code ((rsvcLogicInst)$3);
				 logic_code (rsvc_data_has_str);
                               }
      ;
%%
