//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of rsvcVirtualDbase Class
//
// Author:  Jie Chen
//
// Revision History:
//   rsvcVirtualDbase.cc,v
// Revision 1.1  1998/01/22  17:08:26  akers
// Addition of new NameServer
//
//
//
#include "rsvcVirtualDbase.h"

rsvcVirtualDbase::rsvcVirtualDbase (void)
:flag_ (0), mode_ (0), name_ (0), page_size_ (0), opened_ (0), 
 keyType_ (RSVC_STRING), err_ (-1)
{
#ifdef _TRACE_OBJECTS
  printf ("Create rsvcVirtualDbase Class\n");
#endif
  // empty
}

rsvcVirtualDbase::rsvcVirtualDbase (char* name, int flags, 
				    int keyType,
				    size_t data_size,
				    size_t cache_size,
				    size_t page_size, 
				    int mode)
:flag_ (flags), mode_ (mode), page_size_ (0),
 opened_ (0), keyType_ (keyType), err_ (-1)
{
#ifdef _TRACE_OBJECTS
  printf ("Create rsvcVirtualDbase Class\n");
#endif
  create (name, flags, keyType, data_size, cache_size, page_size, mode);  
}

rsvcVirtualDbase::~rsvcVirtualDbase (void)
{
#ifdef _TRACE_OBJECTS
  printf ("Delete rsvcVirtualDbase Class\n");
#endif
 if (name_)
    delete []name_;
}

int
rsvcVirtualDbase::open (char* name, int flag, int keyType,
			size_t /* cache_size */,
			int mode)
{
  name_ = new char[strlen (name) + 1];
  strcpy (name_, name);
  
  err_ = 0;
  flag_ = flag;
  mode_ = mode;
  keyType_ = keyType;
  page_size_ = 4096;
  opened_ = 1;

  return RSVC_SUCCESS;
}

int
rsvcVirtualDbase::create (char* name, int flag, int keyType,
			  size_t /* data_size */,
			  size_t /* cache_size */, size_t /* page_size */,
			  int mode)
{
  name_ = new char[strlen (name) + 1];
  strcpy (name_, name);
  
  err_ = 0;
  flag_ = flag;
  mode_ = mode;
  keyType_ = keyType;
  page_size_ = 4096;
  opened_ = 1;

  return RSVC_SUCCESS;
}

