//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of RSVC Server Configuration Class
//
// Author:  Jie Chen
//
// Revision History:
//   rsvcServerConfig.cc,v
// Revision 1.2  1998/08/03  16:30:23  chen
// AIX porting
//
// Revision 1.1  1998/01/22  17:08:19  akers
// Addition of new NameServer
//
//
//
#include <rsvcConfig.h>
#include <rsvcErr.h>

#if defined (AIX)
#include <strings.h>
#endif

#ifdef _WIN32
#define strcasecmp _stricmp
#endif

#include "rsvcServerConfig.h"

unsigned short rsvcServerConfig::port_ =       RSVC_SERVER_PORT;
size_t         rsvcServerConfig::pageSize_   = 4096;
size_t         rsvcServerConfig::cacheSize_  = 10*4096;
size_t         rsvcServerConfig::cacheMax_   = RSVC_CACHE_MAX;
size_t         rsvcServerConfig::cacheLf_    = RSVC_CACHE_LF;
size_t         rsvcServerConfig::maxnofiles_ = RSVC_RLIMIT_NOFILE;
char*          rsvcServerConfig::keyName_ = 0;
char*          rsvcServerConfig::keyType_ = 0;
char*          rsvcServerConfig::keyExp_ = 0;
char*          rsvcServerConfig::tableName_ = 0;
char*          rsvcServerConfig::tableNameExt_ = 0;
char*          rsvcServerConfig::dbaseHome_ = 0;
char*          rsvcServerConfig::monitorTag_ = 0;
char*          rsvcServerConfig::queryTag_ = 0;
char**         rsvcServerConfig::defaultDbases_ = 0;

unsigned short
rsvcServerConfig::serverPort (void)
{
  return rsvcServerConfig::port_ + 1024;
}

unsigned short
rsvcServerConfig::port (void)
{
  return rsvcServerConfig::port_;
}

size_t
rsvcServerConfig::dbasePageSize (void)
{
  return rsvcServerConfig::pageSize_;
}

size_t
rsvcServerConfig::dbaseCacheSize (void)
{
  return rsvcServerConfig::cacheSize_;
}

size_t
rsvcServerConfig::dbaseCacheMax (void)
{
  return rsvcServerConfig::cacheMax_;
}

size_t
rsvcServerConfig::dbaseCacheLf (void)
{
  return rsvcServerConfig::cacheLf_;
}

size_t
rsvcServerConfig::maxNoFiles (void)
{
  return rsvcServerConfig::maxnofiles_;
}


char *
rsvcServerConfig::key (void)
{
  if (rsvcServerConfig::keyName_ == 0) {
    rsvcServerConfig::keyName_ = new char[strlen (RSVC_KEY_NAME) + 1];
    ::strcpy (rsvcServerConfig::keyName_, RSVC_KEY_NAME);
  }
  return rsvcServerConfig::keyName_;
}

char *
rsvcServerConfig::keyType (void)
{
  if (rsvcServerConfig::keyType_ == 0) {
    rsvcServerConfig::keyType_ = new char[strlen (RSVC_KEY_TYPE_NAME) + 1];
    ::strcpy (rsvcServerConfig::keyType_, RSVC_KEY_TYPE_NAME);
  }
  return rsvcServerConfig::keyType_;
}

char *
rsvcServerConfig::keyExp (void)
{
  if (rsvcServerConfig::keyExp_ == 0) {
    rsvcServerConfig::keyExp_ = new char[strlen (RSVC_KEY_EXP_NAME) + 1];
    ::strcpy (rsvcServerConfig::keyExp_, RSVC_KEY_EXP_NAME);
  }
  return rsvcServerConfig::keyExp_;
}

char *
rsvcServerConfig::table (void)
{
  if (rsvcServerConfig::tableName_ == 0) {
    rsvcServerConfig::tableName_ = new char[strlen (RSVC_TABLE_NAME) + 1];
    ::strcpy (rsvcServerConfig::tableName_, RSVC_TABLE_NAME);
  }
  return rsvcServerConfig::tableName_;
}

char *
rsvcServerConfig::tableNameExt (void)
{
  if (rsvcServerConfig::tableNameExt_ == 0) {
    rsvcServerConfig::tableNameExt_ = new char[strlen (RSVC_TABLE_NAME_EXT)
					      + 1];
    ::strcpy (rsvcServerConfig::tableNameExt_, RSVC_TABLE_NAME_EXT);
  }
  return rsvcServerConfig::tableNameExt_;
}

char *
rsvcServerConfig::dbaseHome (void)
{
  if (rsvcServerConfig::dbaseHome_ == 0) {
    rsvcServerConfig::dbaseHome_ = new char[strlen (RSVC_DBASE_HOME) + 1];
    ::strcpy (rsvcServerConfig::dbaseHome_, RSVC_DBASE_HOME);
  }
  return rsvcServerConfig::dbaseHome_;
}

char *
rsvcServerConfig::monitorTag (void)
{
  if (rsvcServerConfig::monitorTag_ == 0) {
    rsvcServerConfig::monitorTag_ = new char[strlen (RSVC_MONITOR_TAG) + 1];
    ::strcpy (rsvcServerConfig::monitorTag_, RSVC_MONITOR_TAG);
  }
  return rsvcServerConfig::monitorTag_;
}

char *
rsvcServerConfig::queryTag (void)
{
  if (rsvcServerConfig::queryTag_ == 0) {
    rsvcServerConfig::queryTag_ = new char[strlen (RSVC_QUERY_TAG) + 1];
    ::strcpy (rsvcServerConfig::queryTag_, RSVC_QUERY_TAG);
  }
  return rsvcServerConfig::queryTag_;
}

char**
rsvcServerConfig::defaultDbases (void)
{
  return rsvcServerConfig::defaultDbases_;
}


int
rsvcServerConfig::configure (char *filename)
{
  char *fname;
  char  realname[256];

  if (!filename) {
    fname = getenv (RSVC_SERVER_ENV);
    if (fname) {
      strncpy (realname, fname, sizeof (realname) - 1);
      realname[sizeof (realname) - 1] = 0;
    }
    else
      return RSVC_ERROR;
  }
  strncpy (realname, filename, sizeof (realname) - 1);
  realname[sizeof (realname) - 1] = 0;  

  FILE *fd = fopen (realname, "r");
  if (!fd) {
    fprintf (stderr, "Cannot open server configuration file %s.\n", realname);
    fprintf (stderr, "Using default paramerters to startup server\n");
    return RSVC_ERROR;
  }

  char line[256];
  char token[80], value[80];
  int  st;
  int  i = 0, j = 0;
  char defdbase[100][100];

  while (!feof (fd)) {
    memset (line, 0, sizeof (line));
    fgets (line, sizeof (line), fd);
    if (line[0] == '#' && line[0] == 0)
      continue;
    if ((st = sscanf (line, "%s %s", token, value)) >= 2) {
      if (::strcasecmp (token, "serverPort") == 0) {
	rsvcServerConfig::port_ = atoi (value);
	printf ("rsvcServerConfig: server starts at port %d\n", atoi (value));
      }
      else if (::strcasecmp (token, "dbasePageSize") == 0) {
	rsvcServerConfig::pageSize_ = atoi (value);
	printf ("rsvcServerConfig: server uses database pagesize %d\n", atoi (value));
      }
      else if (::strcasecmp (token, "dbaseCacheSize") == 0) {
	rsvcServerConfig::cacheSize_ = atoi (value);
	printf ("rsvcServerConfig: server uses cache size %d\n", atoi (value));
      }
      else if (::strcasecmp (token, "dbaseCacheMaxEle") == 0) 
	rsvcServerConfig::cacheMax_ = atoi (value);
      else if (::strcasecmp (token, "dbaseCacheLoadFactor") == 0)
	rsvcServerConfig::cacheLf_ = atoi (value);
      else if (::strcasecmp (token, "dbaseHome") == 0) {
	if (rsvcServerConfig::dbaseHome_)
	  delete []rsvcServerConfig::dbaseHome_;
	rsvcServerConfig::dbaseHome_ = new char[strlen (value) + 1];
	strcpy (rsvcServerConfig::dbaseHome_, value);
	printf ("rsvcServerConfig: server store database files at %s\n", value);
      }
      else if (::strcasecmp (token, "defaultDbase") == 0) {
	strncpy (defdbase[i], value, sizeof (defdbase[i]));
	i++;
      }
    }
  }
  fclose (fd);

  // construct default databases that need to be open
  rsvcServerConfig::defaultDbases_ = new char*[i + 1];
  for (j = 0; j < i; j++) {
    rsvcServerConfig::defaultDbases_[j] = new char[strlen (defdbase[j]) + 1];
    strcpy (rsvcServerConfig::defaultDbases_[j], defdbase[j]);
  }
  rsvcServerConfig::defaultDbases_[j] = 0;

  return RSVC_SUCCESS;
}
