//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      RSVC Network Protocol Data
//
// Author:  Jie Chen
//
//
//
#ifndef _RSVC_NET_DATA_H
#define _RSVC_NET_DATA_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <rsvcErr.h>
#include <rsvcData.h>
#include <rsvcCbk.h>
#include <rsvcConfig.h>
#include <rsvcStreamable.h>

class RSVC_CLASS_SPEC rsvcNetData : public rsvcStreamable
{
public:
  // constructors
  // create empty data
  rsvcNetData    (void);

  // create a data with operation code and reqid
  rsvcNetData    (rsvcData& data, long opcode, long cbkid, 
		  long reqid = 0, long clientid = 0, long socketid = 0,
		  long status = RSVC_SUCCESS);
  
  // create a data with explicit callback data
  rsvcNetData    (rsvcData& data, rsvcCbk& cbk);

  // create a data with callback data only
  rsvcNetData    (rsvcCbk& cbk);

  // create a data with real data only
  rsvcNetData    (rsvcData& data);

  // copy operation
  rsvcNetData    (const rsvcNetData& data);

  // destructor
  ~rsvcNetData   (void);

  // set method
  void           set (rsvcData& data, rsvcCbk& cbk);
  void           set (rsvcCbk& cbk);

  // cleanup everything
  void           cleanup (void);

  // opcode
  long           opcode (void) const;
  void           opcode (long op);

  // request id
  long           reqid  (void) const;
  void           reqid  (long id);

  // client id
  long           clientid (void) const;
  void           clientid (long cid);

  // callback id
  long           cbkid    (void) const;
  void           cbkid    (long cid);

  // socket id
  long           socketid (void) const;
  void           socketid (long id);

  // net operation status
  long           cbkstatus (void) const;
  void           cbkstatus (long status);

  // return underlying data object
  rsvcData&      data     (void);
  // return underlying callback object
  rsvcCbk&       cbk      (void);

  // stream in and out operation
  size_t         streamSize (void);

 // stream out to a newly allocated buffer with size 'size'
  int            streamOut  (char** buf, size_t* size);
  // stream out to a preallocate buffer with buffer size 'size'
  int            streamOut  (char* buf, size_t len);

  // stream in from a buffer
  // this function is called after one has read in the header
  // information already
  int            streamIn   (char* buf, size_t len);

  // stream out to a preallocate buffer with buffer size 'len'
  // and data size 'datasize'
  int            streamOut  (char* buf, size_t len, size_t datasize);

  // retrieve header information
  static int     readHeader (char* buf, size_t len, size_t* datasize);

  // return header length
  static size_t  headerLen  (void);

private:
  // callback object
  rsvcCbk          cbk_;

  // data object
  rsvcData         data_;
};
#endif

  
