//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      RSVC Server Query Simple Engine
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
//
//
#ifndef _RSVC_LOGIC_Q_ENG_H
#define _RSVC_LOGIC_Q_ENG_H

#include <stdio.h>
#include <string.h>
#include <rsvcData.h>
#include <rsvcLogic.h>

/* stack size */
#define RSVC_NSTACK 1024

/* program counter */
#define RSVC_NPROG 4096

class rsvcLogicQEng
{
public:
  // constructor and destructor
  rsvcLogicQEng            (char* qstring);
  ~rsvcLogicQEng           (void);

  // operation
  
  // parse string and produce simple engine
  // return 0 success, return -1 syntax error
  int  parse               (void);

  // execute the engine
  int  execute             (rsvcData& data);

  // clean the engine
  int  clean               (void);
  
  // stack operation
  int push                 (rsvc_logic_data* data);
  rsvc_logic_data* pop     (void);
  
private:
  // machine stack
  rsvc_logic_data* stack_[RSVC_NSTACK];
  // next free slot on the stack
  rsvc_logic_data** stackp_;
  
  // simple computing machine
  rsvcLogicInst  prog_[RSVC_NPROG]; 
  // next free spot for code 
  rsvcLogicInst* progp_;    
  // program counter
  rsvcLogicInst* pc_;

  // parsing string
  char* qstr_;

  // result of execution
  int   result_;

  friend rsvcLogicInst* logic_code (rsvcLogicInst f);
  friend int             logic_val_push (void* d);
  friend int             rsvc_logic_end (void* d);
};


#endif

