//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      RSVC Server All Data Store Table
//
// Author:  Jie Chen
//
//
//
#ifndef _RSVC_DATA_STORE_TABLE_H
#define _RSVC_DATA_STORE_TABLE_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <rsvcDataStore.h>
#include <rsvcHash.h>

class rsvcDataStoreTable
{
public:
  // constructor
  rsvcDataStoreTable          (unsigned int max = 100, unsigned int lf = 5);

  // destructor
  ~rsvcDataStoreTable         (void);

  // add a data store
  int                   add   (rsvcDataStore* store);

  // find a data store
  rsvcDataStore*        find  (char* name);

  // open a datastore with name
  int                   openDatabase (char* name);

  // monitor off all values for a client
  void             monitorOff (void* io);

  // handle close for a client
  void             handleClose (void* io);

private:

  // data area
  rsvcHash                    table_;

  // deny access to copy and assignment operations
  rsvcDataStoreTable (const rsvcDataStoreTable& table);
  rsvcDataStoreTable operator = (const rsvcDataStoreTable& table);
};
#endif
