//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      RSVC Callback Class (Used on Server/Client Side)
//
//      This class contains protocol information related to callbacks
//      1. operation code
//      2. request   id
//      3. socket    id -->for server only
//      4. client    id
//      5. callback  id -->from client to server
//
// Author:  Jie Chen
//
//
//
#ifndef _RSVC_CBK_H
#define _RSVC_CBK_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <rsvcErr.h>
#include <rsvcStreamable.h>
#include <rsvcHashable.h>

class rsvcCbk : public rsvcStreamable, public rsvcHashable
{
public:
  // constructor
  rsvcCbk          (void);
  rsvcCbk          (int opcode, int cbkid, int reqid, int clientid,
		    int socketid = 0, int status = RSVC_SUCCESS, 
		    void* usrptr = 0);
  rsvcCbk          (const rsvcCbk& cbk);
  rsvcCbk&         operator = (const rsvcCbk& cbk);
  ~rsvcCbk         (void);

  // clean up all values
  void             cleanup (void);

  void             socketid (int id);
  int              socketid (void) const;

  void             cbkstatus (int st);
  int              cbkstatus (void) const;

  int              reqid    (void) const;
  void             reqid    (int req);
  int              opcode   (void) const;
  void             opcode   (int op);
  int              cbkid    (void) const;
  void             cbkid    (int id);
  int              clientid (void) const;
  void             clientid (int cid);
  
  // use by local only , not transmitted through wire
  void*            userptr  (void) const;
  void             userptr  (void* ptr);

  // inherited operation
  unsigned int     hash     (void);

  size_t           streamSize (void);
  // stream out to a newly allocated buffer with size 'size'
  int              streamOut  (char** buf, size_t* size);
  // stream out to a preallocate buffer with buffer size 'size'
  int              streamOut  (char* buf, size_t len);
  // stream in from a buffer
  int              streamIn   (char* buf, size_t len);

  // check whether two callbacks are the same.
  // if checkreq == 1, check reqid otherwise no
  // this function is used by server side to check
  // whether a monitoroff callback is inside the callback table
  // on the server.
  static int sameCallback (rsvcCbk* cbk1, rsvcCbk* callback2,
			   int checkreq = 1);

  // check whether a callback coming back from the server
  // match a callback in the table
  int        match        (rsvcCbk* scbk);

private:
  // all data 
  int             opcode_;
  int             cbkid_;
  int             reqid_;
  int             clientid_;
  int             socketid_;
  int             status_;

  // used by local only, not transmitted on wire
  void*           private_;
};
#endif

  
