//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      RSVC TCP Connection Acceptor
//
// Author:  Jie Chen
//
//
//
#ifndef _RSVC_ACCEPTOR_H
#define _RSVC_ACCEPTOR_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <rsvcConfig.h>
#include <rsvcServerConfig.h>
#include <rsvcData.h>
#include <rsvcNetData.h>
#include <rsvcSlist.h>
#include <rsvcDataStoreTable.h>

#include <cdevAddr.h>
#include <cdevSocketAcceptor.h>
#include <cdevReactor.h>

class rsvcIO;

class rsvcAcceptor : public cdevEventHandler
{
public:
  // constructor: deny direct instantiation
  rsvcAcceptor                (cdevReactor& reactor, 
			       rsvcDataStoreTable& table);

  // destructor
  ~rsvcAcceptor               (void);

  // open local address
  int   open                  (unsigned short port);
  // return number of IO connections
  int   numberConnections     (void);
  // remove a connection from the list
  int remove                  (rsvcIO* channel);
  // check whether a rsvcIO is in this list
  int includes                (rsvcIO* channel);


  // send a result to all clients
  int sendToAllConnections    (rsvcNetData* data);

  // return port number
  unsigned short  port_number  (void);
  
  // return all connection list
  rsvcSlist& connectionList   (void);

protected:
  // inherited operations
  int        getHandle       (void) const;
  int        handleClose     (void);

  // inherited operations
  int handleInput            (void);

  // delete all clients : only used in the destructor
  void       deleteAllConnections (void);

  // data area

  cdevSocketAcceptor listener_;
  cdevReactor &      reactor_;
  rsvcSlist          connectionList_;
  int                listLock_;

  // global data store table
  rsvcDataStoreTable& storeTable_;

  // friend class 
  friend class rsvcIO;
};
#endif

