.SUFFIXES: .cc .obj

ARCH           = WINNT-4.0
SHOBJ          = YES
APPNAME        = CDEV Resource Name Server

# ******************************************************************************
# * The BINARIES definition names all of the binary files that should be deleted
# * whenever "make clean" is executed.
# ******************************************************************************
BINARIES       = $(BASEBIN)\rsvcServer.exe \
                 $(CDEVLIB)\rsvc.dll \
                 $(CDEVLIB)\rsvc.lib
                   
include ..\..\include\makeinclude\Makefile.WINNT-4.0

SERVEROBJS     = .exec\$(TARGETDIR)\rsvcServer.obj \
                 .exec\$(TARGETDIR)\rsvcSignal.obj \
                 .exec\$(TARGETDIR)\rsvcDataStreamer.obj \
                 .exec\$(TARGETDIR)\rsvcDataEntry.obj \
                 .exec\$(TARGETDIR)\rsvcData.obj \
                 .exec\$(TARGETDIR)\rsvcVirtualDbase.obj \
                 .exec\$(TARGETDIR)\rsvcServerConfig.obj \
                 .exec\$(TARGETDIR)\rsvcTableDef.obj \
                 .exec\$(TARGETDIR)\rsvcHashable.obj \
                 .exec\$(TARGETDIR)\rsvcStreamable.obj \
                 .exec\$(TARGETDIR)\rsvcCbk.obj \
                 .exec\$(TARGETDIR)\rsvcSlist.obj \
                 .exec\$(TARGETDIR)\rsvcHSlist.obj \
                 .exec\$(TARGETDIR)\rsvcHash.obj \
                 .exec\$(TARGETDIR)\lex-nt.obj \
                 .exec\$(TARGETDIR)\yacc-nt.obj \
                 .exec\$(TARGETDIR)\rsvcLogicSup.obj \
                 .exec\$(TARGETDIR)\rsvcLogicQEng.obj \
                 .exec\$(TARGETDIR)\rsvcNetData.obj \
                 .exec\$(TARGETDIR)\rsvcDataStore.obj \
                 .exec\$(TARGETDIR)\rsvcDataStoreMem.obj \
                 .exec\$(TARGETDIR)\rsvcServerStore.obj \
                 .exec\$(TARGETDIR)\rsvcDataStoreTable.obj \
                 .exec\$(TARGETDIR)\rsvcCacheData.obj \
                 .exec\$(TARGETDIR)\rsvcCacheDataAttr.obj \
                 .exec\$(TARGETDIR)\rsvcStreamMsg.obj \
                 .exec\$(TARGETDIR)\rsvcAcceptor.obj \
                 .exec\$(TARGETDIR)\rsvcIO.obj \
                 .exec\$(TARGETDIR)\rsvcUdpHandler.obj \
                 .exec\$(TARGETDIR)\rsvcLocalConfig.obj
                 

CLIENTOBJS     = $(OBJDIR)\rsvcSlist.obj \
                 $(OBJDIR)\rsvcHSlist.obj \
                 $(OBJDIR)\rsvcHash.obj \
                 $(OBJDIR)\rsvcDataStreamer.obj \
                 $(OBJDIR)\rsvcDataEntry.obj \
                 $(OBJDIR)\rsvcData.obj \
                 $(OBJDIR)\rsvcNetData.obj \
                 $(OBJDIR)\rsvcCbk.obj \
                 $(OBJDIR)\rsvcHashable.obj \
                 $(OBJDIR)\rsvcStreamable.obj \
                 $(OBJDIR)\rsvcCallback.obj \
                 $(OBJDIR)\rsvcClient.obj \
                 $(OBJDIR)\rsvcUdpClient.obj

CXXEXTRA       = /D "_CDEV_MANAGE_SERVERS=1"
CXXEXTRA_DLL   = /D "_RSVC_CORE_EXPORTS_=1"
CXXEXTRA_EXE   = /D "_RSVC_BUILD_EXE=1"
CXXINCLUDES    = -I./

!IF "$(SHOBJ)" == "YES"
TARGETS = $(CDEVLIB)\rsvc.dll $(CDEVBIN)\rsvcServer.exe
!ELSE
TARGETS = $(CDEVLIB)\rsvc.lib $(CDEVBIN)\rsvcServer.exe
!ENDIF

targets : $(TARGETS)
	
$(CDEVBIN)\rsvcServer.exe : $(SERVEROBJS)
	@echo =^> Building $(@F) 
	@echo =^> Objects: $(?F)
 	-@if exist $@ erase $@
	$(LINK) $(CDEVLIB)\cdevReactor.lib \
	$(LINK_EXE_FLAGS) /out:$@ \
	$(SERVEROBJS) 
	@echo ^<= Done...
 	
$(CDEVLIB)\rsvc.lib : $(CLIENTOBJS)
	@echo =^> Building $(@F) 
	@echo =^> Objects: $(?F)
	-@if exist $@ erase $@
	$(LIB32) $(LINK_LIB_FLAGS) /out:$@ $(CLIENTOBJS)
	@echo ^<= Done...

$(CDEVLIB)\rsvc.dll : $(CLIENTOBJS)
	@echo =^> Building $(@F) 
	@echo =^> Objects: $(?F)
	-@if exist $@ erase $@
	$(LIB32) $(LINK_DLL_FLAGS) /out:$@ /implib:$(@D)\$(@B).lib $(CLIENTOBJS)
	@echo ^<= Done...
