//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      RSVC UDP Client for Servers to update their time stamps
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: rsvcUdpClient.java,v $
//   Revision 1.1  1999/10/18 17:12:44  chen
//   *** empty log message ***
//
//
//
import java.io.*;
import java.util.*;
import java.net.*;
import rsvcEvent;
import rsvcData;
import rsvcConfig;

public final class rsvcUdpClient
{
    // UDP Socket
    private DatagramSocket udpsocket_ = null;
    // Destination address for packets
    private InetAddress    dest_ = null;
    // Destination port for packets
    private int            port_ = 0;

    /**
     * Construct an empty rsvcUdpClient Object
     */
    public rsvcUdpClient ()
    {
	// empty
    }

    /**
     * Override default finalize method.This allows Java virtual
     * machine to clean up resource when this object is no longer
     * needed.
     */
    protected void finalize() throws Throwable
    {
	if (udpsocket_ != null)
	    udpsocket_.close ();
    }

    /**
     * Connect to a server that is on a given host at a given port
     */
    public synchronized void connect (String host, int port) throws UnknownHostException, IOException
    {
	try {
	    udpsocket_ = new DatagramSocket ();
	}catch (IOException e) {
	    System.err.println(e);
	    throw e;
	}

	try {
	    dest_ = InetAddress.getByName (host);
	}catch (UnknownHostException ue) {
	    throw ue;
	}
	port_ = port;
    }

    /**
     * A server that is being managed by RSVC sends a very simple data
     * to the rsvcServer to manifest itself being alive.
     * data is in the form of two tagged ("name", "domain") values or
     * anything that will make up an index
     */
    public synchronized int update (rsvcData data) throws IOException
    {
	if (udpsocket_ == null)
	    return rsvcConfig.RSVC_ERROR;

	rsvcEvent cbk = new rsvcEvent (data);
	cbk.setOpcode (rsvcConfig.RSVC_SET);
	cbk.setEventid (0);

	int datasize = cbk.streamSize ();
	ByteArrayOutputStream baoutput = new ByteArrayOutputStream (datasize);
	try {
	    cbk.streamOut (baoutput);
	}catch (IOException e) {
	    throw e;
	}

	// return underlying byte from this byteArrayStream
	byte[] obuffer = baoutput.toByteArray ();
	if (datasize != obuffer.length) {
	    throw new IOException ("Streamed out buffer size != original calculated stream size");
	}

	// construct a datapacket to send data out
	DatagramPacket packet = new DatagramPacket (obuffer, datasize,
						    dest_, port_);

	try {
	    udpsocket_.send (packet);
	} catch (IOException e) {
	    throw e;
	}
	return rsvcConfig.RSVC_SUCCESS;
    }

    /**
     * Shutdown connection (close socket)
     */
    public void disconnect () 
    {
	if (udpsocket_ != null)
	    udpsocket_.close ();
    }
	
	
}

