//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      RSVC Client Configuration (Must be compatiable to C++ side)
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: rsvcConfig.java,v $
//   Revision 1.1  1999/10/18 17:12:40  chen
//   *** empty log message ***
//
//
//
public final class rsvcConfig
{
    public static final int RSVC_SERVER_PORT = 10932;
    public static final int RSVC_MAX_KEY_LEN = 256;
    public static final String RSVC_KEY_NAME = "key";
    public static final String RSVC_TABLE_NAME = "table";
    public static final String RSVC_TABLE_NAME_EXT = ".def";
    public static final String RSVC_KEY_TYPE_NAME = "keyType";
    public static final String RSVC_KEY_EXP_NAME = "keyExp";
    public static final String RSVC_MONITOR_TAG = "monitorOn";
    public static final String RSVC_QUERY_TAG = "query";
    public static final int RSVC_CACHE_MAX = 20;
    public static final int RSVC_CACHE_LF = 5;
    public static final int RSVC_RLIMIT_NOFILE = 256;
    public static final int RSVC_UDP_BUFFER_SIZE = 4096;

    public static final int RSVC_OP_UNKNOWN = 2000;

    public static final int RSVC_CREATE_TABLE = 1000;
    public static final int RSVC_CREATE_MEMTABLE = 1001;
    public static final int RSVC_OPEN_DBASE = 1002;
    public static final int RSVC_GET = 1010;
    public static final int RSVC_SET = 1011;
    public static final int RSVC_DEL = 1012;
    public static final int RSVC_INSERT = 1013;
    public static final int RSVC_OVERWRITE = 1014;
    public static final int RSVC_QUERY = 1020;

    public static final int RSVC_MONITOR_ON = 1500;
    public static final int RSVC_MONITOR_ONATTR = 1501;
    public static final int RSVC_MONITOR_OFF = 1600;
    public static final int RSVC_MONITOR_OFFATTR = 1601;

    public static final int RSVC_MONITOR_ENTRIES = 1650;
    public static final int RSVC_MONITOR_OFFENTRIES = 1651;

    public static final int RSVC_SERVER_EXIT = 1700;

    public static final int RSVC_DATA_IN_MEMORY = 1;
    public static final int RSVC_DATA_ON_DISK = 2;


    // database name
    public static final String _RSVC_CDEV_SERVERS = "cdevServers";
    // key name
    public static final String _RSVC_CDEV_SERVERS_KEY = "svcid" ;
    // if we do not see a server for 30 seconds, we assume it is dead
    public static final int RSVC_CDEV_SERVER_TKO = 30;
    // frequency of scanning server database
    public static final int RSVC_CDEV_SCAN_PERIOD = 10;

    // the following are error status from server
    /* Failure of function is non-consequential */
    public static final int RSVC_WARNING =  -2;
    /* Errors that are not in any categories    */
    public static final int RSVC_ERROR = -1;
    /* public static final int RSVC success                             */
    public static final int RSVC_SUCCESS = 0;
    /* invalid public static final int RSVC objects                     */
    public static final int RSVC_INVALIDOBJ = 1;
    /* invalid argument passed to public static final int RSVC calls    */
    public static final int RSVC_INVALIDARG = 2;
    /* wrong service during dynamic loading     */
    public static final int RSVC_INVALIDSVC = 3;
    /* operation is unsupported (collection)    */
    public static final int RSVC_INVALIDOP = 4;
    /* not connected to low network service     */
    public static final int RSVC_NOTCONNECTED = 5;
    /* low level network service IO failed      */
    public static final int RSVC_IOFAILED = 6;
    /* conflicts of data types or tags          */
    public static final int RSVC_CONFLICT = 7;
    /* public static final int RSVC cannot find user request */
    /* (public static final int RSVCData)                    */
    public static final int RSVC_NOTFOUND = 8;
    /* time out                                 */
    public static final int RSVC_TIMEOUT = 9;
    /* public static final int RSVCData conversion error                */
    public static final int RSVC_CONVERT = 10;
    /* value out of range for device attribute  */
    public static final int RSVC_OUTOFRANGE = 11;
    /* insufficient access to perform request   */
    public static final int RSVC_NOACCESS = 12;
    /* change in access permission of device    */
    public static final int RSVC_ACCESSCHANGED = 13;
    /* channel has been disconnected         */    
    public static final int RSVC_DISCONNECTED = 60;
    /* channel has been reconnected          */    
    public static final int RSVC_RECONNECTED = 61;
    /* overflow existing data buffer         */
    public static final int RSVC_OVERFLOW = 62;
    /* the callback object will be deleted   */
    public static final int RSVC_DELETE_CALLBACK = 70;
    /* data has no key in the data               */
    public static final int RSVC_NOKEY = 80;
    /* connection timeout                        */    
    public static final int RSVC_CONN_TIMEOUT = 82;
    /* messages have been filtered               */
    public static final int RSVC_FILTERED = 83;
    /* no filtering applied                      */
    public static final int RSVC_NOFILTERING = 84;
    /* message is dropped                        */
    public static final int RSVC_DROPPED = 85;
    /* TCP io is bad file descriptor             */
    public static final int RSVC_BADIO = 86;
    /* data flow will coming (unfinished)        */
    public static final int RSVC_INCOMPLETE = 88;
    /* callback finished (monitor off)           */
    public static final int RSVC_CBK_FINISHED = 89;
    /* query callback is paused                  */    
    public static final int RSVC_PAUSED = 90;
    /* query message syntax error                */
    public static final int RSVC_QUERYMSG_ERR = 91;

    /* Request object state values               */
    /* request object is connected to device     */
    public static final int RSVC_STATE_CONNECTED = 0;
    /* request object is not connected           */
    public static final int RSVC_STATE_NOTCONNECTED = 1;
    /* request object is invalid                 */
    public static final int RSVC_STATE_INVALID = 2;

    /* Request object access values              */
    /* no access to specified attribute          */
    public static final int RSVC_ACCESS_NONE = 0;
    /* read-only access to attribute             */
    public static final int RSVC_ACCESS_READONLY = 1;
    /* read-write access to attribute            */
    public static final int RSVC_ACCESS_WRITE = 2;

    /* public static final int RSVCError class severity codes */
    /* informative message                   */
    public static final int RSVC_SEVERITY_INFO = 0;
    /* warning message                       */
    public static final int RSVC_SEVERITY_WARN = 1;
    /* error message                         */    
    public static final int RSVC_SEVERITY_ERROR = 2;
    /* severe or fatal error message         */    
    public static final int RSVC_SEVERITY_SEVERE = 3;

    public static final int RSVC_IOERROR = 6;
}
