// simple test for name server cdev interface
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <cdevSystem.h>
#include <cdevRequestObject.h>

#ifdef _WIN32
inline int strcasecmp ( const char * string1, const char * string2 )
	{
	return _stricmp(string1, string2);
	}
#endif

static void entryCallback (int status, void *,
			   cdevRequestObject&, cdevData& data)
{
  if (status == CDEV_SUCCESS || status == CDEV_INCOMPLETE) {
    printf ("New server is here \n");
    data.asciiDump ();
  }
  else if (status == CDEV_CBK_FINISHED) {
    printf ("entry monitor finished\n");
  }
  else if (status == CDEV_DISCONNECTED)
    printf ("Server is gone\n");
  else
    printf ("monitor callback failed\n");
}

static void monCallback (int status, void* /* arg */,
			 cdevRequestObject& /* obj */, cdevData& data)
{
  if (status == CDEV_SUCCESS)
    data.asciiDump ();
  else if (status == CDEV_CBK_FINISHED) {
    printf ("monitor finished\n");
    data.asciiDump ();
  }
  else if (status == CDEV_DISCONNECTED)
    printf ("server is dead\n");
  else
    printf ("monitor callback failed\n");
}

int main (int /* argc */, char** /* argv */)
{
  cdevSystem& system = cdevSystem::defaultSystem ();
  char temp[100];
  char comd[100];

  printf ("Enter cdev test command\n");
  scanf ("%s", comd);

  if (strcasecmp (comd, "get") == 0) {
    cdevRequestObject* obj = cdevRequestObject::attachPtr ((char *)"serverNs",
							   (char *)"get");

    if (obj) {
      cdevData result;
      cdevData out;
      printf ("enter namd and domain \n");
      char name[100], domain[100];
      scanf ("%s %s", name, domain);
      out.insert ((char *)"name", name);
      out.insert ((char *)"domain", domain);

      if (obj->send (out, result) == CDEV_SUCCESS) {
	result.asciiDump ();
      }
      else 
	printf ("get data failed\n");
    }
  }
  else if (strcasecmp (comd, "monitorOn") == 0) {
    cdevRequestObject* obj = cdevRequestObject::attachPtr ((char *)"serverNs", 
							   (char *)"monitorOn");
    if (obj) {
      cdevData result;
      cdevData out;
      printf ("enter namd and domain \n");
      char name[100], domain[100];
      scanf ("%s %s", name, domain);

      out.insert ((char *)"name", name);
      out.insert ((char *)"domain", domain);

      cdevCallback cbk (monCallback, 0);

      if (obj->sendCallback (out, cbk) != CDEV_SUCCESS) 
	printf ("monitor data failed\n");
      else {
	while (1)
	  system.pend ();
      }
      
      // now remove monitor
      cdevRequestObject* obj0 = cdevRequestObject::attachPtr ((char *)"serverNs", 
							      (char *)"monitorOff");
      if (obj0) {
	if (obj0->sendCallback (out, cbk) != CDEV_SUCCESS) 
	  printf ("monitor off data failed\n");
	else
	  system.pend (20.0);
      }
    }
  }
  else if (strcasecmp (comd, "monitorEntry") == 0) {
    cdevRequestObject* obj = cdevRequestObject::attachPtr ((char *)"serverNs", 
							   (char *)"monitorEntry");
    if (obj) {
      cdevCallback cbk (entryCallback, 0);

      if (obj->sendCallback (0, cbk) != CDEV_SUCCESS) 
	printf ("monitor entry failed\n");
      else {
	while (1)
	  system.pend ();
      }
      
      // now remove monitor
      cdevRequestObject* obj0 = cdevRequestObject::attachPtr ((char *)"serverNs", 
							      (char *)"monitorEntryOff");
      if (obj0) {
	if (obj0->sendCallback (0, cbk) != CDEV_SUCCESS) 
	  printf ("monitor off data failed\n");
	else
	  system.pend (20.0);
      }
    }
  }
return 0;
}
