!IF "$(VERBOSE)" != "YES"
MAKE = $(MAKE) -s VERBOSE=NO
!ENDIF

BASEDIR      = $(MAKEDIR)
BASEINCLUDES = $(BASEDIR)\include
BASEBIN      = $(BASEDIR)\bin
BASELIB      = $(BASEDIR)\lib
HEADERS      = dir\*.h dir\*.i

SRCONLY_DIRS = $(BASEDIR)\cdevClient\
               $(BASEDIR)\cdevContextMap\
               $(BASEDIR)\cdevMonitorTable\
               $(BASEDIR)\cdevPacket\
               $(BASEDIR)\cdevServer\
               $(BASEDIR)\cdevTagMap\
               $(BASEDIR)\common\

LIB_DIRS     = $(BASEDIR)\cdevReactor\
               $(BASEDIR)\NameServer\src\
	       $(BASEDIR)\NameServer\cdev\
	       $(BASEDIR)\lib\
	       $(BASEDIR)\liteClient
	       
UTIL_DIRS    = $(BASEDIR)\NameServer\dumpServer

EXAMPLE_DIRS = $(BASEDIR)\NameServer\examples\
               $(BASEDIR)\example

TEST_DIRS    = $(BASEDIR)\tests\
               $(BASEDIR)\cdevReactor\TimerTest\
	           $(BASEDIR)\cdevReactor\ServerTest

DOC_DIRS     = $(BASEDIR)\doc\

HEADER_DIRS  = $(BASEDIR)\cdevReactor\
               $(BASEDIR)\cdevTagMap\
               $(BASEDIR)\cdevContextMap\
               $(BASEDIR)\cdevMonitorTable\
               $(BASEDIR)\cdevPacket\
	       $(BASEDIR)\common\
	       $(BASEDIR)\cdevClient\
	       $(BASEDIR)\cdevServer\
	       $(BASEDIR)\NameServer\src\
	       $(BASEDIR)\NameServer\cdev 	       

CLEAN_DIRS   = $(SRCONLY_DIRS)\
	       $(LIB_DIRS)\
               $(UTIL_DIRS)\
	       $(EXAMPLE_DIRS)\
	       $(TEST_DIRS)\
	       $(DOC_DIRS)

all: hail directories headers shared utils fairwell

everything: hail directories headers shared utils examples apps other fairwell
			
hail:
	@echo ---------------------------------------------------------------
	@echo Building CDEV Generic Server for Target : $(ARCH)
	@echo ---------------------------------------------------------------
	
fairwell:
	@echo ---------------------------------------------------------------
	@echo CDEV Generic Server has been built for Target : $(ARCH)
	@echo ---------------------------------------------------------------

directories: 
	@echo =^> Creating directories for binary files
	-@if not exist $(BASEBIN) mkdir $(BASEBIN)
	-@if not exist $(BASELIB) mkdir $(BASELIB)
	-@copy $(BASEINCLUDES)\makeinclude\NMakefile.lib $(BASELIB)\NMakefile.mak
	@echo ^<= Done...

headers:
	@echo =^> Copying header files to include directory
	-@for %d in ($(HEADER_DIRS)) do @for %f in ($(HEADERS:dir=%d)) do @copy %f $(BASEINCLUDES) > nul
	@echo ^<= Done...
	
archives:
	@echo =^> Building archive version of libraries
	@for %d in ($(LIB_DIRS)) do @cd %d & $(MAKE) /NOLOGO SHOBJ=NO /f NMakefile.mak
	@echo <^= Done...

shared:
	@echo =^> Building shared version of libraries
	@for %d in ($(LIB_DIRS)) do @cd %d & $(MAKE) /NOLOGO SHOBJ=YES /f NMakefile.mak
	@echo ^<= Done...
	
utils:
	@echo =^> Building utility programs
	@for %d in ($(UTIL_DIRS)) do @cd %d & $(MAKE) /NOLOGO SHOBJ=YES /f NMakefile.mak
	@echo ^<= Done...
	 
examples:
	@echo =^> Building example programs
	@for %d in ($(EXAMPLE_DIRS)) do @cd %d & $(MAKE) /NOLOGO SHOBJ=YES /f NMakefile.mak
	@echo ^<= Done...

apps:
	@echo =^> Building test programs
	@for %d in ($(TEST_DIRS)) do @cd %d & $(MAKE) /NOLOGO SHOBJ=YES /f NMakefile.mak
	@echo ^<= Done...

other:
	@echo =^> Building miscellaneous applications and libraries
	@for %d in ($(SRCONLY_DIRS)) do @cd %d & $(MAKE) /NOLOGO SHOBJ=YES /f NMakefile.mak
	@echo ^<= Done...
		
clean:
	@echo =^> Cleaning CDEV Generic Server Directories
	@for %d in ($(CLEAN_DIRS)) do @if exist %d\NMakefile.mak cd %d & $(MAKE) /NOLOGO /f NMakefile.mak clean
	@echo ^<= Done...
	
purge:
	@echo =^> Purging CDEV Generic Server Directories
	@echo ^ ^ ^ =^> Removing header files
	-@for %f in ($(BASEINCLUDES)\*.h $(BASEINCLUDES)\*.i) do @erase %f 
	@echo ^ ^ ^ ^ ^ ^ Done...
	@for %d in ($(CLEAN_DIRS)) do @if exist %d\NMakefile.mak cd %d & $(MAKE) /NOLOGO /f NMakefile.mak purge
	-@if exist $(BASEDIR)\lib rmdir /s /q $(BASEDIR)\lib
	-@if exist $(BASEDIR)\bin rmdir /s /q $(BASEDIR)\bin
	@echo ^<= Done...

!IF "$(SUBTARGETDIR)" == ""
subtarget : 
	-@echo SUBTARGETDIR variable must be defined to build subtargets
!ELSE
!IF "$(SUBTARGET)" == ""
SUBTARGET = all
!ENDIF
subtarget :
	@cd $(SUBTARGETDIR)
	@$(MAKE) /NOLOGO /f NMakefile.mak $(SUBTARGET) 
!ENDIF	
