#include <cdevSystem.h>
#include <cdevRequestObject.h>
#include <cdevCallback.h>
#include <cdevGroup.h>

void callback (int, void *arg, cdevRequestObject &, cdevData &)
	{
	static int totalCount = 0;
	int * resultCount     = (int *)arg;
	(*resultCount)++;

	fprintf(stdout, "Total count = %i\n", ++totalCount);
	}
	
char * data[2][2][3] =
	{
	  {{"1", "2", "3"}, {"4", "5", "6"}},
	  {{"1", "2", "3"}, {"4", "5", "6"}},
	};

double dData[2][2][3] =
	{
	  {{1.1, 2.2, 3.3}, {4.4, 5.5, 6.6}},
	  {{1.7, 2.8, 3.9}, {4.11, 5.12, 6.13}}
	};

cdevBounds bounds[3] = 
	{{0, 2},
	 {0, 2},
	 {0, 3}};
	 
int main ( void )
	{
	int resultCount = 0;
	cdevData in;
	cdevRequestObject & req = cdevRequestObject::attachRef("device0", "get attrib0");
	cdevCallback cb (callback, &resultCount);
	
	in.insert("value", (char **)data, 12, 3);
	in.setBounds("value", bounds, 3);
	in.insert("severity", (double*)dData, 12, 3);
	in.setBounds("severity", bounds, 3);
	in.insert("status", "Testing");
	
	for(int i=0; i<10; i++)
		{
		resultCount = 0;

		for(int j=0; j<20; j++) 
			{
			req.sendCallback(in, cb);
			}
		while(resultCount<26) cdevSystem::defaultSystem().poll();
		}
	}
/*
#include "ScriptList.cc"

int main()
	{
	cdevData in, out;
	char * buf;
	int    bufLen;

	in.insert("value", (char **)data, 12, 3);
	in.setBounds("value", bounds, 3);
	in.insert("severity", (double*)dData, 12, 3);
	in.setBounds("severity", bounds, 3);
	in.insert("status", "Testing");

	ScriptData::data2Buffer(in, buf, bufLen);
	ScriptData::buffer2Data(buf, out);
	out.asciiDump();
	delete buf;
	}
*/
