/**************************************************************************
*
*  sis3320.h  - Header for SIS 3320 VME Flash ADC Library
*
*
*  Author: David Abbott 
*          Jefferson Lab Data Acquisition Group
*          JULY 2006
*
*/


#define S3320_MAX_BOARDS           4
#define S3320_MAX_ADC_CHANNELS     8
#define S3320_MAX_ADC_GROUPS       4
#define S3320_MAX_MEM_PAGES        8
#define S3320_MAX_EVENTS         512


/* Define Structures for access to ADC Local Memory map*/
struct adcGroup_struct {
  volatile unsigned int eventConfig;
  volatile unsigned int sampleLength;
  volatile unsigned int sampleStart;
  volatile unsigned int adcInputMode;
  volatile unsigned int nextSampleAdr[2];
  unsigned int blank1[2];
  volatile unsigned int actualSampleValue;
  volatile unsigned int test;
  volatile unsigned int ddr2MemLogicVerify;
  volatile unsigned int trigFlagClearCounter;
  volatile unsigned int triggerReg[2][2];
  unsigned int blank2[16368];
  volatile unsigned int eventDir[2][8192];
  unsigned int blank3[2064384];
};  


struct s3320_struct {
  volatile unsigned int csr;
  volatile unsigned int id;
  volatile unsigned int intConfig;
  volatile unsigned int intControl;
  volatile unsigned int acqCsr;
  volatile unsigned int extStartDelay;
  volatile unsigned int extStopDelay;
  unsigned int blank1;
  volatile unsigned int maxNofEvents;
  volatile unsigned int actualNofEvents;
  unsigned int blank2[2];
  volatile unsigned int cbltSetup;
  volatile unsigned int adcMemPage;
  unsigned int blank3[6];
  volatile unsigned int daqCsr;
  volatile unsigned int daqData;
  volatile unsigned int adcGain;
  unsigned int blank4;
  volatile unsigned int jtagTest;
  volatile unsigned int jtagControl;
  unsigned int blank5[230];
  volatile unsigned int reset;
  unsigned int blank6[3];
  volatile unsigned int armSample;
  volatile unsigned int disarmSample;
  volatile unsigned int startSample;
  volatile unsigned int stopSample;
  unsigned int blank7[2];
  volatile unsigned int resetMem;
  unsigned int blank8[4194037];
  volatile unsigned int eventConfig;
  volatile unsigned int sampleLength;
  volatile unsigned int sampleStartAdr;
  volatile unsigned int adcInputMode;
  unsigned int blank9[4194300];
  volatile struct adcGroup_struct adcG[S3320_MAX_ADC_GROUPS];
  volatile unsigned int adcData[S3320_MAX_ADC_CHANNELS][2097152];
};


#define S3320_BOARD_ID       0x33200000

#define S3320_BOARD_ID_MASK  0xffff0000
#define S3320_MAJOR_REV_MASK 0x0000ff00
#define S3320_MINOR_REV_MASK 0x000000ff


/* Define default interrupt vector/level */
#define S3320_VME_INT_VEC     0xbc
#define S3320_VME_INT_LEVEL   4

/* Control/Status Register bits */
#define S3320_STATUS_USER_LED          0x1
#define S3320_SET_USER_LED             0x1
#define S3320_CLEAR_USER_LED       0x10000

/* Aquisition Control register bits */
#define S3320_ENABLE_AUTOSTART          0x10
#define S3320_ENABLE_MULTIEVENT         0x20
#define S3320_ENABLE_INTERNAL_STOP      0x40
#define S3320_ENABLE_FP_STARTSTOP_MODE    0x100

#define S3320_PAGE_WRAP_ENABLE             0x10
#define S3320_SAMPLE_LEN_STOP_ENABLE       0x20
#define S3320_ACCUMULATOR_ENABLE          0x100
#define S3320_USER_IN_GATE_ENABLE         0x400
#define S3320_USER_IN_DATA_ENABLE        0x1000

#define S3320_SAMPLING     0x20000
#define S3320_ARMED        0x10000


/* Define Bit Masks */
#define S3320_INT_VEC_MASK        0x000000ff
#define S3320_INT_LEVEL_MASK      0x00000700
#define S3320_INT_ENABLE_MASK     0x00000800
#define S3320_INT_MODE_MASK       0x00001000

#define S3320_INT_SOURCE_ENABLE_MASK  0x0000000f
#define S3320_SAMPLE_LENGTH_MASK      0x00fffffc

#define S3320_PAGESIZE_MASK       0x0000000f
const int s3320_pagesize[16] = {0x1000000,0x400000,0x100000,0x40000,0x10000,0x4000,
				0x1000,0x400,0x200,0x100,0x80,0x40,0,0,0,0};

#define S3320_CLOCKSOURCE_MASK    0x00007000
const int   s3320_clocksource[] = {200000000,100000000,50000000,-1,
                                    0,-1,0,-1};
const char *s3320_clksrc_string[] = {"200 MHz","100 MHz","50 MHz","NONE",
                                      "Extern-x2","NONE","Extern-FP","P2"};

#define S3320_ADC_EDATA_MASK       0x0fff0000
#define S3320_ADC_ODATA_MASK       0x00000fff

#define S3320_DUMMY_DATA           0xdadadada

#define S3320_EDIR_NSAMP_ADDR_MASK      0x01ffffff
#define S3320_EDIR_WRAP                 0x10000000
#define S3320_EDIR_TRIG                 0x20000000


/* Define some macros */
#define S3320_IRQ_ENABLE(id)          (s3320p[id]->intConfig |= (S3320_INT_ENABLE_MASK))
#define S3320_IRQ_DISABLE(id)         (s3320p[id]->intConfig &= ~(S3320_INT_ENABLE_MASK))

#define S3320_IS_SAMPLING(id)         ((s3320p[id]->acqCsr)&0x30000)
#define S3320_IS_ARMED(id)            ((s3320p[id]->acqCsr)&0x10000)

