/*
 *	tclStruct package
 *  Support 'C' structures in Tcl
 *
 *  Written by Matthew Costello
 *  (c) 1995 AT&T Global Information Solutions, Dayton Ohio USA
 *
 *  See the file "license.terms" for information on usage and
 *  redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */
#include "stInternal.h"
#include "patchlevel.h"
STRUCT_SCCSID("@(#)tclStruct:stInit.c	1.2	95/09/12")

extern void *Struct_dl_handle;

/*
 * Struct_Init : initialize package
 */
int
Struct_Init(interp)
  Tcl_Interp *interp; /* The current Tcl interpreter */
{
    Struct_PkgInfo_t *cdata = (Struct_PkgInfo_t *)ckalloc(sizeof(Struct_PkgInfo_t));
    int v;
    int endian;

    /*  Initialize the Package Info structure.  */
    if (cdata == NULL) {
	Tcl_AppendResult(interp,"can't allocate TclStruct package info", (char *)NULL );
	return TCL_ERROR;
    }
    memset( (char *)cdata, 0x00, sizeof(Struct_PkgInfo_t) );

    /* Create the hash table for the named types. */
    Tcl_InitHashTable(Struct_TypeHash(cdata),TCL_STRING_KEYS);

    Tcl_CreateCommand(interp,"struct_typedef",Struct_TypeDefCmd,
		      (ClientData)cdata,NULL);
    Tcl_CreateCommand(interp,"struct_untypedef",Struct_UnTypeDefCmd,
		      (ClientData)cdata,NULL);
    Tcl_CreateCommand(interp,"struct_new",Struct_NewCmd,
		      (ClientData)cdata,NULL);
    Tcl_CreateCommand(interp,"struct_info",Struct_InfoCmd,
		      (ClientData)cdata,NULL);

    Tcl_CreateCommand(interp,"struct_copy",Struct_CopyCmd,
		      (ClientData)cdata,NULL);
    Tcl_CreateCommand(interp,"struct_read",Struct_ReadCmd,
		      (ClientData)cdata,NULL);
    Tcl_CreateCommand(interp,"struct_write",Struct_WriteCmd,
		      (ClientData)cdata,NULL);
    Tcl_CreateCommand(interp, "struct_data",Struct_DataCmd ,
		      (ClientData) NULL, (void (*)()) NULL);
    /*  Should the default numeric types be big-endian or little endian?
     */
    v = 1;
    switch (*(char *)&v) {
	case 0:	/* Big endian */
	    endian = STRUCT_FLAG_USE_ENDIAN|STRUCT_FLAG_BIG_ENDIAN;
	    break;
	case 1:	/* Little endian */
	    endian = STRUCT_FLAG_USE_ENDIAN;
	    break;
	default:
	    endian = 0;
    }
    /*
     * Register defined types.
     */ 
# define STRUCT_FLAG_SIGNED	0
# define STRUCT_FLAG_NUMERIC	\
	    STRUCT_FLAG_USE_STRICT|STRUCT_FLAG_USE_NULLOK|STRUCT_FLAG_USE_SIGN| \
	    STRUCT_FLAG_ALIGN_SIZE|STRUCT_FLAG_STRICT|STRUCT_FLAG_NULL_OK
    if (Struct_RegisterBuiltInType(cdata, interp,
		"char", sizeof(char),
		STRUCT_FLAG_USE_STRICT|STRUCT_FLAG_USE_NULLOK|
		STRUCT_FLAG_TRACE_ARRAY|STRUCT_FLAG_STRICT|STRUCT_FLAG_NULL_OK,
		Struct_TraceChar) == TCL_ERROR)
	return TCL_ERROR;
    if (Struct_RegisterBuiltInType(cdata, interp,
		"byte", sizeof(char),
		STRUCT_FLAG_NUMERIC|STRUCT_FLAG_SIGNED|endian,
		Struct_TraceInt) == TCL_ERROR)
	return TCL_ERROR;
    if (Struct_RegisterBuiltInType(cdata, interp,
		"ubyte", sizeof(unsigned char),
		STRUCT_FLAG_NUMERIC|STRUCT_FLAG_UNSIGNED|endian,
		Struct_TraceInt) == TCL_ERROR)
	return TCL_ERROR;
    if (Struct_RegisterBuiltInType(cdata, interp,
		"short", sizeof(short),
		STRUCT_FLAG_NUMERIC|STRUCT_FLAG_SIGNED|endian,
		Struct_TraceInt) == TCL_ERROR)
	return TCL_ERROR;
    if (Struct_RegisterBuiltInType(cdata, interp,
		"ushort", sizeof(unsigned short),
		STRUCT_FLAG_NUMERIC|STRUCT_FLAG_UNSIGNED|endian,
		Struct_TraceInt) == TCL_ERROR)
	return TCL_ERROR;
    if (Struct_RegisterBuiltInType(cdata, interp,
		"int", sizeof(int),
		STRUCT_FLAG_NUMERIC|STRUCT_FLAG_SIGNED|endian,
		Struct_TraceInt) == TCL_ERROR)
	return TCL_ERROR;
    if (Struct_RegisterBuiltInType(cdata, interp,
		"uint", sizeof(unsigned int),
		STRUCT_FLAG_NUMERIC|STRUCT_FLAG_UNSIGNED|endian,
		Struct_TraceInt) == TCL_ERROR)
	return TCL_ERROR;
    if (Struct_RegisterBuiltInType(cdata, interp,
		"long", sizeof(long),
		STRUCT_FLAG_NUMERIC|STRUCT_FLAG_SIGNED|endian,
		Struct_TraceInt) == TCL_ERROR)
	return TCL_ERROR;
    if (Struct_RegisterBuiltInType(cdata, interp,
		"ulong", sizeof(unsigned long),
		STRUCT_FLAG_NUMERIC|STRUCT_FLAG_UNSIGNED|endian,
		Struct_TraceInt) == TCL_ERROR)
	return TCL_ERROR;
    if (Struct_RegisterBuiltInType(cdata, interp,
		"float", sizeof(float),
		STRUCT_FLAG_NUMERIC|STRUCT_FLAG_SIGNED,
		Struct_TraceFloat) == TCL_ERROR)
	return TCL_ERROR;
    if (Struct_RegisterBuiltInType(cdata, interp,
		"double", sizeof(double),
		STRUCT_FLAG_NUMERIC|STRUCT_FLAG_SIGNED,
		Struct_TraceDouble) == TCL_ERROR)
	return TCL_ERROR;

    if (Struct_RegisterBuiltInType(cdata, interp,
		"hex", sizeof(char),
		STRUCT_FLAG_USE_STRICT|
		STRUCT_FLAG_TRACE_ARRAY|STRUCT_FLAG_STRICT,
		Struct_TraceHex) == TCL_ERROR)
	return TCL_ERROR;
    if (Struct_RegisterBuiltInType(cdata, interp,
		"str", sizeof(char *),
		STRUCT_FLAG_USE_STRICT|STRUCT_FLAG_USE_NULLOK|
		STRUCT_FLAG_ALIGN_SIZE|STRUCT_FLAG_STRICT|STRUCT_FLAG_NULL_OK,
		Struct_TraceString) == TCL_ERROR)
	return TCL_ERROR;

    /*  Set up variables.  */
    Tcl_SetVar(interp, "struct_version", STRUCT_VERSION, TCL_GLOBAL_ONLY);
    Tcl_SetVar(interp, "struct_patchLevel", STRUCT_PATCH_LEVEL,
		TCL_GLOBAL_ONLY);
#ifdef __sun
    Struct_dl_handle = dlopen(0,2);
#endif

    return TCL_OK;
}


/*
 *  Retrieve the tclStruct package's ClientData pointer.
 *  This is needed because certain external functions require
 *  this pointer.
 */
ClientData
Struct_GetClientData(interp)
  Tcl_Interp *interp;
{
    Tcl_CmdInfo infobuf;
    if (Tcl_GetCommandInfo(interp,"struct_typedef", &infobuf) &&
	infobuf.clientData != NULL) {
	    return infobuf.clientData;
    }
    return NULL;
}
