'\" @(#)tclStruct:new.n	1.3	95/09/08
.so man.macros
.TH struct_new n "" TclStruct "TclStruct Built-In Commands"
.BS
.SH NAME
struct_new \- Create a new object
.SH SYNOPSIS
\fBstruct_new\0\fIobjName\fR|\fB#auto\0\fItype\0\fR?\fIpointer\fR|\fIobj\fR?
.BE

.SH DESCRIPTION
.PP
Create a object with a name of \fIobjName\fR.  The special
object name \fB#auto\fR indicates that the name of the object is
defined by the struct package and the generated value is returned as
the result of the struct_new call.
The \fItype\fR must be a valid type.
If a third argument is specified, then the object references
an existing data area, otherwise a new memory buffer is created and
initialized to binary zeros.
.PP
The object is created as a Tcl array with a name of \fIobjName\fR.
A Tcl variable trace is placed on the array to implement
access to the C structure.
The object will be removed when it is either
explicitly \fBunset\fR(n) or
when leaving the scope of \fIobjName\fR.
.PP
An object cannot be passed by value to a procedure since it is created
as a Tcl array.  The \fBupvar\fR(n) command should be used when passing
an object by reference.  The script \fBstruct_show\fR(n) is a good
example of how this can be done.
.PP
The \fB#auto\fR cannot be used to create a global instance
of an object.  Creation of a global object with a unique name can be
done with a sequence of four commands:
.DS
set objname [struct_new #auto \fItype\fP]
global $objname
unset $objname
struct_new $objname \fItype\fR
.DE

.SH "ACCESSING STRUCTURE DATA"
.PP
Structure objects may be references in one of two ways:
using an \fIobjName\fR created by \fBstruct_new\fR,
or using a typed pointer.
.PP
An object reference using an \fIobjName\fR looks to Tcl like
an array reference.
.br
	\fIobjName\fB(\fIstring\fB)\fR
.br
TclStruct uses a trace procedure to parse the \fIstring\fR
find the part of the object being referred to.  The \fIstring\fR
consists of zero or more parts, each separated by a period '.' .
Each part is read in sequence (starting at the left) and is used
to modify the reference to the object.  The following are the
valid parts:
.RS
.TP
\fIelemName\fR
When the object is a structure, a single element of that structure
is specified by using the element's name.
The object may also be a pointer to a structure and TclStruct
will automatically perform one level of dereferencing.
.\" .TP
.\" \fB0\fR
.\" When an object is a pointer, the
.TP
\fInum\fR
When an object is an array, a numeric index (from 0 to n-1) will
reference a single element in the array.
.IP ""
Pointers may also be dereferenced using a numeric index.  When the
pointer is "strict" the only valid index is zero, otherwise both
positive and negative indices may be specified.
.TP
""
An empty part will dereference a pointer equivalently to "0".
.TP
\fB_\fItypeName\fB_\fR
A part consisting of a \fItypeName\fR surrounded by underscores will
change the type of the object being referenced without changing its
address or size.  The size of \fItypeName\fR must be compatible with
the underlying size of the object.
.TP
\fB_addr_\fR
The special \fItypeName\fR of "addr" may be used to read the address
of the object as a pointer.
.RE
.PP
The degenerate form "\fIobjName\fB()\fR" is used to refer to the
whole object.
When passed to a TclStruct command, an object reference can be
passed without the '()'s.
.PP
Typed pointers are not managed by
the TclStruct package, but may be created on the fly to refer
to data allocated elsewhere.  A typed pointer has the format
.br
	\fItypeName\fB#\fIaddress\fR
.br
where \fItypeName\fR is the name of a defined type, and \fIaddress\fR
is the decimal address in memory where the data resides.

.SH EXAMPLES
.PP
To create an array of 10 integers:
.RS
struct_new myarray int*10
.RE
To create an object that consists of a single integer that is
the 6th element of myarray:
.RS
struct_new myint int myarray(5)
.RE
To access the third element of the array
.RS
set myarray(2)	6
.RE
.PP
The following example demonstrates the use of pointers and de-referencing
various fields:
.DS
struct_typedef extype {struct
	{char*8 name}
	{ushort flags}
	{ushort count}
	{^extype next}
}

struct_new first extype
struct_new last extype

# Initialize the structures
set first() {first 22 1 last()}
set last() {last 17 3 0}

# Access portions
puts "first       = $first()"
puts "first.name  = $first(name)"
puts "last        = $last()"
puts "last        = $first(next.)"
puts "last.count  = $first(next.count)"
puts "last.name.1 = $first(next.name.1)"
puts "last        = $first(next.._hex_)"
.DE
The output is
.DS
first       = {first 22 1 extype#134745056}
first.name  = first
last        = {last 17 3 0}
last        = {last 17 3 0}
last.count  = 3
last.name.1 = a
last        = 6c617374000000001100030000000000
.DE

.SH WARNINGS
.PP
User traces placed on the array
or its elements are not guaranteed to work in a consistent fashion.
.PP
No management is done on the third argument.  It is the users
responsibility to prevent dangling pointers caused by removal
of the original object.
.SH KEYWORDS
struct, variable
