/****************************** Copyright Notice ******************************
 *                                                                            *
 * Copyright (c) 1992 Universities Research Association, Inc.                 *
 *               All Rights Reserved.                                         *
 *                                                                            *
 ******************************************************************************/
/*

File:		fb_error.h
=====

Author:		Jim Pangburn
=======		CDF on-line computing
		Fermilab MS 318
		P.O. Box 500
		Batavia, IL  60510
		(708) 840-2207

	e-mail: "pangburn@fnal.fnal.gov"

Creation date:	4-Feb-1992
==============

Revision history:-
=================

 4-Feb-1992 JP	creation
20-Aug-1992 MV	added in murmur generated error codes	


Description:-
============

	Header file for FASTBUS standard routine error/status codes.

Macros:-
=======
*/

#ifndef INCfberror
#define INCfberror

/*  Error code short names - generated by the murmur message faciltiy 
   ------------------------------------------------------------------ */

#include "fb_error_code_msg_c.h"
#define FB_GET_ERROR_VALUE(err) (((unsigned long)(err) & FB_ERROR_BITS) >> FB_SEVERITY_SHIFT)


/*  define some fixed points */

#define FB_ERROR_HARDWARE_MIN	1
#define FB_ERROR_HARDWARE_MAX	(FB_GET_ERROR_VALUE(FEWTTO)) 
#define FB_ERROR_MAX		(FB_GET_ERROR_VALUE(FEFIFO))

/*  map long names to short names  */

#define	FB_ERR_ACCESS_DATA_BUFFER		FEBUF
#define FB_ERR_ABORT_ACTION			FEABA
#define FB_ERR_ADDRESS_RELEASE_TIMEOUT		FEAKDO
#define FB_ERR_AK_TIMEOUT			FEAKTO
#define FB_ERR_ALREADY_CONNECT			FEACON
#define FB_ERR_BAD_PARAMETER_VALUE		FEBPRV
#define FB_ERR_BLOCK_DATA_SS2			FEBSS2
#define FB_ERR_BUFFER_OVERFLOW 			FEBOV
#define FB_ERR_CLOSED				FECLSD
#define FB_ERR_CONNECT				FECON
#define FB_ERR_DATA_PARITY_ERROR 		FEDPE
#define FB_ERR_DATA_SS0 			FEDSS0
#define FB_ERR_DATA_SS1 			FEDSS1
#define FB_ERR_DATA_SS2 			FEDSS2
#define FB_ERR_DATA_SS3 			FEDSS3
#define FB_ERR_DATA_SS4 			FEDSS4
#define FB_ERR_DATA_SS5 			FEDSS5
#define FB_ERR_DATA_SS6 			FEDSS6
#define FB_ERR_DATA_SS7 			FEDSS7
#define FB_ERR_DISCONNECT 			FEDCON
#define FB_ERR_DK_RELEASE_TIMEOUT		FEDKDO
#define FB_ERR_DK_TIMEOUT 			FEDKTO
#define FB_ERR_ENV_ACTIVE 			FEENAC
#define FB_ERR_ENV_ID_OVERFLOW 			FEEIOV
#define FB_ERR_ENV_OVERFLOW 			FEENOV
#define FB_ERR_ENV_RELEASE 			FEEREL
#define FB_ERR_ERROR 				FEERR
#define FB_ERR_FATAL 				FEFTL
#define FB_ERR_HARDWARE_ERROR 			FEHERR
#define FB_ERR_HARDWARE_WARNING 		FEHWRN
#define FB_ERR_HOLDING_ADDRESS 			FEHDAS
#define FB_ERR_HOLDING_BUS 			FEHDFB
#define FB_ERR_IGNORE 				FEIGNO
#define FB_ERR_ILL_PARAMETER_VALUE 		FEIPRV
#define FB_ERR_ILL_SEQ_BUFFER_ID 		FEILSI
#define FB_ERR_IMPLEMENTATION 			FEIMP
#define FB_ERR_INFO 				FEINFO
#define FB_ERR_INVALID_ENV_ID 			FEINEI
#define FB_ERR_INVALID_LIST_POINTER 		FEINLI
#define FB_ERR_INVALID_PORT_ID 			FEINPO
#define FB_ERR_INVALID_SEQ_BUFFER_ID 		FEINSI
#define FB_ERR_LAST_PRIMARY_ADDRESS 		FELPAD
#define FB_ERR_LAST_SECONDARY_ADDRESS 		FELSAD
#define FB_ERR_LAST_LIST_POINTER 		FELPTR
#define FB_ERR_LIST_OVERFLOW 			FELOV
#define FB_ERR_LONG_TIMEOUT 			FELOTO
#define FB_ERR_LONG_TIMER_ON 			FELOON
#define FB_ERR_NO_ADDRESS_CONNECTION 		FENOAS
#define FB_ERR_NO_MORE_STATUS 			FENMST
#define FB_ERR_NO_PRIVILEGE 			FENPRV
#define FB_ERR_NO_SUPPLEMENTARY_STATUS 		FENSST
#define FB_ERR_NORMAL 				FENORM
#define FB_ERR_NOT_CONNECTED 			FENCON
#define FB_ERR_NOT_HOLDING_MASTERSHIP 		FENHMA
#define FB_ERR_NOT_MASTER 			FENOMA
#define FB_ERR_OPEN 				FEOPEN
#define FB_ERR_OPERATION_PENDING 		FEPEND
#define FB_ERR_PIPELINE_TRANSFER 		FEPPL
#define FB_ERR_POINTER_OVERFLOW 		FEPOV
#define FB_ERR_PORT_ACTIVE 			FEPAC
#define FB_ERR_PORT_ALREADY_ALLOCATED 		FEPAL
#define FB_ERR_PORT_NOT_ALLOCATED 		FEPNAL
#define FB_ERR_PORT_NOT_AVAILABLE 		FEPNOP
#define FB_ERR_PORT_OWNED 			FEPOWN
#define FB_ERR_PRIMARY_ADDRESS_SS0 		FEASS0
#define FB_ERR_PRIMARY_ADDRESS_SS1 		FEASS1
#define FB_ERR_PRIMARY_ADDRESS_SS2 		FEASS2
#define FB_ERR_PRIMARY_ADDRESS_SS3 		FEASS3
#define FB_ERR_PRIMARY_ADDRESS_SS4 		FEASS4
#define FB_ERR_PRIMARY_ADDRESS_SS5 		FEASS5
#define FB_ERR_PRIMARY_ADDRESS_SS6 		FEASS6
#define FB_ERR_PRIMARY_ADDRESS_SS7 		FEASS7
#define FB_ERR_READ_ONLY_PARAMETER 		FEROPA
#define FB_ERR_RETRY 				FERTY
#define FB_ERR_SAD_TIMEOUT 			FESATO
#define FB_ERR_SECONDARY_ADDRESS_SS0 		FESSS0
#define FB_ERR_SECONDARY_ADDRESS_SS1 		FESSS1
#define FB_ERR_SECONDARY_ADDRESS_SS2 		FESSS2
#define FB_ERR_SECONDARY_ADDRESS_SS3 		FESSS3
#define FB_ERR_SECONDARY_ADDRESS_SS4 		FESSS4
#define FB_ERR_SECONDARY_ADDRESS_SS5 		FESSS5
#define FB_ERR_SECONDARY_ADDRESS_SS6 		FESSS6
#define FB_ERR_SECONDARY_ADDRESS_SS7 		FESSS7
#define FB_ERR_SEQ_BUFFER_ACTIVE 		FESBAC
#define FB_ERR_SEQ_BUFFER_EXISTS 		FESBEX
#define FB_ERR_SEQ_BUFFER_ID_OVERFLOW 		FESIOV
#define FB_ERR_SOFT_TIMER_ON 			FESOON
#define FB_ERR_SOFTWARE_TIMEOUT 		FESOTO
#define FB_ERR_STATUS_NOT_FOUND 		FENSF
#define FB_ERR_STATUS_OVERFLOW 			FESOV
#define FB_ERR_SUCCESS 				FESUCC
#define FB_ERR_UNKNOWN 				FEOOPS
#define FB_ERR_UNKNOWN_PARAMETER 		FEUNPR
#define FB_ERR_UNS_PORT_OPERATION 		FEUPOP
#define FB_ERR_UNS_PARAMETER 			FEUPAR
#define FB_ERR_UNS_ROUTINE 			FEUROU
#define FB_ERR_USER_ARRAY_OVERFLOW 		FEUAOV
#define FB_ERR_WAIT_TIMEOUT 			FEWTTO
#define FB_ERR_WARNING 				FEWARN

/**** BEGIN FSCC specific for now ****/
#define FB_ERR_WRITE_FIFO			FEFIFO
/**** END FSCC specific for now ****/

/*  #define FB_ERR_ILL_BUFFER_MODE 			FEILBM  */


#endif 	/* (ifdef INCfberror) */
