/* 
   cm_interface.h - interface to common memory
   Definitions of types used in the handshaking package
   */

#ifndef TRUE
#define TRUE		1
#define FALSE		0
#endif

#define or		||
#define and		&&
#define OR		||
#define AND		&&

#ifndef BOOLEAN
#define BOOLEAN
typedef int boolean;
#endif

#define ANY_STATUS		0

/* access types, i.e. roles */
#define CM_ROLE_NULL			000
#define CM_ROLE_READER			001
#define CM_ROLE_WAKEUP			002
#define CM_ROLE_NONXWRITER		004
#define CM_ROLE_NONEXCLUSIVE_WRITER	004
#define CM_ROLE_EXCLUSIVE_WRITER	010
#define CM_ROLE_XWRITER			010

#define CM_VAR_TRANSPARENT              0
#define CM_VAR_CHAR                     1
#define CM_VAR_SHORT                    2
#define CM_VAR_LONG                     3
#define CM_VAR_INT                      4
#define CM_VAR_DOUBLE                   5
#define CM_VAR_STRING                   6  
#define CM_VAR_POINTER                  7

#define CM_VARIABLENAMELEN	        80
/* definitions for command associations */

typedef int cm_command_association;
#define cm_set_command_association(cmd,assoc) cmd->command_association = (assoc)
#define cm_get_command_association(cmd,assoc) ((assoc) = cmd->command_association)

extern cm_command_association input_command_association;

#define var_in_use(v)	(v->inuse)

struct usr_var_role {
  unsigned reader : 1;
  unsigned nonxwriter : 1;
  unsigned xwriter : 1;
  unsigned wakeup : 1;
};

typedef struct {
  char name[CM_VARIABLENAMELEN];
  cm_value data;	/* actual user data */
  struct usr_var_role role;
  unsigned long old_count;	/* when last read */
  unsigned long count;		/* nth definition of this var */
  /* zero means "never been written" */
  
  /* the following are tags noting: */
  int old_command_association;	/* when last read */
  int command_association;	/* unique identifier tying this to a
				   single command and multiple
				   statii */
  struct timeval timestamp;	/* when this data was written */
  /* the following is not transmitted to the cdm */
  struct {
    unsigned declared	: 1;
    unsigned written 	: 1;
    unsigned inuse		: 1;
    unsigned undeclared	: 1;
  } status;
  unsigned char declared;
} cm_variable, cm_command_variable, cm_status_variable;

/* the following definitions are correctly eaten by the C compiler */
cm_value *cm_get_value();
void cm_set_value();
boolean cm_get_new_command_value();
void cm_set_new_command_value();
boolean cm_new_command_pendingp();
boolean cm_status_equal();
boolean cm_status_synchronizedp();
void cm_set_status_value();
cm_variable *cm_declare();
cm_variable *next_user_variable();

#define cm_command_association int


