/* Definition of a NET trigger source */
#include <time.h>

#define PORT_TYPE_NAME          1
#define PORT_TYPE_NUMBER        2

#define PORT_NAME(name)         PORT_TYPE_NAME,name,(u_short)0
#define PORT_NUMBER(number)     PORT_TYPE_NUMBER,0,&number

/* sockettypes are SOCKET_STREAM and SOCKET_DGRAM */

#define DATAGRAM_FLAGS  0               /* for recv and sendto */

#define SERVER          1
#define CLIENT          2
#define NAMED_CLIENT    3
#define UDP_SERVER      4
#define BROADCAST       5

static int NET_handlers[32],NETflag,NETmask;
static int network_errno__;
static int NET_WRITER__;
static char hosts[32][40];
static long NET_RD_FDS__[32];
static long NET_CURR_FDS__[32];
static char NET_FDS_OK__[32];
static char hostname[100];

extern struct timeval select_server_stream_TO;

static int NET_TEST (int code){ 
  long fds,ix;

  fds = NET_RD_FDS__[code] = NET_RD_FDS__[code] | (1<<code) ;
  NET_CURR_FDS__[code] = select_server_stream (code, &NET_RD_FDS__[code]);
  if (NET_CURR_FDS__[code] > 0) {
    NET_FDS_OK__[NET_CURR_FDS__[code]] = 1; /* this fd must be good to read on */
    return(1);     
  } else {
    return(0);
  }
}

#define NET_INIT {NETmask = 0;bzero(NET_FDS_OK__,32);select_server_stream_TO.tv_sec = 0;select_server_stream_TO.tv_usec = 0;}

#define NET_ASYNC(code,id) {printf("linking code %d to id %d\n",code,id); \
			       NET_handlers[code] = (id);}

#define NET_SYNC(code,id) {printf("linking code %d to id %d\n",code,id); \
			      NET_handlers[code] = (id);}

#define NET_SETA(code) {theIntHandler(NET_handlers[code]);}

#define NET_SETS(code) NETmask |= (1<<code);

#define NET_ENA(code) printf("Enable NET NET consumer %d\n",code);NETmask |= (1<<code);

#define NET_DIS(code)  {printf("Disable NET NET consumer\n");NETmask &= ~(1<<code);}

#define NET_CLRS(code) NETmask = 0;

#define NET_GETID(code) NET_handlers[code]

#define NET_START(val)	 {printf("Start NET NET consumer\n");NETflag = val;}

#define NET_STOP(val)	 {int ix;for (ix=0;ix<32;ix++) if( NET_FDS_OK__[ix]) close(ix);NETflag = 0;}

#define NET_ENCODE(code) (code)

void NETOPEN(s,fd,cs) 
char *s;
int *fd;
int cs;
{
  static short port;
  static char *host;
  char temp[100];
  int ix;
  cm_variable *vh,*vp;
  port = 0;
  
  for (ix=0;ix<32;ix++) 
    if ((hosts[ix]) && (strcmp(hosts[ix],s) == 0)) {
      eprintf(4,"connection to %s already exists\n",s);
      return;
    } 
  
  eprintf(4,"connecting to %s\n",s);
  if (cs == CLIENT) {
    eprintf(4,"NET: client\n");
    strcpy(temp,s);
    strcat(temp,":port");
    vh = cm_declare(temp,CM_ROLE_READER | CM_ROLE_WAKEUP, &port, 2, CM_VAR_SHORT);
    strcpy(temp,s);
    strcat(temp,":host");
    vp = cm_declare(temp,CM_ROLE_READER,&host,0,CM_VAR_STRING);
    while (port == 0)
      cm_sync(CM_WAIT_READ);
    printf("cmm reports server on port %d host %s\n",port,host);

    *fd = initport(PORT_NUMBER(port),
		   CLIENT,
		   SOCK_STREAM,
		   host);
    cm_undeclare(vh);
    cm_undeclare(vp);
    strcpy(hosts[*fd],s);
    NET_FDS_OK__[*fd] = 1;	/* ok to write on this fd */
  } else {
    char ourname[100];

    eprintf(10,"NET: server\n");
    port = 0;
    
    gethostname(hostname,sizeof(hostname));
    strcpy(ourname,rol->name);
    strcat(ourname,":");
    strcat(ourname,s);

    strcpy(temp,ourname);
    strcat(temp,":port");

    vp = cm_declare(temp,CM_ROLE_NONXWRITER,&port,2,CM_VAR_SHORT);
    
    strcpy(temp,ourname);
    strcat(temp,":host");
    
    vh = cm_declare(temp,CM_ROLE_NONXWRITER,hostname,0,CM_VAR_STRING);

    *fd = initport(PORT_NUMBER(port),SERVER,SOCK_STREAM,(char *)0);

    printf("server listening on port %d\n",port);
    
    if (*fd < 0) {
      fprintf(stderr,"initport() = %d\n",*fd);
      exit(-1);
    }
    
    cm_update_variable(vh);
    cm_update_variable(vp);
    
    strcpy(hosts[*fd],s);

    cm_sync(CM_NO_WAIT);
  }
}

void NETCREOPEN(fd,cs)
int *fd,cs;
{
  NETOPEN(hosts[*fd],fd,cs);
}
#define NETCLOSE 
/* End  NET trigger source */

