/* # 1 "fscc.c" */
/* # 1 "./inc/rol.h" 1 3 */
typedef void (*VOIDFUNCPTR) ();
typedef unsigned long (*FUNCPTR) ();
typedef struct semaphore *SEM_ID;
typedef unsigned long time_t;
static void __download ();
static void __prestart ();
static void __end ();
static void __pause ();
static void __go ();
static void __done ();
static void __status ();
static int theIntHandler ();
/* # 1 "./inc/libpart.h" 1 */
extern char	*malloc();
typedef struct danode			       
    {
    struct danode         *n;	               
    struct danode         *p;	               
    struct rol_mem_part   *part;	           
    int                    fd;		       
    char                  *current;	       
    unsigned long          left;	       
    unsigned char          type;               
    unsigned char          source;             
    void                   (*reader)();        
    unsigned long          length;	       
    unsigned long          data[1];	       
    } DANODE;
typedef struct alist			       
    {
    DANODE        *f;		               
    DANODE        *l;		               
    int          c;			       
    } DALIST;
typedef struct rol_mem_part *ROL_MEM_ID;
typedef struct rol_mem_part{
    DANODE	 node;		 
    DALIST	 list;		 
    char	 name[40];	 
    int		 size;		 
    int		 incr;		 
    int		 total;		 
    long         part[1];	 
} ROL_MEM_PART;
static DALIST  partList;  
libPartInit()
{
  {bzero((char *) (&partList), sizeof(DALIST));} ;
}
ROL_MEM_ID partCreate (name, size, c, incr)
     char *name;		 
     int size;			 
     int c;			 
     int incr;			 
{
  ROL_MEM_ID pPart;
  pPart = (ROL_MEM_ID) malloc (sizeof(ROL_MEM_PART));
  bzero ((char *) pPart, sizeof(ROL_MEM_PART));
  if (pPart != ((void *) 0) )
    {
      {bzero((char *) (&(pPart->list)), sizeof(DALIST));} ;
      pPart->size = (size< sizeof(DANODE) ?  sizeof(DANODE) : size) ;
      pPart->incr = (0< incr ?  incr : 0) ; 
      pPart->total = 0;
      strcpy(pPart->name, name);
      if (name && strlen(name) == 0)
	pPart->name[0] = ((void *) 0) ;
{if(! (&partList)->c ){(&partList)->f = (&partList)->l = ( (DANODE *)pPart);( (DANODE 
*)pPart)->p = 0;} else {( (DANODE *)pPart)->p = (&partList)->l;(&partList)->l->n = ( (DANODE 
*)pPart);(&partList)->l = ( (DANODE *)pPart);} ( (DANODE *)pPart)->n = 0;(&partList)->c++;} ;       partIncr (pPart, c);
      printf("Created new partition -- %s\n",pPart->name);
    }
  return pPart;
}
ROL_MEM_ID partFindByName (char *name)
{
  ROL_MEM_ID	pPart = (ROL_MEM_ID) ((&partList)->f) ;
  while (pPart != ((void *) 0) )
    {
      if (pPart->name && strcmp(pPart->name, name) == 0)break;
      pPart = (ROL_MEM_ID) (((DANODE *)pPart)->n) ;
    }
  return (pPart);
}
void partFree(ROL_MEM_ID pPart)
{
  DANODE *the_node;
  while (pPart->list.c) {
{(the_node) = 0;if((&(pPart->list))->c){(&(pPart->list))->c--;(the_node) = 
(&(pPart->list))->f;(&(pPart->list))->f = (&(pPart->list))->f->n;};if (!(&(pPart->list))->c) (&(pPart->list))->l = 0;} ;     free(the_node);
  }
{if (( (DANODE *)pPart)->p) {( (DANODE *)pPart)->p->n =( (DANODE *)pPart)->n;} else 
{(&partList)->f = ( (DANODE *)pPart)->n;} if (( (DANODE *)pPart)->n) {( (DANODE *)pPart)->n->p =( (DANODE 
*)pPart)->p;} else {(&partList)->l = ( (DANODE *)pPart)->p;} (&partList)->c--;if ((&partList)->c==0) 
(&partList)->f = (&partList)->l = (DANODE *)0;( (DANODE *)pPart)->p=( (DANODE *)pPart)->n= (DANODE *)0;} ;   free(pPart);
}
void partFreeAll()
{
  ROL_MEM_ID	pPart = (ROL_MEM_ID) 0;
  if (((&partList)->c) ) {
    pPart = (ROL_MEM_ID) ((&partList)->f) ;    
    while (pPart != ((void *) 0) )
      {
	printf("partFreeAll - Freeing Memory Partition %s \n",pPart->name);
	partFree(pPart);
	pPart = (ROL_MEM_ID) ((&partList)->f) ;
      }
  } else {
    printf("partFreeAll - No Memory Partitions to Free\n");
  }
}
void partIncr (pPart,c)
     ROL_MEM_ID pPart;		 
     int	c;		 
{
  register char *block;
  unsigned bytes;
  int actual = c;		 
  pPart->total += c;
  if ((pPart == ((void *) 0) )||(c == 0)) return;
  while (actual--)
    {
      block = malloc (pPart->size);
      if (block == ((void *) 0) )
	return;
      bzero((char *) block, pPart->size);
      ((DANODE *)block)->part = pPart;  
{if(! (&pPart->list)->c ){(&pPart->list)->f = (&pPart->list)->l = ((DANODE 
*)block);((DANODE *)block)->p = 0;} else {((DANODE *)block)->p = (&pPart->list)->l;(&pPart->list)->l->n = 
((DANODE *)block);(&pPart->list)->l = ((DANODE *)block);} ((DANODE *)block)->n = 
0;(&pPart->list)->c++;} ;     }
}
static void partHdr ()
{
  printf("Address    total  free  busy   size  incr  (KBytes)  Name\n");
  printf("-------    -----  ----  ----   ----  ----  --------  ----\n");
}
static void partPrint (pPart)
     ROL_MEM_ID	pPart;    
{
  int freen;
  printf("0x%08x  ",pPart);
  if (pPart != ((void *) 0) )
    {
      freen = ((&pPart->list)->c) ; 
      printf("%4d  %4d  %4d   %4d  %4d  (%d)       %s\n",
	    pPart->total,
	     freen,
	     pPart->total - freen,
	     pPart->size,
	     pPart->incr,
	     (((pPart->total * pPart->size) + 1023) / 1024),
	     pPart->name
	     );
    }
}
int partStats (pPart)
     ROL_MEM_ID	pPart;
{
  partHdr ();
  partPrint (pPart);
  return (0);
}
int	partStatsAll ()
{
  ROL_MEM_ID	pPart = (ROL_MEM_ID) ((&partList)->f) ;
  partHdr ();
  while (pPart != ((void *) 0) )
    {
      partPrint (pPart);
      pPart = (ROL_MEM_ID) (((DANODE *)pPart)->n) ;
    }
  return (0);
}
int partPrintList(alist)
     DALIST *alist;
{
  DANODE *theNode;
  printf("alist->f         %x\n",alist->f);
  printf("alist->l         %x\n",alist->l);
  printf("alist->c         %d\n",alist->c);
  theNode = ((alist)->f) ;
  while (theNode) {
    printf ("part %x prev %x self %x next %x left %d fd %d\n",
	    theNode->part,
	    theNode->p,
	    theNode,
	    theNode->n,
	    theNode->left,
	    theNode->fd);
    theNode = ((theNode)->n) ;
  }
  return(0);
}
/* # 48 "./inc/rol.h" 2 3 */
typedef struct rolParameters *rolParam;
typedef struct rolParameters
  {
    char          *name;	      
    char          *listName;	      
    int            runType;	      
    int            runNumber;	      
    VOIDFUNCPTR    doit;	      
    int            daproc;	      
    void          *id;		      
    int            nounload;	      
    int            inited;	      
    long          *dabufp;	      
    long          *dabufpi;	      
    ROL_MEM_PART  *pool;              
    ROL_MEM_PART  *output;	      
    ROL_MEM_PART  *input;             
    ROL_MEM_PART  *dispatch;          
    volatile ROL_MEM_PART  *dispQ;    
    unsigned long  recNb;	      
    SEM_ID         wakeup;	      
    char          *usrString;	      
    void          *private;	      
    int            pid;               
  } ROLPARAMS;
extern ROLPARAMS rolP;
static rolParam rol;
/* # 1 "./inc/services.h" 1 */
/* # 1 "./inc/obj.h" 1 */
/* # 1 "./inc/rc.h" 1 */
typedef struct rp {
  int a ;
  int b ;
} rpStruct;
typedef struct rp *runparameters;
typedef struct rp rp;
typedef struct reti {
  int a;
  int b;
} retiStruct;
typedef struct arg_rs *retrs;
struct arg_rs {
	int value;
	char *name;
} arg_rsStruct;
typedef struct arg_rs arg_rs;
typedef struct retr {
  int a;
  float b;
} retrStruct;
typedef struct argw_f {
  char *name;
  float value;
} argw_fStruct;
typedef struct argw_i {
  char *name;
  int value;
} argw_iStruct;
typedef struct argw_s {
  char *name;
  char *value;
} argw_sStruct;
extern int xdr_record();
extern int xdr_event();
extern int xdr_rp();
extern int xdr_ri();
extern int xdr_arg_rs();
extern int xdr_retrs();
extern int xdr_rr();
extern int xdr_wf();
extern int xdr_wi();
extern int xdr_ws();
extern int *dacreate();
extern int *daremove();
extern int *dadownload();
extern int *daprestart();
extern int *daend();
extern int *dapause();
extern int *dago();
extern int *daterminate();
extern int *dareport();
extern int daWriteEvent();
extern int rcConnect();
extern struct reti *dareadint();
extern retrs *dareadstring();
extern int daSync();
extern char *rcStates();
extern int *dareqevent();
extern int lastContext();
extern int restoreContext();
extern int daHandleSpy();
/* # 62 "./inc/obj.h" 2 */
typedef struct classStruct *objClass;
typedef struct classStruct SERVICE;
typedef struct classStruct {
  short     magic;		 
  char     *name;		 
  char     *className;		 
  int       ourId;		 
  int       expId;		 
  rolParam **rol;		 
  char     *rolNames;		 
  int       nrol;		 
  int       action;		 
  int       state;		 
  char     *log;		 
  char     *target;		 
  int       runNumber;		 
  int       runType;		 
} objClassStore;
/* # 43 "./inc/services.h" 2 */
extern SERVICE rc_service_ana_;
extern SERVICE rc_service_eb_;
extern SERVICE rc_service_roc_;
extern SERVICE rc_service_ts_;
extern void rcservice_ (SERVICE *service_name);
extern void rcexecute_ ();
/* # 86 "./inc/rol.h" 2 3 */
static int EVENT_type;
static int stream_fd__;
static int trig_type;
extern int global_env[];
extern long global_env_depth;
extern char *global_routine[100];
extern long evnb;
extern long recPermis;
extern int doDone;
extern int data_tx_mode;
extern int async_roc_flag;
extern long theIntCount;
/* # 1 "./inc/BankTools.h" 1 */
long *StartOfEvent[32 ],event_depth__;
/* # 90 "./inc/BankTools.h" */
/* # 102 "./inc/BankTools.h" */
/* # 148 "./inc/rol.h" 2 3 */
/* # 1 "./inc/trigger_dispatch.h" 1 */
static unsigned char dispatch_busy, currType; 
static int intLockKey,trigId;
static int poolEmpty, NoDone;
static unsigned long theEvMask, currEvMask, evMasks[   16 ];
static VOIDFUNCPTR wrapperGenerator;
static FUNCPTR trigRtns[   32 ], syncTRtns[   32 ], doneRtns[   32 ];
static unsigned long Tcode[   32 ];
static DANODE *__the_event__, *input_event__;
/* # 49 "./inc/trigger_dispatch.h" */
/* # 120 "./inc/trigger_dispatch.h" */
/* # 134 "./inc/trigger_dispatch.h" */
static void cdodispatch()
{
  unsigned char theType,theSource;
  int ix, go_on;
  DANODE *theNode;
  dispatch_busy = 1;
  go_on = 1;
  while ((rol->dispQ->list.c) && (go_on)) {
{( theNode) = 0;if((&rol->dispQ->list)->c){(&rol->dispQ->list)->c--;( theNode) = 
(&rol->dispQ->list)->f;(&rol->dispQ->list)->f = (&rol->dispQ->list)->f->n;};if (!(&rol->dispQ->list)->c) (&rol->dispQ->list)->l = 
0;} ;     theType = theNode->type;
    theSource = theNode->source;
    if (theEvMask) { 
      if ((theEvMask & (1<<theSource)) && (theType == currType)) {
	theEvMask = theEvMask & ~(1<<theSource);
	input_event__ = theNode;
	rol->dabufpi = (long *) &input_event__->data[1];
	intUnlock(intLockKey); ;
	(*theNode->reader)(theType, Tcode[theSource]);
	intLockKey = intLock(); ;
	if (theNode)
	 {{if(! (&theNode->part->list)->c ){(&theNode->part->list)->f = 
(&theNode->part->list)->l = ( theNode);( theNode)->p = 0;} else {( theNode)->p = 
(&theNode->part->list)->l;(&theNode->part->list)->l->n = ( theNode);(&theNode->part->list)->l = ( theNode);} ( theNode)->n = 
0;(&theNode->part->list)->c++;} ;} ; 	if (!theEvMask) {
	 if (wrapperGenerator) {event_depth__--; *StartOfEvent[event_depth__] = (long) (((char 
*) (rol->dabufp)) - ((char *) StartOfEvent[event_depth__]));	if 
((*StartOfEvent[event_depth__] & 1) != 0) { (rol->dabufp) = ((long *)((char *) (rol->dabufp))+1); 
*StartOfEvent[event_depth__] += 1; }; if ((*StartOfEvent[event_depth__] & 2) !=0) { *StartOfEvent[event_depth__] = 
*StartOfEvent[event_depth__] + 2; (rol->dabufp) = ((long *)((short *) (rol->dabufp))+1);; 
};	*StartOfEvent[event_depth__] = ( (*StartOfEvent[event_depth__]) >> 2) - 1;}; ;	 	 if (__the_event__) { if (rol->output) { *(rol->dabufp)++ = ( (0xcbf00000) | (0x0300) | 
(rol->pid & 0xff) ); *(rol->dabufp)++ = rol->recNb ; __the_event__->length = __the_event__->data[0] 
+ 1; {if(! (&(rol->output->list))->c ){(&(rol->output->list))->f = 
(&(rol->output->list))->l = (__the_event__);(__the_event__)->p = 0;} else {(__the_event__)->p = 
(&(rol->output->list))->l;(&(rol->output->list))->l->n = (__the_event__);(&(rol->output->list))->l = (__the_event__);} (__the_event__)->n = 
0;(&(rol->output->list))->c++;} ; rol->recNb++; } else { {{if(! (&__the_event__->part->list)->c 
){(&__the_event__->part->list)->f = (&__the_event__->part->list)->l = ( __the_event__);( __the_event__)->p = 0;} else {( 
__the_event__)->p = (&__the_event__->part->list)->l;(&__the_event__->part->list)->l->n = ( 
__the_event__);(&__the_event__->part->list)->l = ( __the_event__);} ( __the_event__)->n = 0;(&__the_event__->part->list)->c++;} ;} ;	} 
__the_event__ = (DANODE *) 0; } ; 	 {int ix; if (currEvMask) for (ix=0; ix < trigId; ix++) {	if (currEvMask & (1<<ix)) 
(*doneRtns[ix])(currType,Tcode[ix]); } if (rol->pool->list.c) { currEvMask = 0; __done(); } else { poolEmpty = 1; doDone = 1; } } ; 	}
      } else {
	{if(! (&rol->dispQ->list)->c ){(&rol->dispQ->list)->f = (&rol->dispQ->list)->l = ( 
theNode);( theNode)->p = 0;} else {( theNode)->p = 
(&rol->dispQ->list)->l;(&rol->dispQ->list)->l->n = ( theNode);(&rol->dispQ->list)->l = ( theNode);} ( theNode)->n = 
0;(&rol->dispQ->list)->c++;} ; 	go_on = 0;
      }
    } else { 
      if ((1<<theSource) & evMasks[theType]) {
	currEvMask = theEvMask = evMasks[theType];
	currType = theType;
      } else {
        currEvMask = (1<<theSource);
      }
      evnb++;
      if (wrapperGenerator) {
	(*wrapperGenerator)(theType);
      }
      input_event__ = theNode;
      rol->dabufpi = (long *) &input_event__->data[1];
      intUnlock(intLockKey); ;
      (*theNode->reader)(theType, Tcode[theSource]);
      intLockKey = intLock(); ;
      if (theNode)
	{{if(! (&theNode->part->list)->c ){(&theNode->part->list)->f = 
(&theNode->part->list)->l = ( theNode);( theNode)->p = 0;} else {( theNode)->p = 
(&theNode->part->list)->l;(&theNode->part->list)->l->n = ( theNode);(&theNode->part->list)->l = ( theNode);} ( theNode)->n = 
0;(&theNode->part->list)->c++;} ;} ;       if (theEvMask) {
	theEvMask = theEvMask & ~(1<<theSource);
      } 
      if (!theEvMask) {
	 if (__the_event__) { if (rol->output) { *(rol->dabufp)++ = ( (0xcbf00000) | (0x0300) | 
(rol->pid & 0xff) ); *(rol->dabufp)++ = rol->recNb ; __the_event__->length = __the_event__->data[0] 
+ 1; {if(! (&(rol->output->list))->c ){(&(rol->output->list))->f = 
(&(rol->output->list))->l = (__the_event__);(__the_event__)->p = 0;} else {(__the_event__)->p = 
(&(rol->output->list))->l;(&(rol->output->list))->l->n = (__the_event__);(&(rol->output->list))->l = (__the_event__);} (__the_event__)->n = 
0;(&(rol->output->list))->c++;} ; rol->recNb++; } else { {{if(! (&__the_event__->part->list)->c 
){(&__the_event__->part->list)->f = (&__the_event__->part->list)->l = ( __the_event__);( __the_event__)->p = 0;} else {( 
__the_event__)->p = (&__the_event__->part->list)->l;(&__the_event__->part->list)->l->n = ( 
__the_event__);(&__the_event__->part->list)->l = ( __the_event__);} ( __the_event__)->n = 0;(&__the_event__->part->list)->c++;} ;} ;	} 
__the_event__ = (DANODE *) 0; } ; 	 {int ix; if (currEvMask) for (ix=0; ix < trigId; ix++) {	if (currEvMask & (1<<ix)) 
(*doneRtns[ix])(currType,Tcode[ix]); } if (rol->pool->list.c) { currEvMask = 0; __done(); } else { poolEmpty = 1; doDone = 1; } } ;       }
    }  
  }
  dispatch_busy = 0;
}
static int theIntHandler(int theSource)
{
  if (theSource == 0) return(0);
  {  
    DANODE *theNode;
    intLockKey = intLock(); ;
    theIntCount++;
{{( theNode) = 0;if((&(rol->dispatch->list))->c){(&(rol->dispatch->list))->c--;( 
theNode) = (&(rol->dispatch->list))->f;(&(rol->dispatch->list))->f = 
(&(rol->dispatch->list))->f->n;};if (!(&(rol->dispatch->list))->c) (&(rol->dispatch->list))->l = 0;} ;} ;     theNode->type = (EVENT_type ); 
    theNode->source = theSource; 
    theNode->reader = trigRtns[theSource]; 
{if(! (&rol->dispQ->list)->c ){(&rol->dispQ->list)->f = (&rol->dispQ->list)->l = ( 
theNode);( theNode)->p = 0;} else {( theNode)->p = 
(&rol->dispQ->list)->l;(&rol->dispQ->list)->l->n = ( theNode);(&rol->dispQ->list)->l = ( theNode);} ( theNode)->n = 
0;(&rol->dispQ->list)->c++;} ;     if (!dispatch_busy)
      cdodispatch();
    intUnlock(intLockKey); ;
  }
}
static int cdopolldispatch()
{
  unsigned char theSource, theType;
  int stat = 0;
  DANODE *theNode;
  for (theSource=0;theSource<trigId;theSource++){
    if (syncTRtns[theSource]){
      if ( theNode = (*syncTRtns[theSource])(Tcode[theSource])) {
	stat = 1;
	{  
	  intLockKey = intLock(); ;
	  if (theNode == 1) 
	 {{( theNode) = 0;if((&(rol->dispatch->list))->c){(&(rol->dispatch->list))->c--;( 
theNode) = (&(rol->dispatch->list))->f;(&(rol->dispatch->list))->f = 
(&(rol->dispatch->list))->f->n;};if (!(&(rol->dispatch->list))->c) (&(rol->dispatch->list))->l = 0;} ;} ; 	  theNode->type = (EVENT_type ); 
	  theNode->source = theSource; 
	  theNode->reader = trigRtns[theSource]; 
	 {if(! (&rol->dispQ->list)->c ){(&rol->dispQ->list)->f = (&rol->dispQ->list)->l = ( 
theNode);( theNode)->p = 0;} else {( theNode)->p = 
(&rol->dispQ->list)->l;(&rol->dispQ->list)->l->n = ( theNode);(&rol->dispQ->list)->l = ( theNode);} ( theNode)->n = 
0;(&rol->dispQ->list)->c++;} ; 	  if (!dispatch_busy) 
	    cdodispatch();
	  intUnlock(intLockKey); ;
	}
      }
    }
  }
  return (stat);
}
/* # 155 "./inc/rol.h" 2 3 */
static char rol_name__[40];
static char temp_string__[132];
static unsigned long address___;
void __init__(rolp)
     rolParam rolp;
{
      if (rolp->daproc !=        7 ) 
	printf("rolp->daproc = %d\n",rolp->daproc);
      switch(rolp->daproc) {
      case        0 :
	{
	  char name[40];
	  printf("__init__ - Initializing new rol structures \n");
	  rol = rolp;
	  stream_fd__ = 0;
	  rolp->inited = 1;
	  printf("rolp->inited %d\n",rolp->inited);
	  strcpy(rol_name__, "Un-named" );
	  rolp->listName = rol_name__;
	  strcpy(name, rolp->listName);
	  strcat(name, ":pool");
	  rolp->pool  = partCreate(name, 256  ,100  ,0);
	  strcpy(name, rolp->listName);
	  strcat(name, ":output");
	  rolp->output = partCreate(name, 0, 0, 0);
	  strcpy(name, rolp->listName);
	  strcat(name, ":input");
	  rolp->input = partCreate(name, 0, 0, 0);
	  strcpy(name, rolp->listName);
	  strcat(name, ":dispatch");
	  rolp->dispatch  = partCreate(name, 0, 32, 0);
	  strcpy(name, rolp->listName);
	  strcat(name, ":dispQ");
	  rolp->dispQ = partCreate(name, 0, 0, 0);
	  printf("INFO: __init__ from %s\n",rolp->listName);
	  printf("INFO: done init\n");  
	  break;
	}
      case        9 :
	  printf("__init__ - Free readout list memory partitions \n");
	  rolp->inited = 0;
	  partFreeAll();
	break;
      case    1 :
	__download();
	break;
      case    2 :
	__prestart();
	break;
      case       4 :
	__pause();
	break;
      case         3 :
	__end();
	break;
      case          5 :
	__go();
	break;
      case        6 :
	__poll();
	break;
      case        7 :
	__done();
	break;
      default:
	printf("WARN: unsupported action\n");
	break;
      }
}
static void __poll(objClass class)
{
{cdopolldispatch(); {int ix; if (currEvMask) for (ix=0; ix < trigId; ix++) {	if (currEvMask & 
(1<<ix)) (*doneRtns[ix])(currType,Tcode[ix]); } if (rol->pool->list.c) { currEvMask = 0; 
__done(); } else { poolEmpty = 1; doDone = 1; } } ;} ; }
/* # 2 "fscc.c" 2 */
VOIDFUNCPTR fscc__init__ = __init__;
/* # 1 "./inc/FASTBUS_source.h" 1 3 */
/* # 1 "./inc/fb_trigLib.h" 1 */
static inline void wdStart()
{
(*(unsigned char *) (	0x00640000	+ 0x10 )) = 0xf2 ;	   (*(unsigned char *) (	0x00640000	+      0x13                  )) =100;
  (*(unsigned char *) (	0x00640000	+      0x14                  )) =0x0;
(*(unsigned char *) (	0x00640000	+ 0x15 )) =0x0;		 (*(unsigned char *) (	0x00640000	+ 0x10 )) = 0xf3 ;	 }
static inline void fptriglink(isr)
     VOIDFUNCPTR isr;
{
  static FUNCPTR handlerPtr = (FUNCPTR) 0;
  if (handlerPtr)
    free(handlerPtr);
  handlerPtr = intHandlerCreate(isr,0);
  intVecSet((VOIDFUNCPTR *) (0x4f<<2),(VOIDFUNCPTR) handlerPtr);
(*(unsigned char *) (	0x00480000	+ 	0x03 	)) &= ~	(1<<7	)	; (*(unsigned char *) (	0x00480000	+ 	0x09 	)) |= 	(1<<7	)	; }
static inline void fptenable()
{
(*(unsigned char *) (	0x00480000	+ 	0x03 	)) |= 	(1<<7	)	; }
static inline void fptdisable()
{
(*(unsigned char *) (	0x00480000	+ 	0x03 	)) &= ~	(1<<7	)	; }
static inline char fpttype()
{
  return((((*(unsigned char *) (               0x004c0000      )) &0x3c)>>2));
}
static inline void fpttypeset(char tt)
{
(*(unsigned char *) (	0x00640000	+ 0x09 )) = (tt<<5) | ((*(unsigned char *) (	0x00640000	+ 
0x09 )) &0x1f); }
static inline void fpttoggle()
{
(*(unsigned char *) (	0x00480000	+ 	0x03 	)) &= ~	(1<<7	)	; (*(unsigned char *) (	0x00480000	+ 	0x03 	)) |= 	(1<<7	)	;   (*(unsigned char *) (	0x00640000	+      0x09                  )) =0x10;  
  (*(unsigned char *) (	0x00640000	+      0x09                  )) =0;	  
}
static inline void fpbusy()
{
  (*(unsigned char *) (	0x00640000	+      0x09                  ))  |=  0x10;
}
static inline void fpnotbusy()
{
  (*(unsigned char *) (	0x00640000	+      0x09                  ))  &= ~0x10;
}
static inline int fpttest()
{
  int ii;
ii = (((*(unsigned char *) (	0x00480000	+ 	0x05 	)) & 0x80)!=0);   return(ii);
}
/* # 4 "./inc/FASTBUS_source.h" 2 3 */
/* # 1 "./inc/fb_types.h" 1 */
typedef int			FB_boolean;
typedef unsigned long		FB_buffer_mode;
typedef unsigned long		FB_error_code;
typedef int			FB_integer;
typedef unsigned long		FB_line;
typedef	int			FB_list_pointer;
typedef unsigned long		FB_operator;
typedef	unsigned long	       	FB_parameter_id;
typedef unsigned long		FB_parameter_value;
typedef unsigned long		FB_port_id;
typedef unsigned long		FB_response_code;
typedef FUNCPTR			FB_routine;
typedef unsigned long		FB_seq_buffer_id;
typedef int			FB_severity;
typedef	unsigned long		FB_word;
typedef char			*FB_string;
typedef FB_word			*array_of_FB_word;
/* # 5 "./inc/FASTBUS_source.h" 2 3 */
/* # 1 "./inc/fb_fscc_macro.h" 1 */
/* # 1 "./inc/fb_fscc_def.h" 1 */
extern int fscc_csr[32];	 
extern volatile int fscc_error;	 
extern int fscc_error_seq;	 
extern int fscc_error_slv;	 
extern int fscc_int_count;	 
extern int fscc_berr_count;	 
extern int fscc_seq_buf_action;	 
extern int fscc_frlen_info;	 
/* # 99 "./inc/fb_fscc_macro.h" 2 */
/* # 1 "./inc/fb_error.h" 1 */
/* # 1 "./inc/fb_error_code_msg_c.h" 1 */
/* # 46 "./inc/fb_error.h" 2 */
/* # 100 "./inc/fb_fscc_macro.h" 2 */
extern int fb_errno;
void fscc_error_decode(int noarb,int nopa,int nosa,
		       int noda,int holdas,int hold);
/* # 168 "./inc/fb_fscc_macro.h" */
/* # 200 "./inc/fb_fscc_macro.h" */
/* # 230 "./inc/fb_fscc_macro.h" */
/* # 255 "./inc/fb_fscc_macro.h" */
/* # 321 "./inc/fb_fscc_macro.h" */
/* # 357 "./inc/fb_fscc_macro.h" */
/* # 385 "./inc/fb_fscc_macro.h" */
/* # 413 "./inc/fb_fscc_macro.h" */
/* # 435 "./inc/fb_fscc_macro.h" */
/* # 6 "./inc/FASTBUS_source.h" 2 3 */
/* # 1 "./inc/fb_proto_1.h" 1 */
void fb_fbinit_1();
void fb_frd_1(int pa, int sa, unsigned long *data, int eg, int noarb, 
	      int nopa, int nosa, int noda, int holdas, int hold);
void fb_fwd_1(int pa, int sa, unsigned long data, int eg, int noarb, 
	      int nopa, int nosa, int noda, int holdas, int hold);
void fb_frc_1(int pa, int sa, unsigned long *data, int eg, int noarb, 
	      int nopa, int nosa, int noda, int holdas, int hold);
void fb_fwc_1(int pa, int sa, unsigned long data, int eg, int noarb, 
	      int nopa, int nosa, int noda, int holdas, int hold);
void fb_frdm_1(int pa, int sa, unsigned long *data, int noarb, 
	       int nopa, int nosa, int noda, int holdas, int hold);
void fb_fwdm_1(int pa, int sa, unsigned long data, int noarb, 
	       int nopa, int nosa, int noda, int holdas, int hold);
void fb_frcm_1(int pa, int sa, unsigned long *data, int noarb, 
	       int nopa, int nosa, int noda, int holdas, int hold);
void fb_fwcm_1(int pa, int sa, unsigned long data, int noarb, 
	       int nopa, int nosa, int noda, int holdas, int hold);
void fb_frdb_1(int pa, int sa, unsigned long *data, int maxbytes, int eg, 
		int noarb, int nopa, int nosa, int noda, int pipe, 
		int holdas, int hold, int nowait);
void fb_fwdb_1(int pa, int sa, unsigned long *data, int maxbytes, int eg, 
		int noarb, int nopa, int nosa, int noda, int pipe, 
		int holdas, int hold, int nowait);
void fb_frcb_1(int pa, int sa, unsigned long *data, int maxbytes, int eg, 
		int noarb, int nopa, int nosa, int noda, int pipe, 
		int holdas, int hold, int nowait);
void fb_fwcb_1(int pa, int sa, unsigned long *data, int maxbytes, int eg, 
		int noarb, int nopa, int nosa, int noda, int pipe, 
		int holdas, int hold, int nowait);
void fb_frdbm_1(int pa, int sa, unsigned long *data, int maxbytes, 
		int noarb, int nopa, int nosa, int noda, int pipe, 
		int holdas, int hold, int nowait);
void fb_fwdbm_1(int pa, int sa, unsigned long *data, int maxbytes,  
		int noarb, int nopa, int nosa, int noda, int pipe, 
		int holdas, int hold, int nowait);
void fb_frcbm_1(int pa, int sa, unsigned long *data, int maxbytes, 
		int noarb, int nopa, int nosa, int noda, int pipe, 
		int holdas, int hold, int nowait);
void fb_fwcbm_1(int pa, int sa, unsigned long *data, int maxbytes, 
		int noarb, int nopa, int nosa, int noda, int pipe, 
		int holdas, int hold, int nowait);
void fb_frdsa_1(int pa, unsigned long *sa, int eg, int noarb, 
		int nopa, int nosa, int holdas, int hold);
void fb_fwdsa_1(int pa, unsigned long sa, int eg, int noarb, 
		int nopa, int nosa, int holdas, int hold);
void fb_frcsa_1(int pa, unsigned long *sa, int eg, int noarb, 
		int nopa, int nosa, int holdas, int hold);
void fb_fwcsa_1(int pa, unsigned long sa, int eg, int noarb, 
		int nopa, int nosa, int holdas, int hold);
void fb_fbprst_1();
void fb_frlen_1(unsigned long *data);
void fb_fcarb_1();
void fb_fcrel_1();
void fb_fcpd_1(int pa);
void fb_fcpdm_1(int pa);
void fb_fcpc_1(int pa);
void fb_fcpcm_1(int pa);
void fb_fcdisc_1();
void fb_fcrw_1(int *data);
void fb_fcww_1(int data);
void fb_fcrsa_1(int *data);
void fb_fcwsa_1(int data);
void fb_fcrb_1(int *data, int maxbytes);
void fb_fcwb_1(int *data, int maxbytes);
void fb_fbprst_1();
/* # 12 "./inc/FASTBUS_source.h" 2 3 */
char	*FB_ERRTXT[	((((unsigned long)( 0X800BC324 ) & 	0x00003fff	) >> 3		) ) +1] = 	{
	"",
	"ERROR: 0x%X %s,%s - address release timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - AK timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - block data - SS=2, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data parity error, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - data SS=0, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=1, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=2, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=3, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=4, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=5, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=6, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=7, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - DK release timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - DK timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - long timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - pad cycle SS=0, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - pad cycle SS=1, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - pad cycle SS=2, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - pad cycle SS=3, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - pad cycle SS=4, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - pad cycle SS=5, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - pad cycle SS=6, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - pad cycle SS=7, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - s.addr cycle DK timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=0, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=1, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=2, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=3, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=4, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=5, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=6, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=7, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - software timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - wait timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - normal successful completion\n",
	"ERROR: 0x%X %s,%s - error accessing data buffer\n",
	"ERROR: 0x%X %s,%s - abort action\n",
	"ERROR: 0x%X %s,%s - already connected\n",
	"ERROR: 0x%X %s,%s - bad parameter value\n",
	"ERROR: 0x%X %s,%s - buffer overflow\n",
	"ERROR: 0x%X %s,%s - session closed, no actions possible\n",
	"ERROR: 0x%X %s,%s - routine connection failed\n",
	"ERROR: 0x%X %s,%s - routine disconnect failed\n",
	"ERROR: 0x%X %s,%s - environment active\n",
	"ERROR: 0x%X %s,%s - environment id overflow\n",
	"ERROR: 0x%X %s,%s - environment overflow\n",
	"ERROR: 0x%X %s,%s - environment release\n",
	"ERROR: 0x%X %s,%s - generic error\n",
	"ERROR: 0x%X %s,%s - generic fatal\n",
	"ERROR: 0x%X %s,%s - hardware error\n",
	"ERROR: 0x%X %s,%s - hardware warning\n",
	"ERROR: 0x%X %s,%s - holding address\n",
	"ERROR: 0x%X %s,%s - holding bus\n",
	"ERROR: 0x%X %s,%s - error was ignored\n",
	"ERROR: 0x%X %s,%s - illegal parameter value\n",
	"ERROR: 0x%X %s,%s - illegal sequential buffer id\n",
	"ERROR: 0x%X %s,%s - unexpected implementation error\n",
	"ERROR: 0x%X %s,%s - generic informational\n",
	"ERROR: 0x%X %s,%s - invalid environment id\n",
	"ERROR: 0x%X %s,%s - invalid list pointer\n",
	"ERROR: 0x%X %s,%s - invalid port id\n",
	"ERROR: 0x%X %s,%s - invalid sequential buffer id\n",
	"ERROR: 0x%X %s,%s - last pad\n",
	"ERROR: 0x%X %s,%s - last secondary address\n",
	"ERROR: 0x%X %s,%s - last list pointer\n",
	"ERROR: 0x%X %s,%s - list overflow\n",
	"ERROR: 0x%X %s,%s - long timer on\n",
	"ERROR: 0x%X %s,%s - no address connection\n",
	"ERROR: 0x%X %s,%s - no more status\n",
	"ERROR: 0x%X %s,%s - no privilege\n",
	"ERROR: 0x%X %s,%s - no supplementary status\n",
	"ERROR: 0x%X %s,%s - not connected\n",
	"ERROR: 0x%X %s,%s - not holding mastership\n",
	"ERROR: 0x%X %s,%s - not master\n",
	"ERROR: 0x%X %s,%s - session already open\n",
	"ERROR: 0x%X %s,%s - operation pending\n",
	"ERROR: 0x%X %s,%s - pipeline transfer\n",
	"ERROR: 0x%X %s,%s - pointer overflow\n",
	"ERROR: 0x%X %s,%s - port active\n",
	"ERROR: 0x%X %s,%s - port already allocated\n",
	"ERROR: 0x%X %s,%s - port not allocated\n",
	"ERROR: 0x%X %s,%s - port not available\n",
	"ERROR: 0x%X %s,%s - port owned\n",
	"ERROR: 0x%X %s,%s - read only parameter\n",
	"ERROR: 0x%X %s,%s - operation successfully retried\n",
	"ERROR: 0x%X %s,%s - sequenctial buffer active\n",
	"ERROR: 0x%X %s,%s - sequenctial buffer exists\n",
	"ERROR: 0x%X %s,%s - sequenctial buffer id overflow\n",
	"ERROR: 0x%X %s,%s - software timer on\n",
	"ERROR: 0x%X %s,%s - status not found\n",
	"ERROR: 0x%X %s,%s - status overflow\n",
	"ERROR: 0x%X %s,%s - successful operation\n",
	"ERROR: 0x%X %s,%s - unknown error\n",
	"ERROR: 0x%X %s,%s - unknown parameter\n",
	"ERROR: 0x%X %s,%s - unsupported port operation\n",
	"ERROR: 0x%X %s,%s - unsupported paramter\n",
	"ERROR: 0x%X %s,%s - unsupported routine\n",
	"ERROR: 0x%X %s,%s - user array overflow\n",
	"ERROR: 0x%X %s,%s - generic warning\n",
	"ERROR: 0x%X %s,%s - fscc FIFO error\n",
	};
static int padr,sadr;
static char *fb_rtn;
inline void 
  fpbr(int pa, long len) 
{
  int i;
  if ((len>4000)||(len<1)) len = 4000;
  if(pa<0) {
    fb_frdb_1(0,0,*rol->dabufp,(len<<2),1,1,1,1,0,0,1,1,0);
  } else {
    fb_frdb_1(pa,0,*rol->dabufp,(len<<2),1,1,0,1,0,0,0,0,0);
  }
if (fb_errno!=				 0X800BC119 ) { fb_rtn = "fb_frdb_1 data"; goto fooy; } ;   fb_frlen_1(&i);
  if (fb_errno!=				   0X800BC119  ) { fb_rtn = "fprb"; goto fooy; } ;
  *rol->dabufp += (i>>2);
  return;
 fooy:
daLogMsg(FB_ERRTXT[(((unsigned long)(fb_errno) & 	0x00003fff	) >> 3		) ],	fb_errno, 
global_routine[global_env_depth], fb_rtn,	padr,sadr); ;   return;
}
static inline void 
  fpbrf(int pa, long len) 
{
  int i, ix;
  if ((len>512)||(len<1)) len = 512;
*(unsigned char *) 0x64000C &=(~	0x10	); *(unsigned char *) 0x64000C |=	0x10	; ; *(unsigned char *) 0x64000C &=(~	0x01	); *(unsigned char *) 0x64000C |=	0x01	; ;     *(unsigned char *) 0x64000C  |=	0x04	 ;
  if(pa<0) {
    fb_frdb_1(0,0,	-1  ,(len<<2),1,1,1,1,0,0,1,1,0);
  } else {
    fb_frdb_1(pa,0,	-1  ,(len<<2),1,1,0,1,0,0,0,0,0);
  }
if (fb_errno!=				 0X800BC119 ) { fb_rtn = "fb_frdb_1 data"; goto fooy; } ;   fb_frlen_1(&i);
  if((ix = (i>>2) - 1)>=0) {    
  asm("movel #6815744,a2");                  
  asm("movel %0,d1": :"g" (ix));      
  asm("movel _dabufp,a0");                   
  asm("movel a0@,a1");                       
  asm("movel a2@,a1@+");                     
  asm(".long 1472856060");                   
  asm("movel a1,a0@");                       
  }
   *(unsigned char *) 0x64000C  &=(~	0x04	) ;
  if (fb_errno!=				   0X800BC119  ) { fb_rtn = "fpbrf buffer"; goto fooy; } ;
  return;
 fooy:
daLogMsg(FB_ERRTXT[(((unsigned long)(fb_errno) & 	0x00003fff	) >> 3		) ],	fb_errno, 
global_routine[global_env_depth], fb_rtn,	padr,sadr); ;   return;
}
static int FSCC_handlers,FSCCflag;  
static unsigned long FSCC_isAsync;
void FSCC_int_handler()
{
  theIntHandler(FSCC_handlers);
}
/* # 4 "fscc.c" 2 */
long TriggerCount;
long DoneCount;
long GDoneCount;
static void __download()
{
    daLogMsg("INFO: Readout list compiled %s\n", DAYTIME);
    {
       static int ourTaskId=0;  
       if (taskIdSelf() != ourTaskId)
         {
           ourTaskId = taskIdSelf();
           fb_task_init_1();
         }
    }
    async_roc_flag = 0; 
  {   
    daLogMsg("INFO: User Download Executed\n");
  }   
    return;
   fooy: 
daLogMsg(FB_ERRTXT[(((unsigned long)(fb_errno) & 	0x00003fff	) >> 3		) ],	fb_errno, 
global_routine[global_env_depth], fb_rtn,	padr,sadr); ;      return ;
}       
static void __prestart()
{
{ dispatch_busy = 0; bzero((char *) evMasks, sizeof(evMasks)); bzero((char *) syncTRtns, 
sizeof(syncTRtns)); bzero((char *) Tcode, sizeof(Tcode)); wrapperGenerator = 0; theEvMask = 0; currEvMask = 0; 
trigId = 1; poolEmpty = 0; NoDone = 0; __the_event__ = (DANODE *) 0;} ;     fb_init_1 ();
    fb_frd_1(0,0,0,0,0,1,1,1,1,1);  
if (fb_errno!=				 0X800BC119 ) { fb_rtn = "hidden arbitrate"; goto fooy; } ;     fptdisable();
    evnb = 0;
  {   
    fb_init_1();
    { FSCC_handlers =0;FSCC_isAsync = 0;FSCCflag = 0;} ;
    {
     extern void usrtrig();extern void usrtrig_done();
     doneRtns[trigId] = (FUNCPTR) (usrtrig_done);
     trigRtns[trigId] = (FUNCPTR) (usrtrig);
     Tcode[trigId] = 1 ;
{printf("linking FSCC trigger to id %d\n",trigId); FSCC_handlers = (trigId);FSCC_isAsync 
= 1;fptriglink(FSCC_int_handler);} ;trigId++;}   {evMasks[1] |= (1<<(FSCC_handlers ));} ;
  TriggerCount = 0;
  DoneCount = 0;
    daLogMsg("WARN: User Prestart Executed\n");
  }   
if (__the_event__) if (__the_event__) { if (rol->output) { *(rol->dabufp)++ = ( 
(0xcbf00000) | (0x0300) | (rol->pid & 0xff) ); *(rol->dabufp)++ = rol->recNb ; __the_event__->length = 
__the_event__->data[0] + 1; {if(! (&(rol->output->list))->c ){(&(rol->output->list))->f = 
(&(rol->output->list))->l = (__the_event__);(__the_event__)->p = 0;} else {(__the_event__)->p = 
(&(rol->output->list))->l;(&(rol->output->list))->l->n = (__the_event__);(&(rol->output->list))->l = (__the_event__);} (__the_event__)->n = 
0;(&(rol->output->list))->c++;} ; rol->recNb++; } else { {{if(! (&__the_event__->part->list)->c 
){(&__the_event__->part->list)->f = (&__the_event__->part->list)->l = ( __the_event__);( __the_event__)->p = 0;} else {( 
__the_event__)->p = (&__the_event__->part->list)->l;(&__the_event__->part->list)->l->n = ( 
__the_event__);(&__the_event__->part->list)->l = ( __the_event__);} ( __the_event__)->n = 0;(&__the_event__->part->list)->c++;} ;} ;	} 
__the_event__ = (DANODE *) 0; } ;     evnb = 0;
    rol->recNb = 0;
      *(unsigned char *) 0x4C0000  = 0x81;
    return;
   fooy: 
daLogMsg(FB_ERRTXT[(((unsigned long)(fb_errno) & 	0x00003fff	) >> 3		) ],	fb_errno, 
global_routine[global_env_depth], fb_rtn,	padr,sadr); ;      return ;
}       
static void __end()
{
      *(unsigned char *) 0x4C0000  = 0x80;
    fptdisable();
  {   
{	long *StartOfBank; {if(__the_event__ == (DANODE *) 0) { {{(__the_event__) = 
0;if((&(rol->pool->list))->c){(&(rol->pool->list))->c--;(__the_event__) = (&(rol->pool->list))->f;(&(rol->pool->list))->f = (&(rol->pool->list))->f->n;};if 
(!(&(rol->pool->list))->c) (&(rol->pool->list))->l = 0;} ;} ; rol->dabufp = (long *) &__the_event__->data[0]; } } ; 
StartOfBank = (rol->dabufp); *(++(rol->dabufp)) = ((( 20 ) << 16) | ( 0x01 ) << 8) | ( 0xCC 
);	((rol->dabufp))++; ;   {*(rol->dabufp)++ = (1200);} ;
  {*(rol->dabufp)++ = (rol->runNumber );} ;
  {*(rol->dabufp)++ = (evnb);} ;
*StartOfBank = (long) (((char *) (rol->dabufp)) - ((char *) StartOfBank));	if 
((*StartOfBank & 1) != 0) { (rol->dabufp) = ((long *)((char *) (rol->dabufp))+1); *StartOfBank += 1; }; if 
((*StartOfBank & 2) !=0) { *StartOfBank = *StartOfBank + 2; (rol->dabufp) = ((long *)((short *) 
(rol->dabufp))+1);; };	*StartOfBank = ( (*StartOfBank) >> 2) - 1;}; ;   NoDone = 1;
    daLogMsg("INFO: User End Executed\n");
  }   
if (__the_event__) if (__the_event__) { if (rol->output) { *(rol->dabufp)++ = ( 
(0xcbf00000) | (0x0300) | (rol->pid & 0xff) ); *(rol->dabufp)++ = rol->recNb ; __the_event__->length = 
__the_event__->data[0] + 1; {if(! (&(rol->output->list))->c ){(&(rol->output->list))->f = 
(&(rol->output->list))->l = (__the_event__);(__the_event__)->p = 0;} else {(__the_event__)->p = 
(&(rol->output->list))->l;(&(rol->output->list))->l->n = (__the_event__);(&(rol->output->list))->l = (__the_event__);} (__the_event__)->n = 
0;(&(rol->output->list))->c++;} ; rol->recNb++; } else { {{if(! (&__the_event__->part->list)->c 
){(&__the_event__->part->list)->f = (&__the_event__->part->list)->l = ( __the_event__);( __the_event__)->p = 0;} else {( 
__the_event__)->p = (&__the_event__->part->list)->l;(&__the_event__->part->list)->l->n = ( 
__the_event__);(&__the_event__->part->list)->l = ( __the_event__);} ( __the_event__)->n = 0;(&__the_event__->part->list)->c++;} ;} ;	} 
__the_event__ = (DANODE *) 0; } ;     return;
   fooy: 
daLogMsg(FB_ERRTXT[(((unsigned long)(fb_errno) & 	0x00003fff	) >> 3		) ],	fb_errno, 
global_routine[global_env_depth], fb_rtn,	padr,sadr); ;      return ;
}  
static void __pause()
{
      *(unsigned char *) 0x4C0000  = 0x80;
    fptdisable();
  {   
{	long *StartOfBank; {if(__the_event__ == (DANODE *) 0) { {{(__the_event__) = 
0;if((&(rol->pool->list))->c){(&(rol->pool->list))->c--;(__the_event__) = (&(rol->pool->list))->f;(&(rol->pool->list))->f = (&(rol->pool->list))->f->n;};if 
(!(&(rol->pool->list))->c) (&(rol->pool->list))->l = 0;} ;} ; rol->dabufp = (long *) &__the_event__->data[0]; } } ; 
StartOfBank = (rol->dabufp); *(++(rol->dabufp)) = ((( 19 ) << 16) | ( 0x01 ) << 8) | ( 0xCC 
);	((rol->dabufp))++; ;   {*(rol->dabufp)++ = (1200);} ;
  {*(rol->dabufp)++ = (rol->runNumber );} ;
  {*(rol->dabufp)++ = (evnb);} ;
*StartOfBank = (long) (((char *) (rol->dabufp)) - ((char *) StartOfBank));	if 
((*StartOfBank & 1) != 0) { (rol->dabufp) = ((long *)((char *) (rol->dabufp))+1); *StartOfBank += 1; }; if 
((*StartOfBank & 2) !=0) { *StartOfBank = *StartOfBank + 2; (rol->dabufp) = ((long *)((short *) 
(rol->dabufp))+1);; };	*StartOfBank = ( (*StartOfBank) >> 2) - 1;}; ;   NoDone = 1;
    daLogMsg("INFO: User Pause Executed\n");
  }   
if (__the_event__) if (__the_event__) { if (rol->output) { *(rol->dabufp)++ = ( 
(0xcbf00000) | (0x0300) | (rol->pid & 0xff) ); *(rol->dabufp)++ = rol->recNb ; __the_event__->length = 
__the_event__->data[0] + 1; {if(! (&(rol->output->list))->c ){(&(rol->output->list))->f = 
(&(rol->output->list))->l = (__the_event__);(__the_event__)->p = 0;} else {(__the_event__)->p = 
(&(rol->output->list))->l;(&(rol->output->list))->l->n = (__the_event__);(&(rol->output->list))->l = (__the_event__);} (__the_event__)->n = 
0;(&(rol->output->list))->c++;} ; rol->recNb++; } else { {{if(! (&__the_event__->part->list)->c 
){(&__the_event__->part->list)->f = (&__the_event__->part->list)->l = ( __the_event__);( __the_event__)->p = 0;} else {( 
__the_event__)->p = (&__the_event__->part->list)->l;(&__the_event__->part->list)->l->n = ( 
__the_event__);(&__the_event__->part->list)->l = ( __the_event__);} ( __the_event__)->n = 0;(&__the_event__->part->list)->c++;} ;} ;	} 
__the_event__ = (DANODE *) 0; } ;     return;
   fooy: 
daLogMsg(FB_ERRTXT[(((unsigned long)(fb_errno) & 	0x00003fff	) >> 3		) ],	fb_errno, 
global_routine[global_env_depth], fb_rtn,	padr,sadr); ;      return ;
}  
static void __go()
{
    fpttoggle();
  {   
    daLogMsg("INFO: User Go Executed\n");
  }   
if (__the_event__) if (__the_event__) { if (rol->output) { *(rol->dabufp)++ = ( 
(0xcbf00000) | (0x0300) | (rol->pid & 0xff) ); *(rol->dabufp)++ = rol->recNb ; __the_event__->length = 
__the_event__->data[0] + 1; {if(! (&(rol->output->list))->c ){(&(rol->output->list))->f = 
(&(rol->output->list))->l = (__the_event__);(__the_event__)->p = 0;} else {(__the_event__)->p = 
(&(rol->output->list))->l;(&(rol->output->list))->l->n = (__the_event__);(&(rol->output->list))->l = (__the_event__);} (__the_event__)->n = 
0;(&(rol->output->list))->c++;} ; rol->recNb++; } else { {{if(! (&__the_event__->part->list)->c 
){(&__the_event__->part->list)->f = (&__the_event__->part->list)->l = ( __the_event__);( __the_event__)->p = 0;} else {( 
__the_event__)->p = (&__the_event__->part->list)->l;(&__the_event__->part->list)->l->n = ( 
__the_event__);(&__the_event__->part->list)->l = ( __the_event__);} ( __the_event__)->n = 0;(&__the_event__->part->list)->c++;} ;} ;	} 
__the_event__ = (DANODE *) 0; } ;     fptenable();
    fpttoggle();
      *(unsigned char *) 0x4C0000  = 0x82;
    return;
   fooy: 
daLogMsg(FB_ERRTXT[(((unsigned long)(fb_errno) & 	0x00003fff	) >> 3		) ],	fb_errno, 
global_routine[global_env_depth], fb_rtn,	padr,sadr); ;      return ;
}
void usrtrig(int EVTYPE,int EVSOURCE)
{
    long EVENT_LENGTH;
    fptdisable ();
    intLevelSet (1);
  {   
 TriggerCount++;
{	{if(__the_event__ == (DANODE *) 0) { {{(__the_event__) = 
0;if((&(rol->pool->list))->c){(&(rol->pool->list))->c--;(__the_event__) = (&(rol->pool->list))->f;(&(rol->pool->list))->f = (&(rol->pool->list))->f->n;};if 
(!(&(rol->pool->list))->c) (&(rol->pool->list))->l = 0;} ;} ; rol->dabufp = (long *) &__the_event__->data[0]; } } ; 
StartOfEvent[event_depth__++] = (rol->dabufp); *(++(rol->dabufp)) = (((rol->pid) << 16) | ( 0x01 ) << 8) | (0xff & 
evnb);	((rol->dabufp))++;} ;     {*(rol->dabufp)++ = (0xDA0000AA);} ; 
    {*(rol->dabufp)++ = (0xDA0000BB);} ; 
    {*(rol->dabufp)++ = (0xDA0000CC);} ; 
    {*(rol->dabufp)++ = (0xDA0000DD);} ; 
    {*(rol->dabufp)++ = (0xDA0000EE);} ; 
    {*(rol->dabufp)++ = (0xDA0000FF);} ; 
{event_depth__--; *StartOfEvent[event_depth__] = (long) (((char *) (rol->dabufp)) - 
((char *) StartOfEvent[event_depth__]));	if ((*StartOfEvent[event_depth__] & 1) != 0) { 
(rol->dabufp) = ((long *)((char *) (rol->dabufp))+1); *StartOfEvent[event_depth__] += 1; }; if 
((*StartOfEvent[event_depth__] & 2) !=0) { *StartOfEvent[event_depth__] = *StartOfEvent[event_depth__] + 2; 
(rol->dabufp) = ((long *)((short *) (rol->dabufp))+1);; };	*StartOfEvent[event_depth__] = ( 
(*StartOfEvent[event_depth__]) >> 2) - 1;}; ;   }   
    return;
  fooy: 
    *rol->dabufp = 0xFB000BAD;
    *rol->dabufp++;
printf (FB_ERRTXT[(((unsigned long)(fb_errno) & 	0x00003fff	) >> 3		) ],	fb_errno, 
global_routine[global_env_depth], fb_rtn,	padr,sadr); ;      return ;
}  
void usrtrig_done()
{
  {   
 DoneCount++;
  }   
    return;
   fooy: 
printf (FB_ERRTXT[(((unsigned long)(fb_errno) & 	0x00003fff	) >> 3		) ],	fb_errno, 
global_routine[global_env_depth], fb_rtn,	padr,sadr); ;      return ;
}  
void __done()
{
if (NoDone) {
   NoDone = 0;
   return;
}
  {   
 GDoneCount++;
 poolEmpty = 0;
  }   
    fptenable();
    fpttoggle();
      *(unsigned char *) 0x4C0000  = 0xc2;
      *(unsigned char *) 0x4C0000  = 0x82;
    return;
   fooy: 
printf (FB_ERRTXT[(((unsigned long)(fb_errno) & 	0x00003fff	) >> 3		) ],	fb_errno, 
global_routine[global_env_depth], fb_rtn,	padr,sadr); ;      return ;
}  
static void __status()
{
  {   
  }   
}  
