//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      subSysResetter Class Implementation
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: subSysResetter.cc,v $
//   Revision 1.1.1.1  1996/10/11 13:39:23  chen
//   run control source
//
//
#include "subSysResetter.h"

subSysResetter::subSysResetter (daqSubSystem* subsys)
:subSysTransitioner (subsys)
{
#ifdef _TRACE_OBJECTS
  printf ("    Create subSysResetter Class Object\n");
#endif
  // empty
}

subSysResetter::~subSysResetter (void)
{
#ifdef _TRACE_OBJECTS
  printf ("    Delete subSysResetter Class Object\n");
#endif
  // empty
}

int
subSysResetter::action (void) const
{
  return CODA_RESET_ACTION;
}

void
subSysResetter::executeItem (daqComponent* comp)
{
  comp->reset ();
}

int
subSysResetter::failureState (void)
{
  return CODA_BOOTED;
}

int
subSysResetter::successState (void)
{
  return CODA_DORMANT;
}
