/************************** Copyright Notice ****************************
 *                                                                      *
 * Copyright (c) 1992 Universities Research Association, Inc.           *
 *               All Rights Reserved.                                   *
 *                                                                      *
 ************************************************************************/

/************************************************************************/
/*									*/
/* File: fb_status.h				SWK 6/26/92		*/
/*									*/
/* This file contains the status macros that are either invoked as      */
/* macros in turbo mode or have equivalent c functions. Status macros 	*/
/* that are ALWAYS macros can be found in fb_status.h			*/
/* Status Macros of IEEE Standards Chapter 11				*/
/*									*/
/* Macros:								*/
/*		FB_FSSSEV		FB_STATUS_SET_SEVERITY		*/ 
/*		FB_FSSR			FB_STATUS_SET_RESPONSE		*/
/*		FB_FSGR			FB_STATUS_GET_RESPONSE		*/
/*		FB_FSCON		FB_STATUS_CONNECT		*/
/*		FB_FSDISC		FB_STATUS_DISCONNECT		*/
/*		FB_FSGSUM		FB_STATUS_GET_SUMMARY		*/
/*		FB_FSRPT		FB_STATUS_REPORT		*/
/*		FB_FSTRAN		FB_STATUS_TRANSLATE		*/
/*									*/
/************************************************************************/

#ifndef INCfbstatusmacros
#define INCfbstatusmacros 0


extern char *FB_ERRTXT[];


/************************************************************************/
/*									*/
/* FB_FSSSEV FB_STATUS_SET_SEVERITY		SWK June 24, 1992	*/
/*									*/
/* Set the severity level						*/
/*									*/
/* Arguments:								*/
/*	(out)		FB_error_code		FSretcod		*/
/*	(in)		FB_environment_id	FSeid			*/
/*	(in)		FB_error_code		FSerror_code		*/
/*	(in)		FB_severity		FSseverity		*/
/*									*/
/************************************************************************/
#define FB_FSSSEV( FSretcod, FSeid, FSerror_code, FSseverity) 		\
{ 									\
*FSretcod = FENORM; 							\
if(FB_GET_ERROR_VALUE(FSerror_code) <= FB_ERROR_MAX ) 			\
  { 									\
  if( (FSseverity>=FB_SEV_SUCCESS) && (FSseverity<=FB_SEV_NEVER))	\
    (FSeid)->severities[FB_GET_ERROR_VALUE(FSerror_code)] = FSseverity;	\
  else 									\
    *FSretcod = FEIPRV;/* illegal parameter value (FSseverity) */	\
  } 									\
else 									\
  *FSretcod = FEIPRV;/* illegal parameter value (FSerror_code ) */	\
}


/************************************************************************/
/*									*/
/* FB_FSSR FB_STATUS_SET_RESPONSE		SWK June 24, 1992	*/
/*									*/
/* Set the response value for the error					*/
/*									*/
/* Arguments:								*/
/*	(out)		FB_error_code		FSretcod		*/
/*	(in)		FB_environment_id	FSeid			*/
/*	(in)		FB_error_code		FShardware_error	*/
/*	(in)		FB_response_code	FSresponse		*/
/*									*/
/************************************************************************/
#define FB_FSSR( FSretcod, FSeid, FShardware_error, FSresponse) 	\
{ 									\
 *FSretcod = FENORM; 							\
 if(FB_GET_ERROR_VALUE(FShardware_error) <= FB_ERROR_MAX ) 		\
   { 									\
   if( (FSresponse>=FB_RESP_IGNORE) && (FSresponse<=FB_RESP_RETRY_ABORT_ACTION) ) \
     (FSeid)->responses[FB_GET_ERROR_VALUE(FShardware_error)] = FSresponse;\
   else 								\
     *FSretcod = FEIPRV;/* illegal parameter value (FSresponse) */	\
   } 									\
 else 									\
   *FSretcod = FEIPRV;/* illegal parameter value (FShardware_error) */	\
}

/************************************************************************/
/*									*/
/* FB_FSGR FB_STATUS_GET_RESPONSE		SWK June 24, 1992	*/
/*									*/
/* Get a response value for the hardware error				*/
/*									*/
/* Arguments:								*/
/*	(out)		FB_error_code		FSretcod		*/
/*	(in)		FB_environment_id	FSeid			*/
/*	(in)		FB_error_code		FShardware_error	*/
/*	(out)		FB_response_code	FSresponse		*/
/*									*/
/************************************************************************/
#define FB_FSGR( FSretcod, FSeid, FShardware_error, FSresponse) 	\
{ 									\
 *FSretcod = FENORM; 						     	\
 if(FB_GET_ERROR_VALUE(FShardware_error) <= FB_ERROR_MAX ) 		\
    *FSresponse = (FSeid)->responses[FB_GET_ERROR_VALUE(FShardware_error)]; \
  else 									\
   *FSretcod = FEIPRV;/* illegal parameter value (FShardware_error) */	\
}

/************************************************************************/
/*									*/
/* FB_FSCON FB_STATUS_CONNECT			SWK June 25, 1992	*/
/*									*/
/* Connect the user error handler					*/
/*									*/
/* Arguments:								*/
/*	(out)		FB_error_code		FSretcod		*/
/*	(in)		FB_environment_id	FSeid			*/
/*	(in)		FB_routine		FSroutine		*/
/*									*/
/************************************************************************/
#define FB_FSCON( FSretcod, FSeid, FSroutine) 				\
{ 									\
 *FSretcod = FENORM; 							\
  (FSeid)->funcptrs.err_handler = (VOIDFUNCPTR) (FSroutine); 		\
}

/************************************************************************/
/*									*/
/* FB_FSDISC FB_STATUS_DISCONNECT		SWK June 25, 1992	*/
/*									*/
/* Disconnect the user error handler					*/
/*									*/
/* Arguments:								*/
/*	(out)		FB_error_code		FSretcod		*/
/*	(in)		FB_environment_id	FSeid			*/
/*									*/
/************************************************************************/
#define FB_FSDISC( FSretcod, FSeid) 					\
{ 									\
 *FSretcod = FENORM;							\
  (FSeid)->funcptrs.err_handler = NULL;					\
}

/************************************************************************/
/*									*/
/* FB_FSGSUM FB_STATUS_GET_SUMMARY		SWK June 25, 1992	*/
/*									*/
/* Decode Summary Status						*/
/*									*/
/* Arguments:								*/
/*	(out)		FB_error_code		FSretcod		*/
/*	(in)		FB_environment_id	FSeid			*/
/*	(out)		FB_error_code		FSerror_code		*/
/*	(out)		FB_integer		FSrdbytes		*/
/*	(out)		FB_integer		FSwrbytes		*/
/*									*/
/************************************************************************/
#define FB_FSGSUM( FSretcod, FSeid, FSerror_code, FSrdbytes, FSwrbytes) \
{ 									\
 *FSretcod = FENORM; 							\
  *FSerror_code = (FSeid)->summary.error_code; 				\
  *FSrdbytes = (FSeid)->summary.bytes_read; 				\
  *FSwrbytes = (FSeid)->summary.bytes_written; 				\
}

/************************************************************************/
/************************Report*Error*Messages***************************/
/************************************************************************/

/************************************************************************/
/*									*/
/* FB_FSRPT FB_STATUS_REPORT			SWK June 26, 1992	*/
/*									*/
/* Error Message Status Report						*/
/*									*/
/* Arguments:								*/
/*	(out)		FB_error_code		FSretcod		*/
/*	(in)		FB_environment_id	FSeid			*/
/*	(in)		FB_boolean		FSrsum			*/
/*	(in)		FB_error_code		FSerrcod		*/
/*	(in)		FB_word			FSassoc			*/
/*	(in)		FB_integer		FSwhere			*/
/*									*/
/************************************************************************/
#define FB_FSRPT( FSretcod, FSeid, FSrsum, FSerrcod, FSassoc, FSwhere )	\
  { 									\
FB_SUPPLEMENT_ELE *sup_list; 						\
  *FSretcod = FENORM; 							\
  printErr( FB_ERRTXT[FB_GET_ERROR_VALUE(FSerrcod)], FSassoc, FSwhere );\
  printErr( "\n" );							\
  if( FSrsum == FB_FALSE )						\
    { 									\
    for( sup_list = (FSeid)->supplement.head; 				\
      sup_list != (FSeid)->supplement.tail; 				\
      sup_list = sup_list->next )					\
      {									\
      int index = FB_GET_ERROR_VALUE(sup_list->error_code);		\
      printErr( 							\
        FB_ERRTXT[index], sup_list->assoc_param, sup_list->where_occured ); \
      }									\
    } 									\
  }

/************************************************************************/
/*									*/
/* FB_FSTRAN FB_STATUS_TRANSLATE		SWK June 26, 1992	*/
/*									*/
/* Error Message Status Report						*/
/*									*/
/* Arguments:								*/
/*	(out)		FB_error_code		FSretcod		*/
/*	(in)		FB_environment_id	FSeid			*/
/*	(in)		FB_error_code		FSerrcod		*/
/*	(in)		FB_word			FSassoc			*/
/*	(in)		FB_integer		FSwhere_occured		*/
/*	(out)		FB_string		FSmessage		*/
/*	(in)		FB_integer		FSlength		*/
/*									*/
/************************************************************************/
#define FB_FSTRAN( FSretcod, FSeid, FSerrcod, FSassoc, FSwhere, FSmessage, FSlength)     \
{									       \
char	*fb_temp_string;							       \
int	real_length;							       \
*FSretcod = FENORM; 							       \
if( fb_temp_string = (char *) malloc(256) )				       \
   {									       \
   sprintf( fb_temp_string,						       \
         FB_ERRTXT[FB_GET_ERROR_VALUE(FSerrcod)], FSassoc, FSwhere); 	       \
   real_length = strlen(fb_temp_string);					       \
   strncpy( FSmessage, fb_temp_string, FSlength);				       \
   if( real_length >= FSlength ) FSmessage[FSlength-1] = 0;		       \
   free(fb_temp_string);							       \
   }									       \
else									       \
   {									       \
   printErr( "FBSTD fb_status_translate could not malloc! \n");		       \
   *FSretcod = FEOOPS;							       \
   }									       \
}


#endif 	/* (ifdef INCfbstatusmacros) */

