/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	Fastbus primitives (for use under VxWorks shell)
 *	
 * Author:  Chip Watson, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: fb_fscc_prim.c,v $
 *   Revision 1.1.1.1  1996/08/21 19:20:38  heyes
 *   Imported sources
 *
*	  Revision 1.1  94/03/15  12:00:29  12:00:29  heyes (Graham Heyes)
*	  Initial revision
*	  
 *	  Revision 1.2  1993/04/28  17:12:36  watson
 *	  fixed error messages
 *
 *	  Revision 1.1  1993/04/14  20:40:23  watson
 *	  Initial revision
 *
 *	  Revision 1.1  1992/07/17  14:59:54  watson
 *	  Initial revision
 *
 *
 *	This file contains primitive routines to perform Fastbus actions on 
 *	the FSCC (PC3).  These are useful for interactive work under VxWorks.
 *	Routines in this file provide callable wrappers to the macro
 *	versions of the routines in fb_fscc_1.macro.
 *
 *  Compile Options:
 *  ----------------
 *	FB_BUILD_NEWSEQ   remove most inline error checking code (for use
 *			  with new CEBAF sequencer code)
 *
 *  Public Routines:
 *  ---------------
 *	fparb()			arbitrate
 *	fpad(pa)		primary address data space
 *	fpac(pa)		primary address control space
 *	fpsaw(sa)		secondary address write
 *	fpsar()			secondary address read
 *	fpr()			read word (returned as function value)
 *	fpw(data)		write word
 *	fprb()			read block (types values as hex)
 *	fpwb(array)		write block
 *	fparel()		address release
 *	fprel()			bus release
 */
#include "vxWorks.h"
#include "stdioLib.h"
#include "fb_fscc_macro.h"
#include "fb_types.h"
#include "fb_status_macros.h"
#define IFERROR(str,pad,sad) \
  if (fb_errno!=FB_ERR_NORMAL) \
    printf(FB_ERRTXT[FB_GET_ERROR_VALUE(fb_errno)],fb_errno,str,NULL,pad,sad);

int fparb()
{
  FB_RD_SINGLE(AD,0,0,0,0,0,1,1,1,1,1); /* arb */
  IFERROR("fparb",0,0);
  return 0;
}

int fpad(int pa)
{
  FB_RD_SINGLE(AD,pa,0,0,1,1,0,1,1,1,1);	/* pa (eg) */
  IFERROR("fpad",pa,0);
  return 0;
}

int fpac(int pa)
{
  FB_RD_SINGLE(AC,pa,0,0,1,1,0,1,1,1,1);	/* pa (eg) */
  IFERROR("fpac",pa,0);
  return 0;
}

int fpsaw(int sa)
{
  FB_RD_SINGLE(AD,0,sa,0,0,1,1,0,1,1,1);	/* sa */
  IFERROR("fpsaw",0,sa);
  return 0;
}

int fpsar()
{
  int sa;
  FB_RD_SA(AD,0,&sa,0,1,1,0,1,1); /*noeg,noarb,nopa,sa,holdas,hold*/
  IFERROR("fpsar",0,0);
  return sa;
}


int fpr()
{
  int data;
  FB_RD_SINGLE(AD,0,0,&data,0,1,1,1,0,1,1);
  IFERROR("fpr",0,0);
  return data;
}

int fpw(int data)
{
  FB_WR_SINGLE(AD,0,0,data,0,1,1,1,0,1,1);
  IFERROR("fpw",0,0);
  return 0;
}

int fprb()
{
  int i,j,data[256],*dp;
  FB_RD_BLOCK(AD,0,0,data,1024,0,1,1,1,0,0,1,1,0);
  IFERROR("fprb data",0,0);
  FB_FRLEN_1(&i);
  IFERROR("fprb length",0,0);
  i=i/4;
  dp = data;
  while (i>0) {
    for (j=(i>8)?8:i;j>0;j--) printf(" %x",*dp++);
    printf("\n");
    i -=8;
  }
  return 0;
}

int fpwb(int *data,int len)
{
  FB_WR_BLOCK(AD,0,0,data,len,0,1,1,1,0,0,1,1,0);
  IFERROR("fpwb",0,0);
  return 0;
}

int fparel()
{
  FB_RD_SINGLE(AD,0,0,0,1,1,1,1,1,0,1);	/* release as */
  IFERROR("fparel",0,0);
  return (fb_errno);
}

int fprel()
{
  FB_RD_SINGLE(AD,0,0,0,1,1,1,1,1,0,0);	/* release bus */
  IFERROR("fprel",0,0);
  return (fb_errno);
}
