/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *    xcefdmp dictionary tree display routines
 *	
 * Author:  Jie Chen
 *          CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: xdict_tree.c,v $
 *   Revision 1.1.1.1  1996/09/19 18:26:24  chen
 *   original port to solaris
 *
 *	  Revision 1.3  1995/04/05  19:21:46  chen
 *	  fix bug on opening a dictionary when one is spying on an event
 *
 *	  Revision 1.2  1995/02/28  21:11:24  chen
 *	  check whether one is viewing the same dictionary file
 *
 *	  Revision 1.1  1994/12/08  19:58:56  chen
 *	  Initial revision
 *
 *	  
 */
#include <stdio.h>
#include <string.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/PushB.h>
#include <Xm/Form.h>
#include <Xm/ScrolledW.h>
#include <Xm/DialogS.h>
#include <TreeCODA.h>

#include "xcef_layout.h"

static Widget dcx[MAX_DNODE];             /* pushbuttons inside tree widget */
static int    num_of_dnode = 0;           /* num of pbtns inside tree       */
static int    prev_num_of_dnode = 0;      /* previous numofdnode in prev stp*/

Widget dict_shell = (Widget)0;
Widget dict_tree = (Widget)0;

/****************************************************************************
 *         static void clean_d_tree()                                       *
 * Description:                                                             *
 *     Clean up memory and resources for all pushbuttons inside dictionary  *
 *     tree widget 'dict_tree'                                              *
 ***************************************************************************/
static void clean_d_tree(dtr)
Widget dtr;
{
  int i;
  Arg arg[10];
  int ac = 0;
  XtCallbackRec *callback;
  
  XtUnmanageChildren(dcx, prev_num_of_dnode);
  XtUnmanageChild(dtr);

  XcodaResetTreeConstraints(dtr);
  for(i = 0;i < prev_num_of_dnode;i++){
    /* Free memory allocated for all callbacks */
    XtSetArg (arg[ac], XmNactivateCallback, &callback); ac++;
    XtGetValues (dcx[i], arg, ac);
    free (callback->closure);
    ac = 0;

    XtRemoveAllCallbacks(dcx[i],XmNactivateCallback);
    XcodaResetTreeChildResource(dcx[i]);
  }
  ac = 0;
  XtSetArg (arg[ac], XmNwidth, 100); ac++;
  XtSetArg (arg[ac], XmNheight, 100); ac++;
  XtSetValues (dtr, arg, ac);
  ac = 0;
}

/****************************************************************************
 *         static void count_dtree_nodes ( )                                *
 * Description:                                                             *
 *     Count number of tree nodes inside one tree                           *
 ***************************************************************************/
static void count_dtree_nodes(rt_d,i)
TREE_NODE *rt_d;
int       *i;
{
  TREE_NODE *p;
  int        n;

  p = rt_d;
  n = *i;
  if(p != NULL){
    *i = *i +1;
    count_dtree_nodes(p->mleft,i);
    count_dtree_nodes(p->rsibling,i);
  }
}

/****************************************************************************
 *              void visit_d_tree ( )                                       *
 * Description:                                                             *
 *     Convert a tree structure into an array representation                *
 ***************************************************************************/
static void visit_d_tree(rt_d,i,dnode,parent)
TREE_NODE *rt_d;
int       *i;
DXNODE    dnode[];
Widget    parent;
{
  TREE_NODE *p;
  int        n;

  p = rt_d;
  n = *i;
  if(p != NULL){
    dnode[n].p = p;
    dnode[n].nc = n;
    *i = *i +1;
    visit_d_tree(p->mleft,i,dnode,parent);
    visit_d_tree(p->rsibling,i,dnode,parent);
  }
}

/*****************************************************************************
 *      static void select_tag ()                                            *
 * Description:                                                              *
 *     Select a tag from a dictionary tree. Callback function for the        *
 *     pushbuttons inside the dictionary tree widget.                        *
 *     This routine will do nothing for spying event mode                    *
 ****************************************************************************/
static void select_tag(w,tnode,cbs)
Widget w;
DXNODE *tnode;
XmAnyCallbackStruct *cbs;
{
  Arg    wargs[2];
  int    ac = 0;
  static Position cur_p;

  if (view_mode == 0){ /* view a file */
    strcpy(TAG,tnode->p->name);
    XmTextSetString(text_in2,TAG);
    cur_p = strlen(TAG);
    XtSetArg(wargs[ac], XmNcursorPosition, cur_p); ac++;
    XtSetValues(text_in2, wargs, ac); 
    ac = 0;
    XmTextShowPosition(text_in2,cur_p);
    if(!is_string_empty (SOURCE))
      view_ev(NULL,(XtPointer)0,NULL);
    /* tnode memory will be freed by clean_dtree() */
  }
}

/****************************************************************************
 *         void show_d_tree ( )                                             *
 * Description:                                                             *
 *     Show dictionary tree structure for a given dictionary                *
 ***************************************************************************/
void show_d_tree (root_d, num_t, tr)
TREE_NODE *root_d[];
int       num_t;
Widget    tr;
{
  int        i,j,k,m;
  int        single_num_dnode, num_used_pb;
  DXNODE     dnode[MAX_DNODE],*t_node;
  TREE_NODE  *p;
  Arg        args[10];
  int        ac = 0;
  XmString   t;

  if(prev_num_of_dnode != 0){
    clean_d_tree(tr);
  }

  num_of_dnode = 0;
  for(j = 0; j < num_t; j++){
    i = 0;
    p = root_d[j];
    count_dtree_nodes(p,&i);
    num_of_dnode += i;
  }

  if(num_of_dnode > prev_num_of_dnode){ /* needs more buttons */
    for(j= prev_num_of_dnode; j < num_of_dnode; j++){
      dcx[j] = XtCreateWidget("t_node",xmPushButtonWidgetClass,tr,NULL,0);
    }
  }
  if(num_of_dnode < prev_num_of_dnode){
    for(j=num_of_dnode; j< prev_num_of_dnode; j++){
      XtDestroyWidget(dcx[j]);
      dcx[j] = (Widget)0;
    }
  }
  prev_num_of_dnode = num_of_dnode;

  num_used_pb = 0;        /* how many buttons we have used */
  for(m = 0;m < num_t;m++){
    i=0;
    p = root_d[m];
    visit_d_tree(p,&i,dnode,tr);
    single_num_dnode = i;

    t = XmStringCreateSimple(dnode[0].p->name);
    XtSetArg(args[ac],XmNlabelString,t); ac++;
    XtSetValues(dcx[0+num_used_pb],args, ac);
    ac = 0;
    t_node=(DXNODE *)malloc(sizeof(DXNODE));
    t_node->nc = dnode[0].nc;
    t_node->p = dnode[0].p;
    /* memory allocated here will be released by clean_d_tree */
    XtAddCallback(dcx[0+num_used_pb],XmNactivateCallback,select_tag,t_node);
    XmStringFree(t);

    for(j=1;j<single_num_dnode;j++){
      for(k=0;k< single_num_dnode;k++){
	if(dnode[j].p->parent == dnode[k].p)
	  break;
      }
      t=XmStringCreateSimple(dnode[j].p->name);       
      XtSetArg(args[ac],XcodaNsuperNode,dcx[k+num_used_pb]); ac++;
      XtSetArg(args[ac],XmNlabelString,t); ac++;
      XtSetValues(dcx[j+num_used_pb], args,ac);
      ac = 0;

      t_node=(DXNODE *)malloc(sizeof(DXNODE));
      t_node->nc = dnode[j].nc;
      t_node->p = dnode[j].p;
      XtAddCallback(dcx[j+num_used_pb],XmNactivateCallback,select_tag,t_node);
      XmStringFree(t);
    }
    num_used_pb += single_num_dnode;
  }
  XtManageChildren(dcx,num_of_dnode);
  XtManageChild(tr);
}

/*****************************************************************************
 *      static void pop_down_dict( )                                         *
 * Description:                                                              *
 *      Callback function for dictionart tree shell close button             *
 ****************************************************************************/
static void pop_down_dict(w,client_data,cbs)
Widget w;
XtPointer client_data;
XmPushButtonCallbackStruct *cbs;
{
  XtSetSensitive(menu1_1,True);
  XtPopdown(dict_shell);
}

/*****************************************************************************
 *      static void erase_tag ()                                             *
 * Description:                                                              *
 *     Callback for "No Tags" Button for tree shell                          *
 ****************************************************************************/
void erase_tag(w,client_data,cbs)
Widget        w;
XtPointer     client_data;
XmPushButtonCallbackStruct *cbs;
{
  if(view_mode == 0){
    empty_string (TAG);
    XmTextSetString(text_in2,"");
    
    if(is_string_empty (SOURCE))
      ;
    else
      view_ev(NULL,(XtPointer)0,NULL);
    return;
  }
  else{
    pop_error_message("You cannot delete this tag!!\n",text_in2);
    return;
  }
}

/*****************************************************************************
 *           void popup_dict_shell ()                                        *
 * Description:                                                              *
 *      Popup a dictionary tree shell                                        *
 ****************************************************************************/
void popup_dict_shell (base)
Widget base;
{
  Arg       wargs[20];
  int       ac = 0;
  Position  xt, x, y;
  Widget    out_rc, action_form, scrw;
  Widget    sc_window, action[4];
  Widget    hscb, vscb, clip_w;
  Dimension height;
  XmString  stt;
  static    char prevDict[200];

  if(!dict_shell){
    strcpy (prevDict, "/tmp/junk");
    XtSetArg(wargs[ac],XmNheight,&height); ac++;
    XtGetValues(base,wargs,ac);
    ac = 0;

    XtTranslateCoords(base,(Position)0,(Position)height,&x,&y);
    XtSetArg(wargs[ac],XmNx,x); ac++;
    XtSetArg(wargs[ac],XmNy,y); ac++;
    XtSetArg(wargs[ac],XmNtitle,"Dictionary Display"); ac++;
    XtSetArg(wargs[ac],XmNiconPixmap,dict_icon); ac++;
    XtSetArg(wargs[ac],XmNiconName,"Dictionary"); ac++;
    dict_shell = XtCreatePopupShell("dict_shell",
				    applicationShellWidgetClass,base,
				    wargs,ac);
    ac = 0;

    out_rc = (Widget)XtCreateWidget("dict_out_rc",
				    xmFormWidgetClass,dict_shell,wargs, ac);
    ac = 0;
    
    XtSetArg(wargs[ac], XmNscrollingPolicy, XmAUTOMATIC); ac++;
    XtSetArg(wargs[ac], XmNscrollBarDisplayPolicy, XmSTATIC); ac++;
    XtSetArg(wargs[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
    XtSetArg(wargs[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(wargs[ac], XmNbottomOffset,     35); ac++;
    XtSetArg(wargs[ac], XmNleftAttachment,   XmATTACH_FORM); ac++;
    XtSetArg(wargs[ac], XmNrightAttachment,  XmATTACH_FORM); ac++;
    XtSetArg(wargs[ac], XmNwidth,            300); ac++;
    XtSetArg(wargs[ac], XmNheight,           400); ac++;
    sc_window = XtCreateManagedWidget("dict_sc_window",
				      xmScrolledWindowWidgetClass,
				      out_rc, wargs, ac);
    ac = 0;
    
    XtSetArg(wargs[ac], XmNborderWidth, 0); ac++;
    if(show_tree_mode == 0){  /* star tree mode */
      XtSetArg(wargs[ac], XcodaNtreeType, XcodaTILTREE); ac++;
    }
    else{
      XtSetArg(wargs[ac], XcodaNtreeType, XcodaRECTREE); ac++;
    }
    dict_tree = (Widget)XtCreateWidget("dict_tr_show",
				       xcodaTreeWidgetClass,
				       sc_window,wargs,ac);
    ac = 0;

    XtSetArg (wargs[ac], XmNhorizontalScrollBar, &hscb); ac++;
    XtSetArg (wargs[ac], XmNverticalScrollBar, &vscb); ac++;
    XtSetArg (wargs[ac], XmNclipWindow, &clip_w); ac++;
    XtGetValues (sc_window, wargs, ac);
    ac = 0;

    XtSetArg(wargs[ac],XmNfractionBase,40); ac++;
    XtSetArg(wargs[ac],XmNtopAttachment, XmATTACH_WIDGET); ac++;
    XtSetArg(wargs[ac],XmNtopWidget,     sc_window); ac++;
    XtSetArg(wargs[ac],XmNtopOffset,     5); ac++;
    XtSetArg(wargs[ac],XmNleftAttachment,XmATTACH_FORM); ac++;
    XtSetArg(wargs[ac],XmNrightAttachment,XmATTACH_FORM); ac++;
    XtSetArg(wargs[ac],XmNbottomAttachment,XmATTACH_FORM); ac++;
    action_form = (Widget)XtCreateManagedWidget("dict_action_form",
						xmFormWidgetClass,
						out_rc,wargs,ac);
    ac = 0;
    
    stt = XmStringCreateSimple("Cancel");
    XtSetArg(wargs[ac], XmNtopAttachment,     XmATTACH_FORM); ac++;
    XtSetArg(wargs[ac], XmNbottomAttachment,  XmATTACH_FORM); ac++;
    XtSetArg(wargs[ac], XmNleftAttachment,    XmATTACH_POSITION); ac++;
    XtSetArg(wargs[ac], XmNleftPosition,      2); ac++;
    XtSetArg(wargs[ac], XmNrightAttachment,   XmATTACH_POSITION); ac++;
    XtSetArg(wargs[ac], XmNrightPosition,     18); ac++;
    XtSetArg(wargs[ac], XmNlabelString,       stt); ac++;
    action[0]=(Widget)XtCreateManagedWidget("dict_button",
					    xmPushButtonWidgetClass,
					    action_form,wargs, ac);
    ac = 0;
    XmStringFree(stt);
    XtAddCallback(action[0],XmNactivateCallback,pop_down_dict,(XtPointer)NULL);
    
    stt = XmStringCreateSimple("No Tags");
    XtSetArg(wargs[ac], XmNtopAttachment,     XmATTACH_FORM); ac++;
    XtSetArg(wargs[ac], XmNbottomAttachment,  XmATTACH_FORM); ac++;
    XtSetArg(wargs[ac], XmNleftAttachment,    XmATTACH_POSITION); ac++;
    XtSetArg(wargs[ac], XmNleftPosition,      22); ac++;
    XtSetArg(wargs[ac], XmNrightAttachment,   XmATTACH_POSITION); ac++;
    XtSetArg(wargs[ac], XmNrightPosition,     38); ac++;
    XtSetArg(wargs[ac], XmNlabelString,       stt); ac++;
    action[1]=(Widget)XtCreateManagedWidget("dict_button",
					    xmPushButtonWidgetClass,
					    action_form,wargs, ac);
    XmStringFree(stt);
    ac = 0;
    XtAddCallback(action[1],XmNactivateCallback,erase_tag,(XtPointer)NULL);
    
    XtManageChild(out_rc);
  }
  /* check whether one has the same dictionary file or not */
  if (strcmp (prevDict, DIRC) != 0){
    show_d_tree(root_d,num_of_tree,dict_tree);
    strcpy (prevDict, DIRC);
  }
  XtPopup(dict_shell,XtGrabNone);
}
  
