/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *   Public header file for tree Widget
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: TreeCODA.h,v $
 *   Revision 1.1.1.1  1996/09/19 18:26:25  chen
 *   original port to solaris
 *
 *	  Revision 1.1  1994/12/08  19:55:15  chen
 *	  Initial revision
 *
 *	  Revision 1.1  1994/04/06  14:34:57  chen
 *	  Initial revision
 *
*	  Revision 1.1  94/03/15  15:18:56  15:18:56  heyes (Graham Heyes)
*	  Initial revision
*	  
*	  Revision 1.1  93/10/27  09:39:18  09:39:18  heyes (Graham Heyes)
*	  Initial revision
*	  
 *	  Revision 1.2  1993/06/21  13:23:47  chen
 *	  add two useful routines for resetting children's resources
 *
 */
#ifndef TREECODA_H
#define TREECODA_H

extern WidgetClass  xcodaTreeWidgetClass;

typedef struct _XcodaTreeClassRec *XcodaTreeWidgetClass;
typedef struct _XcodaTreeRec      *XcodaTreeWidget;

#define XcodaRECTREE             0  /* Rectangle shape tree */
#define XcodaTILTREE             1  /* regular   shape tree */

#define XcodaNhorizontalSpace    "horizontalSpace"
#define XcodaNverticalSpace      "verticalSpace"
#define XcodaNconLineWidth       "conLineWidth"
#define XcodaNsuperNode          "superNode"
#define XcodaNtreeType           "treeType"

#define XtCPad                   "Pad"
#define XtCSuperNode             "SuperNode"

extern void XcodaResetTreeChildResource();
extern void XcodaResetTreeConstraints();

#endif TREECODA_H
