/* This program puts the values to IOC channels
  It reads an input file which contains a list of
  channel_name &  string_value and puts the specified 
  string_value to the channel. 
  It can only handle up to 1000 channels at one time.
*/
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "chandata.h"

extern chandata *pchandata;
FILE *fr,*fw;

main(argc,argv)
int argc;
char **argv;
{
int noName,i;
char pvName[1000][NAME_LENGTH];
char *str,value[1000][MAX_STRING_SIZE];
chid pchid[1000];

str = value[0];
bzero(str,1000*MAX_STRING_SIZE);

if (argc == 1) {
	printf("\nUsage:  caPut <infile>\n\n");
        printf("  <infile>   -   Required, which contains a list of lines, each line\n");
	printf("                 consists of a channel name and the corresponding value\n");
	printf("                 to be put to IOC.  If the value is left blank which \n");
	printf("                 will not be recorded to IOC.\n\n");
	exit(1);
	}

	noName = readPutValue(argv[1],pvName,value); 
	caPutStringArray(noName,pvName,pchid,value);
	printf(" *** caPut completed normally ***\n");
}

caPutStringArray(noName,pvName,pchid,value)
int noName;
char pvName[][NAME_LENGTH];
char value[][MAX_STRING_SIZE];
chid pchid[];
{
int i;
	ca_task_initialize();

	for (i=0;i<noName;i++) 
		ca_search(pvName[i],&pchid[i]);
	ca_pend_io(30.0);

	printf("\n");
	for (i=0;i<noName;i++) 
		if (ca_field_type(pchid[i]) != TYPENOTCONN) {
		if (strlen(value[i]) > 0) {
		ca_put(DBR_STRING,pchid[i],value[i]); 
		printf("%-30s %s\n",pvName[i],value[i]);
			}
		}
		else printf("%-30s  *** NOT FOUND / NOT CONNECTED ***\n",pvName[i]);
	ca_pend_io(30.0);

	ca_task_exit();
}

int readPutValue(filename,pvName,value)
char *filename;
char pvName[][NAME_LENGTH];
char value[][MAX_STRING_SIZE];
{
struct stat buf;
off_t filesize;
char *ptr,buff[81];
char name[NAME_LENGTH],val[MAX_STRING_SIZE]; 
int l,i,no,len;

if ((fr = fopen(filename,"r")) == NULL ) {
	printf("Error: caPut failed to open the input file  '%s'\n",filename);
	exit(1);
	}
	l = 0;
	while ((ptr = fgets(buf,80,fr)) != NULL) {
	len = strlen(ptr); if (*(ptr+len-1) == '\n') *(ptr+len-1) = '\0';
	no=0;
	while(*(ptr+no) == ' ' || *(ptr+no) == '\t') no++;
	sscanf(ptr,"%s",pvName[l]);
	no += strlen(pvName[l]);
	while(*(ptr+no) == ' ' || *(ptr+no) == '\t') no++;
	strcpy(value[l],ptr+no);
		l++;	
		}
	return l;	
}
