/* This file contains several timer utilities */

#include <stdio.h>
#include <signal.h>
#include <errno.h>
#include <sys/time.h>

int fsleep_inter_called;

int fsleep(sleep_time)
float sleep_time;
{
  struct itimerval newval,oldval;
  int err;
  void fsleep_int_rou();

  newval.it_interval.tv_sec = 0;
  newval.it_interval.tv_usec = 0;
  newval.it_value.tv_sec = (int)sleep_time;
  newval.it_value.tv_usec = (((int)((sleep_time*1000000.)+.5))%1000000);

/*
  printf("fsleep; sleeping for %d sec %d us\n",
	 newval.it_value.tv_sec,newval.it_value.tv_usec);
*/

  signal(SIGALRM,fsleep_int_rou);
  fsleep_inter_called = 0;

  err = setitimer(ITIMER_REAL,&newval,&oldval);
  if (err == -1) {
    perror("fsleep");
    return(err);
  }

  if (!fsleep_inter_called) {
    err = pause();
    if (err == -1) {
      if (errno == EINTR) err = 0;
      else perror("fsleep");
    }
    return(err);
  }
}

void fsleep_int_rou()
{
  fsleep_inter_called = 1;
}
