/*
 * ddp_ui_callbacks.c 
 *          :  Callbacks for the ddp (dd processes) display   
 * Author   :  C.Witzig
 * Date     :  Apr 24, 1992
 * Mods     :
 */


#include <sys/types.h>
#include <unistd.h>
#include <sys/signal.h>
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/Text.h>
#include <e787util.h>
#include <Xm/Scale.h>

#include <errno.h>
#include <stdlib.h>
#include <sys/time.h>
#include <string.h>

#include <dd_dcom.h>
#include <fifo.h>
#include <db.h>

extern Widget     DDP_TEXT;
extern Widget     DDP_START_B;
extern Widget     DDP_STOP_B;
extern Widget     DDP_EXIT_B;
extern Widget     SEL_PID_TF;
/*
 * Frequency of updating: In seconds and
 * microseconds.
 */
#define TSEC_UPDATE 2
#define TUSEC_UPDATE 0

/* note the following unlogical notation but 
 *  there is no easy way to initialise a long
 *  array than this
 */
#define ON 0
#define OFF 1

static int init = 0;
static int nproc_dd_att = 0;
static int timer_on = 0;
static int no_update = FALSE;


/*
 * positions and lengths of the strings to update 
 */
#define DD_LINES_PHEAD 2
#define DD_LINES_PPROC 7

/* flag for displaying selected processes */
static int proc_disp[DD_MAX_NPROC_ATT];
static int nproc2display; 
static XmTextPosition Xpos[2+DD_MAX_NPROC_ATT*DD_LINES_PPROC];
static XmTextPosition Xlen[2+DD_MAX_NPROC_ATT*DD_LINES_PPROC];

static char *xf_head[DD_LINES_PHEAD] = {
  " number of dd_ctl    attached %3i \n",
  " number of processes attached %3i \n\n"};

static char *xf_proc[DD_LINES_PPROC] = {
  " ---> process pid     %6i     \n",
  "      process name    %8s     \n",
  "      process fifo    %4i     \n",
  "      process status  %9s     \n",
  "      process read    %4i %8i \n",
  "      process write   %4i %8i \n",
  "      start time      %2i:%2i:%2i  [%2i-%2i-%2i] \n\n" };

static unsigned int old_read[DD_MAX_NPROC_ATT], old_write[DD_MAX_NPROC_ATT];

static char *dd_proc_states[9] = {
  "unused   ",
  "idle     ",
  "active   ",
  "reqfev   ",
  "putfev   ",
  "brcfev   ",
  "getfev   ",
  "relfev   ",
  "deblocked"
  };


static Arg al[64];


static void cleanup()
{
  struct itimerval tto, tti = {0,0,0,0};

  if (timer_on){
	 if (setitimer(ITIMER_REAL, &tti, &tto)){
		fprintf(stderr," error in setitimer %s \n",strerror(errno));
		exit(1);
	 }
  }
  fifo_close(0);
  db_close(0);
}


/*
 * displaying things....
 */



void display_init()
{
  int i;
  XmTextPosition spos;
  struct tm ts;
  char text[80];
  extern Display *display;

  XmTextSetString(DDP_TEXT,"");

  spos = XmTextGetLastPosition(DDP_TEXT);
  
  XmTextInsert(DDP_TEXT,spos,"\n\n        *****  DD  SYSTEM  ***** \n\n               ----------- \n \n");

  spos = XmTextGetLastPosition(DDP_TEXT);
  sprintf(text,xf_head[0],
					dd_dcom->dd_nmstr);
  XmTextInsert(DDP_TEXT,spos,text);
  Xpos[0] = spos;
  Xlen[0] = strlen(text);

  spos = XmTextGetLastPosition(DDP_TEXT);
  sprintf(text,xf_head[1],
					dd_dcom->dd_nproc_att);
  XmTextInsert(DDP_TEXT,spos,text);
  Xpos[1] = spos;
  Xlen[1] = strlen(text);
  
  nproc2display = 0;
  nproc_dd_att = 0;
  for (i=0;i<DD_MAX_NPROC_ATT;i++){
    if ( dd_dcom->dd_proc[i].pid != -1 )
      nproc_dd_att++;
  }

  for (i=0;i<DD_MAX_NPROC_ATT;i++){
    if ( (dd_dcom->dd_proc[i].pid != -1) && (proc_disp[i] == ON) ) {
      nproc2display++;
      
      sprintf(text,xf_proc[0], 
	      dd_dcom->dd_proc[i].pid);
      spos = XmTextGetLastPosition(DDP_TEXT);
      XmTextInsert(DDP_TEXT,spos,text);
      Xpos[2+i*DD_LINES_PPROC] = spos;
      Xlen[2+i*DD_LINES_PPROC] = strlen(text);
      
      sprintf(text,xf_proc[1], 
	      dd_dcom->dd_proc[i].pname);
      spos = XmTextGetLastPosition(DDP_TEXT);
      XmTextInsert(DDP_TEXT,spos,text);
      Xpos[2+i*DD_LINES_PPROC+1] = spos;
      Xlen[2+i*DD_LINES_PPROC+1] = strlen(text);
      
      sprintf(text,xf_proc[2], 
	      dd_dcom->dd_proc[i].fifo);
      spos = XmTextGetLastPosition(DDP_TEXT);
      XmTextInsert(DDP_TEXT,spos,text);
      Xpos[2+i*DD_LINES_PPROC+2] = spos;
      Xlen[2+i*DD_LINES_PPROC+2] = strlen(text);
      
      sprintf(text,xf_proc[3], 
	      dd_proc_states[dd_dcom->dd_proc[i].status]);
      spos = XmTextGetLastPosition(DDP_TEXT);
      XmTextInsert(DDP_TEXT,spos,text);
      Xpos[2+i*DD_LINES_PPROC+3] = spos;
      Xlen[2+i*DD_LINES_PPROC+3] = strlen(text);
      
      sprintf(text,xf_proc[4], 
	      0,
	      dd_dcom->dd_proc[i].ngetfev);
      old_read[i] = dd_dcom->dd_proc[i].ngetfev;
      spos = XmTextGetLastPosition(DDP_TEXT);
      XmTextInsert(DDP_TEXT,spos,text);
      Xpos[2+i*DD_LINES_PPROC+4] = spos;
      Xlen[2+i*DD_LINES_PPROC+4] = strlen(text);
      
      sprintf(text,xf_proc[5], 
	      0,
	      dd_dcom->dd_proc[i].nputfev);
      old_write[i] = dd_dcom->dd_proc[i].nputfev;
      spos = XmTextGetLastPosition(DDP_TEXT);
      XmTextInsert(DDP_TEXT,spos,text);
      Xpos[2+i*DD_LINES_PPROC+5] = spos;
      Xlen[2+i*DD_LINES_PPROC+5] = strlen(text);
      
      ts = dd_dcom->dd_proc[i].tstart;
      sprintf(text,xf_proc[6], 
	      ts.tm_hour, ts.tm_min, ts.tm_sec, 
	      ts.tm_mon, ts.tm_mday,ts.tm_year);
      spos = XmTextGetLastPosition(DDP_TEXT);
      XmTextInsert(DDP_TEXT,spos,text);
      Xpos[2+i*DD_LINES_PPROC+6] = spos;
      Xlen[2+i*DD_LINES_PPROC+6] = strlen(text);
      
    }
  }
  

  XFlush(display);

  return;
}


void display_update()
{
  int i,j;
  int rate;
  struct tm ts;
  char text[80];
  extern Display *display;
  XmTextPosition spos;

  static struct itimerval tto_on, tti_on = {TSEC_UPDATE,TUSEC_UPDATE, TSEC_UPDATE,TUSEC_UPDATE};
  static struct itimerval tto_off, tti_off = {0, 0, 0, 0};

  if (setitimer(ITIMER_REAL, &tti_off, &tto_off)){
    fprintf(stderr," error in setitimer %s \n",strerror(errno));
    exit(1);
  }
  timer_on = 0;

  if ( no_update ) 
    return;

  if (dd_dcom->dd_nproc_att != nproc_dd_att)
	 display_init();

  sprintf(text,xf_head[0],
               dd_dcom->dd_nmstr);
  XmTextReplace(DDP_TEXT,Xpos[0],Xpos[0]+Xlen[0],text);

  sprintf(text,xf_head[1],
               dd_dcom->dd_nproc_att);
  XmTextReplace(DDP_TEXT,Xpos[1],Xpos[1]+Xlen[1],text);
  
  for (i=0;i<DD_MAX_NPROC_ATT;i++){
    if ( (dd_dcom->dd_proc[i].pid > 0)&& (proc_disp[i]==ON) ){

      j = 2 + i*DD_LINES_PPROC;

/*      
      sprintf(text,xf_proc[0], 
              dd_dcom->dd_proc[i].pid);
      XmTextReplace(DDP_TEXT,Xpos[j],Xpos[j]+Xlen[j],text);
      
      sprintf(text,xf_proc[1], 
              dd_dcom->dd_proc[i].pname);
      XmTextReplace(DDP_TEXT,Xpos[j+1],Xpos[j+1]+Xlen[j+1],text);
      
      sprintf(text,xf_proc[2], 
              dd_dcom->dd_proc[i].fifo);
      XmTextReplace(DDP_TEXT,Xpos[j+2],Xpos[j+2]+Xlen[j+2],text);

*/    
      sprintf(text,xf_proc[3], 
              dd_proc_states[dd_dcom->dd_proc[i].status]);
      XmTextReplace(DDP_TEXT,Xpos[j+3],Xpos[j+3]+Xlen[j+3],text);
      
      rate = (dd_dcom->dd_proc[i].ngetfev - old_read[i]) / 
	(TSEC_UPDATE + 0.000001*TUSEC_UPDATE);
      sprintf(text,xf_proc[4], 
              rate,
              dd_dcom->dd_proc[i].ngetfev);
      XmTextReplace(DDP_TEXT,Xpos[j+4],Xpos[j+4]+Xlen[j+4],text);
      old_read[i] = dd_dcom->dd_proc[i].ngetfev;
      
      rate = (dd_dcom->dd_proc[i].nputfev - old_write[i]) 
	/ (TSEC_UPDATE + 0.000001*TUSEC_UPDATE);
      sprintf(text,xf_proc[5], 
              rate,
              dd_dcom->dd_proc[i].nputfev);
      XmTextReplace(DDP_TEXT,Xpos[j+5],Xpos[j+5]+Xlen[j+5],text);
      old_write[i] = dd_dcom->dd_proc[i].nputfev;
/*      
      ts = dd_dcom->dd_proc[i].tstart;
      sprintf(text,xf_proc[6], 
              ts.tm_hour, ts.tm_min, ts.tm_sec, 
              ts.tm_mon, ts.tm_mday,ts.tm_year);
      XmTextReplace(DDP_TEXT,Xpos[j+6],Xpos[j+6]+Xlen[j+6],text);
*/      
    }
  }
  

  spos = XmTextGetLastPosition(DDP_TEXT);
  XmTextSetInsertionPosition(DDP_TEXT,spos);

  XFlush(display);


  signal(SIGALRM,display_update);

  if (setitimer(ITIMER_REAL, &tti_on,&tto_on)){
    fprintf(stderr," error in setitimer %s \n",strerror(errno));
    exit(1);
  }
  timer_on = 1;

  return;
}



void DDP_start()
{
  int i;
  void display_init(),display_update();
  char *p2c, filename[1024];
  static struct itimerval tto, tti = {TSEC_UPDATE,TUSEC_UPDATE, 									TSEC_UPDATE,TUSEC_UPDATE};

  if (!init){
    ddu_attach();
    init = 1;
    atexit(cleanup);
  }

  display_init();

  XtSetArg(al[0], XmNsensitive, FALSE);
  XtSetValues( DDP_START_B, al, 1);
  XtSetArg(al[0], XmNsensitive, TRUE);
  XtSetValues( DDP_STOP_B, al, 1);

  signal(SIGALRM,display_update);

  if (setitimer(ITIMER_REAL, &tti,&tto)){
    fprintf(stderr," error in setitimer %s \n",strerror(errno));
    exit(1);
  }
  timer_on = 1;
}

void DDP_stop()
{
  static struct itimerval tto, tti = {0,0,0,0};

  if (setitimer(ITIMER_REAL, &tti, &tto)){
    fprintf(stderr," error in setitimer %s \n",strerror(errno));
    exit(1);
  }
  timer_on = 0;

  XtSetArg(al[0], XmNsensitive, TRUE);
  XtSetValues( DDP_START_B, al, 1);
  XtSetArg(al[0], XmNsensitive, FALSE);
  XtSetValues( DDP_STOP_B, al, 1);
  XtSetArg(al[0], XmNsensitive, TRUE);
  XtSetValues( DDP_EXIT_B, al, 1);
}

void DDP_exit()
{
  exit(0);
}



/*
 * for selecting processe
 */

void proc_sel_done()
{
  int i, iproc, found;
  char *p2pid;
  static char *msg_no_proc = "no such process";

  if ( !init )
    DDP_start();
  
  no_update = TRUE;
  if ( nproc_dd_att == 0 ) 
    display_init();
  p2pid = XmTextGetString(SEL_PID_TF);
  sscanf(p2pid,"%d",&iproc);
  found = FALSE;
  for (i=0;i<DD_MAX_NPROC_ATT;i++){
    if ( dd_dcom->dd_proc[i].pid == iproc ) {
      found = TRUE;
      XmTextSetString(SEL_PID_TF,"");
      proc_disp[i] = ! (proc_disp[i]);
    }
  }
  if ( ! found  ) 
    XmTextSetString(SEL_PID_TF, msg_no_proc);

  display_init();
  no_update = FALSE;
}

void proc_sel_none()
{
  int i;

  if ( !init )
    DDP_start();

  no_update = TRUE;
  for (i=0;i<DD_MAX_NPROC_ATT;i++){
    proc_disp[i] = OFF;
  }

  display_init();
  no_update = FALSE;
}

void proc_sel_all()
{
  int i;

  if ( !init )
    DDP_start();

  no_update = TRUE;
  for (i=0;i<DD_MAX_NPROC_ATT;i++){
    proc_disp[i] = ON;
  }

  display_init();
  no_update = FALSE;
}
