/*
 * dd_ctl.c : This program is the main control program for the DD
 *          : system. It is used in two different ways:
 *          : 1. Directly from DUI. 
 *          : 2. As a server to the standalone dd_ui program.
 *          : Note: the difference between "exit" and "quit" command:
 *          :       exit is used by DUI and removes the DD completely.
 *          :       quit is used by dd_ui and only deattaches from the DD.  
 *
 * Author   :  C.Witzig
 * Date     :  Apr ?, 1992
 */

#include <stdio.h>
#include <time.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>
#include <dd_sys.h>
#include <dd_user.h>

#define TRUE 1
#define FALSE 0

static int go_on;

static void
sig_handler (int sig)
{
  go_on = 0;
  return;
}

main(int argc,char **argv)
{
  int			i, *p, len, imax, status;
  int			ctl[4];
  char			fname[100];
  struct fifo_entry	fev;
  struct fifo_mode	fmode;
  struct a_fifo		*afifo;

  strcpy(fname,"INPUT");
  putenv("DD_NAME=testy");
  
  fmode.mode     = FMODE_ALL;
  fmode.wait     = FWAIT_SLEEP;
  fmode.suser    = FMODE_MULTI_USER;
  fmode.p2ctl    = ctl;
  fmode.prescale = 1;
    
  for (i=0;i<4;i++)
    ctl[i] = -1;

  if ( (status = dds_create()) != 0 ) {
    printf("dds_create: status returned %d\n",status);
    exit(1);
  }

  /*
   * since fname = INPUT, ddu_init assumes we're not a
   * consumer and sets my_own_fifo to 0 CTCTCT
   */

  if ( (status = ddu_init(fname, fmode) ) != 0 ) {
    printf("ddu_init status %d \n",status);
    fflush(stdout);
    exit(1);
  }
/*
  printf("FIFO#   name    type   mode  status\n");
  for (i=0;i<max_fifo_nb;i++){
    afifo = fifo_shm_start + i;
    printf("  %2d   %6s    %s     %d      %d\n",
	afifo->fhdr.fnumber,
	afifo->fhdr.fname,
	afifo->fhdr.ftype,
	afifo->fhdr.fmode,
	afifo->fhdr.fstatus);
  }
  printf("status => 0=unused, 1=idle, 2=active\n");
  printf("mode   => 0=all,    1=cond, 2=onreq, 3=null\n");
  printf("my_own_fifo = %d\n", my_own_fifo);
*/

  signal (SIGINT,  sig_handler);
  signal (SIGHUP,  sig_handler);
  signal (SIGQUIT, sig_handler);
  signal (SIGTERM, sig_handler);
  
  go_on = TRUE;
  
  if ( (status = ddu_set_netswap(DDN_TRF_NOSWAP) ) != 0 ) 
    printf("dd_set_netswap: status = %d\n",status);

  while ( go_on && ddu_attached() ) {

    i = 0;
    printf("enter the number of events (0 to exit) \n");
    scanf("%d",&imax);
    printf("nloops = %d\n",imax);
    if ( imax <= 0 )
	go_on = FALSE;
    
    while ( go_on && (i++ < imax) ){

      if ( i%1 == 0 )
	printf("after iteration %d\n",i);

      len = 4;
      if ( i%5 == 0 ) {
	len = 100;
	printf("Big event here!\n");
      }

      if ((status = ddu_req_fev(len, &fev)) == 0) {
	/* p = fev.p2da;  */
	/* fev.len = len; */
	fev.ctlw1 = i%5+1;
	fev.ctlb1 = rand() & 3;
	fev.ctlw2 = 0;
	fev.ctlb2 = 0;
	if ( ( status = ddu_put_fev(fev) ) != 0){
	  printf("ddu_put_fev: status returned %d \n",status);		  
	  go_on = FALSE;
	}
      } else {
	printf("ddu_req_fev: status returned %d \n",status);	
	go_on = FALSE;
      }
    }
  }

  ddu_close();

  printf("dd cleaned up\n");
  return;
}
       
 

