


/*
 * dd_ctl.c : This program is the main control program for the DD
 *          : system. It is used in two different ways:
 *          : 1. Directly from DUI. 
 *          : 2. As a server to the standalone dd_ui program.
 *          : Note: the difference between "exit" and "quit" command:
 *          :       exit is used by DUI and removes the DD completely.
 *          :       quit is used by dd_ui and only deattaches from the DD.  
 *
 * Author   :  C.Witzig
 * Date     :  Apr ?, 1992
 *          :  Mar 30, 1995: include ddu_ins_fev
 *
 */

#include <stdio.h>
#include <time.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>

#include <dd_sys.h>
#include <dd_user.h>

#define TRUE 1
#define FALSE 0

void dump_fev(struct fifo_entry fev)
{
  int i, *p;

  printf("event dump : \n");
  printf("fifo event : shmid= %d dboff= %d p2da= %p len= %d \n",
	 fev.shmid, fev.dboff, fev.p2da, fev.len);
  printf("fifo event : w1= %d b1= %x w2= %d b2= %x\n", 
	 fev.ctlw1, fev.ctlb1, fev.ctlw2, fev.ctlb2);
  p = fev.p2da;
  for (i=0;i<10;i++)
	 printf("event %3i %p %x \n",i,p,*p++);
}


main()
{
  int i,i1,i2,i3;
  int *p;
  int j,len, dump, brc_flag, error;
  void show_sys();
  int status;
  int go_on;
  char what2do[100];
  char what1[100],what2[100],what3[100], answer;
  char fname[100];
  int reqcnt, ctl[4];
  struct fifo_entry fev, fev_example;
  struct fifo_mode fmode;

  printf("\n\n");
  printf(" ********************************************************\n");
  printf(" *                                                      *\n");
  printf(" *         welcome to the  DD  dummy consumer           *\n");
  printf(" *                                                      *\n");
  printf(" ********************************************************\n");
  printf("\n\n");

  printf("do you want to have the default dummy consumer? (y/n)\n");
  scanf("%c",&answer);

  if ( ddu_attach() )
    dds_create();

  if ( (answer == 'y') || (answer == 'Y') ){
    strcpy(fname,"CONS");
    fmode.mode = 0;
    fmode.wait = 0;
    fmode.prescale = 1;
    fmode.suser = FMODE_MULTI_USER;
    for (i=0;i<4;i++)
      ctl[i] = -1;
    brc_flag = 0;
    fmode.p2ctl = ctl;
  }
  else{
    printf("\n enter fifo name [auto for autonaming] ");
    scanf("%s",fname);
    if ( strcmp(fname,"auto") == 0 ) {
      int ififo;
      for (ififo = 0; ififo<10; ififo++ ) {
	sprintf(fname, "auto%d",ififo);
	printf("auto fifo - try %d\n",ififo);
	if ( ddu_fifo_exist(fname) <= 0 ) 
	  break;
      }
    }

    printf("\n enter fifo mode [ALL=0 COND=1 ONREQ=2]");
    scanf("%i",&fmode.mode);
    if ( fmode.mode == FMODE_ONREQ ){
      printf("\n enter the request count ");
      scanf("%i",&reqcnt);
    }
    printf("\n enter fifo prescale factor ");
    scanf("%i",&fmode.prescale);
    if ( fmode.prescale <= 0 )
      fmode.prescale = 1;
    printf("\n enter fifo wait [SLEEP=0 ASYNC=8]");
    scanf("%i",&fmode.wait);
    if ( fmode.wait != 0 )
      fmode.wait = FWAIT_ASYNC;
    printf("\n enter single user mode [MULTI=0 SINGLE=1]");
    scanf("%i",&fmode.suser);
    printf("\n enter 4 control words ");
    scanf("%i %i %i %i",&ctl[0],&ctl[1],&ctl[2],&ctl[3]);
    fmode.p2ctl = ctl;

    printf("enter brc_flag\n");
    scanf("%i",&brc_flag);
  }
  
  status = ddu_init(fname, fmode);
  printf("ddu_init status %d \n",status);
  if ( status )
    exit(1);

  if ( (fmode.mode == FMODE_ONREQ) && (reqcnt > 0) ){
    status = ddu_set_reqcnt(reqcnt);
    printf("ddu_setreq status %d \n",status);
  }

  if (brc_flag)
    ddu_set_brc(brc_flag);

  fflush(stdout);

  go_on = 1;
  dump = 0;
  error = 0;

  while (go_on && (ddu_attached()) ){
    if (gets(what2do) == NULL){
      if (errno != EINTR) {
	fprintf(stderr," dummy_consumer: error in gets %s \n",strerror(errno));
	perror(" main: gets");
	go_on = 0;
      }
    }
    else if ( ddu_attached() ) {
      if (strstr(what2do,"exit")){
	go_on = 0;
      }
      else if (strstr(what2do,"get")){
	sscanf(what2do,"%s %i1",what1,&i1);
	error = FALSE;
	ddu_start();
	for ( i=0; (i<i1) && (! error) ; i++){
	  status = ddu_get_fev(&fev);
	  sleep(1);
	  if (status == 0){
	    printf("got an event!\n");
	    if ( dump )
	      dump_fev(fev);
	    if ( (status = ddu_put_fev(fev)) != 0 ) {
	      printf("ddu_put_fev: status returnd %d\n",status);
	      error = TRUE;
	    }
	  }
	  else {
	    printf("ddu_get_fev: status returned %d\n",status);
	    error = TRUE;
	  }
	  if ( i%10000 == 0 )
	    printf("now I am at event %i \n",i);
	}
	ddu_stop(); 
	printf("I just consumed %i events \n",i);
      }
      else if (strstr(what2do,"put")){
	sscanf(what2do,"%s %i1",what1,&i1);
	for ( i=0; i<i1 && !error ; i++){
	  len = 1000;
	  if (i%100 == 0)
	    len = 60000;
	  status = ddu_req_fev(len, &fev);
	  if (status == 0){
	    p = fev.p2da;
	    for (j=0;j<len;j++)
	      *p++ = j;
	    fev.len = len;
	    fev.ctlw1 = i%4+1;
	    fev.ctlb1 = 0;
	    fev.ctlw2 = 123;
	    fev.ctlb2 = 0x0f000000;
	    if ( ( status = ddu_put_fev(fev) ) != 0 ) {
	      printf("ddu_put_fev: status returned %d \n",status);		  
	      error = TRUE;
	    }
	  }
	  else {
	    printf("ddu_req_fev: status returned %d\n",status);
	    error = TRUE;
	  }
	  if ( i%10000 == 0 )
	    printf("now I am at event %i \n",i);
	}
	printf("I just produced %i events \n",i);
      }
      else if (strstr(what2do,"ins")){
	sscanf(what2do,"%s %i1",what1,&i1);
	ddu_start();
	for ( i=0; i<i1 && ! error ; i++){
	  len = 1000;
	  if (i%100 == 0)
	    len = 6000;
	  status = ddu_req_fev(len, &fev);
	  if (status == 0){
	    p = fev.p2da;
	    for (j=0;j<len;j++)
	      *p++ = j;
	    fev.len = len;
	    fev.ctlw1 = i%4+1;
	    fev.ctlb1 = 0;
	    fev.ctlw2 = 0;
	    fev.ctlb2 = 0;
	    if ( ( status = ddu_ins_fev(fev) ) < 0) {
	      printf("ddu_ins_fev: status returned %d \n",status);		  
	      error = TRUE;
	    }
	  }
	  else {
	    printf("ddu_ireq_fev: status returned %d \n",status);		  
	    error = TRUE;
	  }
	  if ( i%10000 == 0 )
	    printf("now I am at event %i \n",i);
	}
	ddu_stop();
	printf("I just inserted %i events \n",i);
      }
      else if (strstr(what2do,"bro")){
	len = 100;
	status = ddu_req_fev(len, &fev);
	if (status == 0){
	  printf("enter brc fev [w1,b1,w2,b2]\n");
	  scanf("%d %d %d %d", &fev.ctlw1, &fev.ctlb1, &fev.ctlw2, &fev.ctlb2);
	  printf("broadcasting %d %d %d %d\n", fev.ctlw1, fev.ctlb1, fev.ctlw2, fev.ctlb2);
	  p = fev.p2da;
	  fev.len = len;
	  for (j=0;j<len;j++)
	    *p++ = j+0x0f0f;
	  ddu_brc_fev(fev,1000);
	}
	printf("Finished broadcast \n");
      }
      else if (strstr(what2do,"dum")){
	dump = (!dump);
	printf("dump toggle is %i \n",dump);
      }
      else if ( strstr(what2do,"hel") ){
	printf("\n HELP for dd_test \n");
	printf("press get 'i1' ...... to consume i1 events\n");
	printf("      put 'i1' ...... to produce i1 events\n");
	printf("      ins 'i1' ...... to ins i1 events\n");
	printf("      bro ........... to broadcast an events\n");
	printf("      dum ........... to toggle dump\n");
      }
      else{
	printf(".... I don't know this command %s \n",what2do);
	fflush(stdout);
      }
    }
    else
      printf("no longer attached to the DD system\n");
  }
  if ( ddu_attached() )
    ddu_close();
  
  return;
}
       


