#ifndef DB_H
#define DB_H

/*
 * db.h     :  Header file for the general data buffer db.
 * Author   :  C.Witzig
 * Date     :  Apr 2, 1992 
 * Mods     :
 */


/*
 * DB_MAXNBEV    : Maximum number of events in the db (must be 
 *                 smaller that FIFO_DEPTH, as we want to be able
 *                 to allocate additional events which are too big for db.
 * DB_MAXEVSIZE  : Maxiumum event size within db.
 * PAGE_SIZE     : We allocate shared memory is multiples of 512 bytes.
 * DB_MAX_BUF_VOL: Max. number of volatile buffers allocated on the fly...
 *
 * ATTENTION     : All sizes are in LONGWORDS (i.e. 32 bits)
 *               : BUT: do NEVER EVER use arithmetic expressions with 
 *               : define statements !!!
 */

#define DB_SHM_KEY 6

#define DB_MAXNBEV_MAX 60
#define DB_MAXEVSIZE_MAX 12000
#define DB_MAX_BUF_VOL_MAX 4

#define PAGE_SIZE 128


/*
 * and the externals...
 */
extern int db_shmid;
extern int *db_ptr_shm;       
extern int *db_shm_end;
extern int db_maxevsize, db_maxnbev;

extern int db_init(char *filename, int nbuffers, int maxsize);
extern int db_close(int destroy);
extern int db_getmem(int *size, int *shmid);
extern int db_attmem(int shmid, int **ptr2ptr);
extern int db_detmem(int *ptr2shm);
extern int db_freemem(int shmid);
extern int db_set_shmuid(int shmid, uid_t new_uid);


#endif




