/*----------------------------------------------------------------------------*
 *  Copyright (c) 1991, 1992  Southeastern Universities Research Association, *
 *                            Continuous Electron Beam Accelerator Facility   *
 *                                                                            *
 *    This software was developed under a United States Government license    *
 *    described in the NOTICE file included as part of this distribution.     *
 *                                                                            *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606 *
 *      heyes@cebaf.gov   Tel: (804) 249-7030    Fax: (804) 249-7363          *
 *----------------------------------------------------------------------------*
 * Discription: follows this header.
 *
 * Author:
 *	Graham Heyes
 *	CEBAF Data Acquisition Group
 *
 * Revision History:
 *      $Log: main_roc.c,v $
 *      Revision 2.4  1998/05/27 13:45:07  heyes
 *      add message Q to ROC, improve EB stability on EBD transition
 *
 *      Revision 2.2  1997/04/25 18:57:24  abbottd
 *      added additional arguments for VXWORKS
 *
 *      Revision 2.1  1996/10/29 19:13:45  abbottd
 *      VxWorks support modifications
 *
 *      Revision 2.0  1996/09/06 18:09:56  abbottd
 *      VxWorks support for up to 6 arguments
 *
 *      Revision 1.3  1996/08/28 16:36:56  heyes
 *      initial
 *
 *      Revision 1.1.1.1  1996/08/21 19:18:55  heyes
 *      Imported sources
 *
*	  Revision 1.1  94/05/04  13:22:39  13:22:39  heyes (Graham Heyes)
*	  Initial revision
*
*	  Revision 1.1  94/03/15  11:53:22  11:53:22  heyes (Graham Heyes)
*	  Initial revision
*
*	  Revision 1.1  93/10/27  08:47:50  08:47:50  heyes (Graham Heyes)
*	  Initial revision
*
 *	  Revision 1.8  1993/04/29  14:31:27  heyes
 *	  fix alpha test bugs
 *
 *	  Revision 1.7  1993/03/16  13:40:46  heyes
 *	  reinsert for coda 1.2
 *
 *	  Revision 1.6  1992/08/14  15:38:27  heyes
 *	  1.1.2 release
 *
 *	  Revision 1.5  1992/08/10  19:51:32  heyes
 *	  test
 *
 *	  Revision 1.4  1992/08/03  12:49:08  heyes
 *	  record numbering added
 *
 *	  Revision 1.3  1992/07/31  17:02:10  heyes
 *	  -
 *
 *	  Revision 1.2  1992/07/31  16:54:41  heyes
 *	  logo
 *
 *	  Revision 1.1  1992/06/25  18:17:15  heyes
 *	  Initial revision
 *
 *
 *----------------------------------------------------------------------------*/

#ifdef VXWORKS
void
coda_roc (char *arg1, char *arg2, char *arg3, char *arg4, char *arg5, char *arg6, char *arg7)
{
	int            argc = 1;
	char           *argv[8];

	/* Copy arguments into argv array */

	argv[0] = "coda_roc";
	if(arg1) {
	  argv[1] = arg1;
	  argc++;
	}
	if(arg2) {
	  argv[2] = arg2;
	  argc++;
	}
	if(arg3) {
	  argv[3] = arg3;
	  argc++;
	}
	if(arg4) {
	  argv[4] = arg4;
	  argc++;
	}
	if(arg5) {
	  argv[5] = arg5;
	  argc++;
	}
	if(arg6) {
	  argv[6] = arg6;
	  argc++;
	}
	if(arg7) {
	  argv[7] = arg7;
	  argc++;
	}
	
	if (argc < 5) {
	  printf (" Wrong number of arguments (must be >= 5) argc = %d\n",argc);
	}else if (argc == 5) { 
	  printf (" Args = %s %s %s %s \n", argv[1], argv[2], argv[3], argv[4]);
	} else if (argc == 6) {
	  printf (" Args = %s %s %s %s %s\n", argv[1], argv[2], argv[3], argv[4], argv[5]);
	} else if (argc == 7){
	  printf (" Args = %s %s %s %s %s %s\n", argv[1], argv[2], argv[3], argv[4], argv[5], argv[6]);
	} else {
	  printf (" Args = %s %s %s %s %s %s %s\n", 
		  argv[1], argv[2], argv[3], argv[4], argv[5], argv[6], argv[7]);
	}
#else

void
main (int argc, char **argv)
{
#endif


	CODA_Init (argc, argv);
	/* CODA_Service ("ROC"); */
	CODA_Execute ();
}
