#!/usr/bin/perl -w

#  codadb2xml.pl

#  dumps coda config into xml

#  still to do:
#       non-existing config?


#  E.Wolin, Jefferson Lab, 9-sep-2003



use DBI;
    

#  Perl code:
#  ----------

#  defaults
$dbtype   = "mSQL";
$account  = undef;
$password = undef;
$all      = 0;
$list     = 0;
$split    = 0;
$help     = "\n  Usage:\n         codadb2xml [-list] [-all] [-split]".
    " [-t dbtype] [-a account] [-p password] dbname [config1 config2...]\n\n";


# decode command line args
$line=join(" ",@ARGV);
if($line =~ s/-h//i) { die $help;}
($all      =   1) if ($line =~ s/-all\s+//i);
($split    =   1) if ($line =~ s/-split\s+//i);
($list     =   1) if ($line =~ s/-list\s+//i);
($dbtype   =  $1) if ($line =~ s/-t\s+(\S+)//i);
($account  =  $1) if ($line =~ s/-a\s+(\S+)//i);
($password =  $1) if ($line =~ s/-p\s+(\S+)//i);
if($list!=0) {$all=1;}


#  connect to db
($dbname=$1) if ($line=~s/^\s*(\S+)//);
if(($list==0) && (!defined $dbname || ($dbname=~/^\s*$/))) {die $help;}
($conn=DBI->connect("DBI:$dbtype:dbname=$dbname;",$account,$password,
		    {RaiseError=>1,AutoCommit=>1})) 
    || die "Failed to connect to database $dbname\n";


#  get config names
if($all==0) {
    $confignames=$line;
} else  {
    $confignames="";
    $h=$conn->prepare("select name from runTypes");
    $h->execute;
    while (@row=$h->fetchrow_array) {
	$confignames.=$row[0]." ";
    }
}


#  list config names only?
if($list!=0) {
    print "$confignames\n";
    $conn->disconnect;
    exit;
}
if($confignames=~/^\s*$/) {die $help;}



#  dump config tables for each config
if($split==0) {print "<codadb>\n\n\n";}
foreach $config (split(" ",$confignames)) {
    if($split==0) {
	open(OUT,">-");
    } else {
	open(OUT,">${config}.cfg");
	print OUT "<codadb>\n\n\n";
    }
    print OUT "<!-- =============== Begin Configuration $config =============== -->\n\n";
    print OUT "<config name=\"$config\">\n\n";
    &dump_config;
    print OUT "\n</config>\n\n\n";
    if($split!=0) {print OUT "</codadb>\n\n\n";}
    close(OUT);
}
if($split==0) {print "\n</codadb>\n\n";}


#  done
$conn->disconnect;
exit;


#-------------------------------------------------------------------------


sub dump_config {


    # get component types
    $h=$conn->prepare("select name,type from process");
    $h->execute;
    while (@row=$h->fetchrow_array) {
	$types{$row[0]}=$row[1];
    }



    $h=$conn->prepare("select name,code,inputs,outputs,first,next from $config");
    $h->execute;
    while (@row=$h->fetchrow_array) {
	for($i=0; $i<6; $i++) {$row[$i]=~s/^\s+//;$row[$i]=~s/\s+$//;}
	$type=(defined $types{$row[0]})?$types{$row[0]}:"";
	print OUT 
	    "<component\n".
	    "    name    = \"$row[0]\"\n".
	    "    type    = \"$type\"\n".
	    "    code    = \"$row[1]\"\n".
	    "    inputs  = \"$row[2]\"\n".
	    "    outputs = \"$row[3]\"\n".
	    "    first   = \"$row[4]\"\n".
	    "    next    = \"$row[5]\" />\n\n";
    }

    print OUT "\n\n";
    $h=$conn->prepare("select name,row,col from ${config}_pos");
    $h->execute;
    while (@row=$h->fetchrow_array) {
	for($i=0; $i<3; $i++) {$row[$i]=~s/^\s+//;$row[$i]=~s/\s+$//;}
	printf OUT "<pos name = %12s   row = %5s   col = %5s />\n",
	       "\"".$row[0]."\"","\"".$row[1]."\"","\"".$row[2]."\"";
    }

    print OUT "\n\n";
    $h=$conn->prepare("select name,state,script from ${config}_script");
    $h->execute;
    while (@row=$h->fetchrow_array) {
	for($i=0; $i<3; $i++) {$row[$i]=~s/^\s+//;$row[$i]=~s/\s+$//;}
	printf OUT "<script name = %12s   state = \"%s\"   script = \"%s\" />\n",
	       "\"".$row[0]."\"",$row[1],$row[2];
    }

    print OUT "\n\n";
    $h=$conn->prepare("select name,value from ${config}_option");
    $h->execute;
    while (@row=$h->fetchrow_array) {
	for($i=0; $i<2; $i++) {$row[$i]=~s/^\s+//;$row[$i]=~s/\s+$//;}
	printf OUT "<option name = %20s   value = \"%s\" />\n","\"".$row[0]."\"",$row[1];
    }

}


#-------------------------------------------------------------------------
