/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import java.io.DataInputStream;
import java.io.IOException;

public class StationData {
    int num;
    int status;
    int mutex;
    int attachments;
    int[] attIds = new int[110];
    int inListMutex;
    int inListCount;
    long inListTry;
    long inListIn;
    int outListMutex;
    int outListCount;
    long outListOut;
    int flowMode;
    int userMode;
    int restoreMode;
    int blockMode;
    int prescale;
    int cue;
    int selectMode;
    int[] select = new int[4];
    String selectFunction;
    String selectLibrary;
    String selectClass;
    String name;

    public int getId() {
        return this.num;
    }

    public int getStatus() {
        return this.status;
    }

    public int getMutex() {
        return this.mutex;
    }

    public int getAttachments() {
        return this.attachments;
    }

    public int[] getAttachmentIds() {
        return (int[])this.attIds.clone();
    }

    public int getInListMutex() {
        return this.inListMutex;
    }

    public int getInListCount() {
        return this.inListCount;
    }

    public long getInListTry() {
        return this.inListTry;
    }

    public long getInListIn() {
        return this.inListIn;
    }

    public int getOutListMutex() {
        return this.outListMutex;
    }

    public int getOutListCount() {
        return this.outListCount;
    }

    public long getOutListOut() {
        return this.outListOut;
    }

    public int getFlowMode() {
        return this.flowMode;
    }

    public int getUserMode() {
        return this.userMode;
    }

    public int getRestoreMode() {
        return this.restoreMode;
    }

    public int getBlockMode() {
        return this.blockMode;
    }

    public int getPrescale() {
        return this.prescale;
    }

    public int getCue() {
        return this.cue;
    }

    public int getSelectMode() {
        return this.selectMode;
    }

    public int[] getSelect() {
        return (int[])this.select.clone();
    }

    public String getSelectFunction() {
        return this.selectFunction;
    }

    public String getSelectLibrary() {
        return this.selectLibrary;
    }

    public String getSelectClass() {
        return this.selectClass;
    }

    public String getName() {
        return this.name;
    }

    void read(DataInputStream dataInputStream) throws IOException {
        this.attachments = dataInputStream.readInt();
        this.num = dataInputStream.readInt();
        this.status = dataInputStream.readInt();
        this.mutex = dataInputStream.readInt();
        int n = 0;
        while (n < this.attachments) {
            this.attIds[n] = dataInputStream.readInt();
            ++n;
        }
        this.inListMutex = dataInputStream.readInt();
        this.inListCount = dataInputStream.readInt();
        this.inListTry = dataInputStream.readLong();
        this.inListIn = dataInputStream.readLong();
        this.outListMutex = dataInputStream.readInt();
        this.outListCount = dataInputStream.readInt();
        this.outListOut = dataInputStream.readLong();
        this.flowMode = dataInputStream.readInt();
        this.userMode = dataInputStream.readInt();
        this.restoreMode = dataInputStream.readInt();
        this.blockMode = dataInputStream.readInt();
        this.prescale = dataInputStream.readInt();
        this.cue = dataInputStream.readInt();
        this.selectMode = dataInputStream.readInt();
        int n2 = 0;
        while (n2 < 4) {
            this.select[n2] = dataInputStream.readInt();
            ++n2;
        }
        int n3 = dataInputStream.readInt();
        int n4 = dataInputStream.readInt();
        int n5 = dataInputStream.readInt();
        int n6 = dataInputStream.readInt();
        int n7 = n3 + n4 + n5 + n6;
        byte[] byArray = new byte[n7];
        dataInputStream.readFully(byArray, 0, n7);
        int n8 = 0;
        if (n3 > 0) {
            this.selectFunction = new String(byArray, n8, n3 - 1, "ASCII");
            n8 += n3;
        }
        if (n4 > 0) {
            this.selectLibrary = new String(byArray, n8, n4 - 1, "ASCII");
            n8 += n4;
        }
        if (n5 > 0) {
            this.selectClass = new String(byArray, n8, n5 - 1, "ASCII");
            n8 += n5;
        }
        if (n6 > 0) {
            this.name = new String(byArray, n8, n6 - 1, "ASCII");
        }
    }
}

