/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import java.io.Serializable;
import java.util.Arrays;
import org.jlab.coda.et.EtException;

public class StationConfig
implements Serializable {
    int cue;
    int prescale;
    int flowMode;
    int userMode;
    int restoreMode;
    int blockMode;
    int selectMode;
    int[] select;
    String selectFunction;
    String selectLibrary;
    String selectClass;

    public StationConfig() {
        this.cue = 10;
        this.prescale = 1;
        this.flowMode = 0;
        this.userMode = 0;
        this.restoreMode = 0;
        this.blockMode = 1;
        this.selectMode = 1;
        this.select = new int[4];
        Arrays.fill(this.select, -1);
    }

    public StationConfig(StationConfig stationConfig) {
        this.cue = stationConfig.cue;
        this.prescale = stationConfig.prescale;
        this.flowMode = stationConfig.flowMode;
        this.userMode = stationConfig.userMode;
        this.restoreMode = stationConfig.restoreMode;
        this.blockMode = stationConfig.blockMode;
        this.selectMode = stationConfig.selectMode;
        this.select = (int[])stationConfig.select.clone();
        this.selectFunction = stationConfig.selectFunction;
        this.selectLibrary = stationConfig.selectLibrary;
        this.selectClass = stationConfig.selectClass;
    }

    public static boolean compatibleParallelConfigs(StationConfig stationConfig, StationConfig stationConfig2) {
        if (stationConfig.flowMode != 1 || stationConfig2.flowMode != 1) {
            return false;
        }
        if (stationConfig.selectMode == 4 && stationConfig2.selectMode != 4 || stationConfig.selectMode == 5 && stationConfig2.selectMode != 5) {
            return false;
        }
        if (!(stationConfig.selectMode != 4 && stationConfig.selectMode != 5 || stationConfig.blockMode == stationConfig2.blockMode && stationConfig.prescale == stationConfig2.prescale)) {
            return false;
        }
        return stationConfig.selectMode == 4 || stationConfig.selectMode == 5 || stationConfig2.selectMode != 4 && stationConfig2.selectMode != 5;
    }

    public int getCue() {
        return this.cue;
    }

    public int getPrescale() {
        return this.prescale;
    }

    public int getFlowMode() {
        return this.flowMode;
    }

    public int getUserMode() {
        return this.userMode;
    }

    public int getRestoreMode() {
        return this.restoreMode;
    }

    public int getBlockMode() {
        return this.blockMode;
    }

    public int getSelectMode() {
        return this.selectMode;
    }

    public int[] getSelect() {
        return (int[])this.select.clone();
    }

    public String getSelectFunction() {
        return this.selectFunction;
    }

    public String getSelectLibrary() {
        return this.selectLibrary;
    }

    public String getSelectClass() {
        return this.selectClass;
    }

    public void setCue(int n) throws EtException {
        if (n < 1) {
            throw new EtException("bad cue value");
        }
        this.cue = n;
    }

    public void setPrescale(int n) throws EtException {
        if (n < 1) {
            throw new EtException("bad prescale value");
        }
        this.prescale = n;
    }

    public void setFlowMode(int n) throws EtException {
        if (n != 0 && n != 1) {
            throw new EtException("bad flow mode value");
        }
        this.flowMode = n;
    }

    public void setUserMode(int n) throws EtException {
        if (n < 0) {
            throw new EtException("bad user mode value");
        }
        this.userMode = n;
    }

    public void setRestoreMode(int n) throws EtException {
        if (n != 0 && n != 1 && n != 2) {
            throw new EtException("bad restore mode value");
        }
        this.restoreMode = n;
    }

    public void setBlockMode(int n) throws EtException {
        if (n != 1 && n != 0) {
            throw new EtException("bad block mode value");
        }
        this.blockMode = n;
    }

    public void setSelectMode(int n) throws EtException {
        if (n != 1 && n != 2 && n != 3 && n != 4 && n != 5) {
            throw new EtException("bad select mode value");
        }
        this.selectMode = n;
    }

    public void setSelect(int[] nArray) throws EtException {
        if (nArray.length != 4) {
            throw new EtException("wrong number of elements in select array");
        }
        this.select = (int[])nArray.clone();
    }

    public void setSelectFunction(String string) {
        this.selectFunction = string;
    }

    public void setSelectLibrary(String string) {
        this.selectLibrary = string;
    }

    public void setSelectClass(String string) {
        this.selectClass = string;
    }
}

