/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.jlab.coda.et.EtException;
import org.jlab.coda.et.SystemUse;

public class Station {
    int id;
    boolean usable;
    String name;
    SystemUse sys;

    Station(String string, int n, SystemUse systemUse) {
        this.id = n;
        this.name = string;
        this.sys = systemUse;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public boolean usable() {
        return this.usable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getSelectWords() throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        int n = -1;
        int[] nArray = new int[4];
        SystemUse systemUse = this.sys;
        synchronized (systemUse) {
            this.sys.out.writeInt(83);
            this.sys.out.writeInt(this.id);
            this.sys.out.flush();
            n = this.sys.in.readInt();
            if (n == 0) {
                int n2 = 0;
                while (n2 < nArray.length) {
                    nArray[n2] = this.sys.in.readInt();
                    ++n2;
                }
            }
        }
        if (n != 0) {
            throw new EtException("cannot find station");
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectWords(int[] nArray) throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        if (this.id == 0) {
            throw new EtException("cannot modify GRAND_CENTRAL station");
        }
        int n = -1;
        if (nArray.length != 4) {
            throw new EtException("wrong number of elements in select array");
        }
        SystemUse systemUse = this.sys;
        synchronized (systemUse) {
            this.sys.out.writeInt(82);
            this.sys.out.writeInt(this.id);
            int n2 = 0;
            while (n2 < nArray.length) {
                this.sys.out.writeInt(nArray[n2]);
                ++n2;
            }
            this.sys.out.flush();
            n = this.sys.in.readInt();
        }
        if (n != 0) {
            throw new EtException("this station has been removed from ET system");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringValue(int n) throws IOException, EtException {
        byte[] byArray = null;
        String string = null;
        int n2 = -1;
        int n3 = 0;
        SystemUse systemUse = this.sys;
        synchronized (systemUse) {
            this.sys.out.writeInt(n);
            this.sys.out.writeInt(this.id);
            this.sys.out.flush();
            n2 = this.sys.in.readInt();
            n3 = this.sys.in.readInt();
            if (n2 == 0) {
                byArray = new byte[n3];
                this.sys.in.readFully(byArray, 0, n3);
            }
        }
        if (n2 == 0) {
            try {
                string = new String(byArray, 0, n3 - 1, "ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            if (n3 == 0) {
                return null;
            }
            throw new EtException("cannot find station");
        }
        return string;
    }

    public String getSelectLibrary() throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        return this.getStringValue(84);
    }

    public String getSelectFunction() throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        return this.getStringValue(85);
    }

    public String getSelectClass() throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        return this.getStringValue(86);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getIntValue(int n) throws IOException, EtException {
        int n2 = -1;
        int n3 = 0;
        SystemUse systemUse = this.sys;
        synchronized (systemUse) {
            this.sys.out.writeInt(n);
            this.sys.out.writeInt(this.id);
            this.sys.out.flush();
            n2 = this.sys.in.readInt();
            n3 = this.sys.in.readInt();
        }
        if (n2 != 0) {
            throw new EtException("this station has been removed from ET system");
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIntValue(int n, int n2) throws IOException, EtException {
        int n3 = -1;
        SystemUse systemUse = this.sys;
        synchronized (systemUse) {
            this.sys.out.writeInt(n);
            this.sys.out.writeInt(this.id);
            this.sys.out.writeInt(n2);
            this.sys.out.flush();
            n3 = this.sys.in.readInt();
        }
        if (n3 != 0) {
            throw new EtException("this station has been removed from ET system");
        }
    }

    public int getNumAttachments() throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        return this.getIntValue(100);
    }

    public int getStatus() throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        return this.getIntValue(101);
    }

    public int getInputCount() throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        return this.getIntValue(102);
    }

    public int getOutputCount() throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        return this.getIntValue(103);
    }

    public int getBlockMode() throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        return this.getIntValue(104);
    }

    public void setBlockMode(int n) throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        if (this.id == 0) {
            throw new EtException("cannot modify GRAND_CENTRAL station");
        }
        if (n != 1 && n != 0) {
            throw new EtException("bad block mode value");
        }
        this.setIntValue(115, n);
    }

    public int getUserMode() throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        return this.getIntValue(105);
    }

    public void setUserMode(int n) throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        if (this.id == 0) {
            throw new EtException("cannot modify GRAND_CENTRAL station");
        }
        if (n < 0) {
            throw new EtException("bad user mode value");
        }
        this.setIntValue(116, n);
    }

    public int getRestoreMode() throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        return this.getIntValue(106);
    }

    public void setRestoreMode(int n) throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        if (this.id == 0) {
            throw new EtException("cannot modify GRAND_CENTRAL station");
        }
        if (n != 0 && n != 1 && n != 2) {
            throw new EtException("bad restore mode value");
        }
        this.setIntValue(117, n);
    }

    public int getSelectMode() throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        return this.getIntValue(109);
    }

    public int getCue() throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        return this.getIntValue(108);
    }

    public void setCue(int n) throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        if (this.id == 0) {
            throw new EtException("cannot modify GRAND_CENTRAL station");
        }
        if (n < 1) {
            throw new EtException("bad cue value");
        }
        this.setIntValue(119, n);
    }

    public int getPrescale() throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        return this.getIntValue(107);
    }

    public void setPrescale(int n) throws IOException, EtException {
        if (!this.usable) {
            throw new EtException("station has been removed");
        }
        if (this.id == 0) {
            throw new EtException("cannot modify GRAND_CENTRAL station");
        }
        if (n < 1) {
            throw new EtException("bad prescale value");
        }
        this.setIntValue(118, n);
    }
}

