/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.jlab.coda.et.AllData;
import org.jlab.coda.et.Attachment;
import org.jlab.coda.et.AttachmentData;
import org.jlab.coda.et.EtBusyException;
import org.jlab.coda.et.EtEmptyException;
import org.jlab.coda.et.EtException;
import org.jlab.coda.et.EtExistsException;
import org.jlab.coda.et.EtTimeoutException;
import org.jlab.coda.et.EtTooManyException;
import org.jlab.coda.et.EtWakeUpException;
import org.jlab.coda.et.Event;
import org.jlab.coda.et.ProcessData;
import org.jlab.coda.et.Station;
import org.jlab.coda.et.StationConfig;
import org.jlab.coda.et.StationData;
import org.jlab.coda.et.SystemOpen;
import org.jlab.coda.et.SystemOpenConfig;

/*
 * Exception performing whole class analysis ignored.
 */
public class SystemUse {
    private SystemOpenConfig openConfig;
    private SystemOpen sys;
    private boolean open;
    private int debug;
    private Socket sock;
    private InputStream sockIn;
    private OutputStream sockOut;
    private boolean isJava;
    DataInputStream in;
    DataOutputStream out;

    public SystemUse(SystemOpenConfig systemOpenConfig, int n) throws IOException, UnknownHostException, EtException, EtTooManyException {
        this.openConfig = new SystemOpenConfig(systemOpenConfig);
        this.sys = new SystemOpen(this.openConfig);
        this.debug = n != 0 && n != 1 && n != 2 && n != 3 && n != 4 ? 2 : n;
        this.sys.debug = this.debug;
        this.open();
    }

    public SystemUse(SystemOpenConfig systemOpenConfig) throws IOException, UnknownHostException, EtException, EtTooManyException {
        this.openConfig = new SystemOpenConfig(systemOpenConfig);
        this.sys = new SystemOpen(this.openConfig);
        this.sys.debug = this.debug = 2;
        this.open();
    }

    public SystemUse(SystemOpen systemOpen, int n) throws IOException, UnknownHostException, EtException, EtTooManyException {
        this.sys = systemOpen;
        this.openConfig = this.sys.getConfig();
        this.debug = n != 0 && n != 1 && n != 2 && n != 3 && n != 4 ? 2 : n;
        if (this.sys.isConnected()) {
            if (this.sys.getLanguage() == 2) {
                this.isJava = true;
            }
            this.sock = this.sys.getSocket();
            this.sockIn = this.sock.getInputStream();
            this.sockOut = this.sock.getOutputStream();
            this.in = new DataInputStream(new BufferedInputStream(this.sock.getInputStream(), 65535));
            this.out = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream(), 65535));
            this.open = true;
        } else {
            this.open();
        }
    }

    private static final int bytesToInt(byte[] byArray, int n) {
        int n2 = (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
        return n2;
    }

    private static final void intToBytes(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)((n & 0xFF000000) >>> 24);
        byArray[n2 + 1] = (byte)((n & 0xFF0000) >>> 16);
        byArray[n2 + 2] = (byte)((n & 0xFF00) >>> 8);
        byArray[n2 + 3] = (byte)(n & 0xFF);
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void open() throws IOException, UnknownHostException, EtException, EtTooManyException {
        block4: {
            block5: {
                try {
                    this.sys.connect();
                    break block4;
                }
                catch (EtTooManyException var1_1) {
                    if (this.debug < 2) break block5;
                    System.out.println("The following hosts responded:");
                    var2_2 = 0;
                    ** while (var2_2 < this.sys.respondingHosts.size())
                }
lbl-1000:
                // 1 sources

                {
                    System.out.println("  " + (String)this.sys.respondingHosts.get(var2_2) + " at port " + (Integer)this.sys.respondingPorts.get(var2_2));
                    ++var2_2;
                    continue;
                }
            }
            throw var1_1;
        }
        if (this.sys.language == 2) {
            this.isJava = true;
        }
        this.sock = this.sys.sock;
        this.sockIn = this.sock.getInputStream();
        this.sockOut = this.sock.getOutputStream();
        this.in = new DataInputStream(new BufferedInputStream(this.sock.getInputStream(), 65535));
        this.out = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream(), 65535));
        this.open = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void close() {
        block9: {
            this.out.writeInt(42);
            this.out.flush();
            this.in.readInt();
            Object var3_1 = null;
            try {
                this.in.close();
                this.out.close();
                this.sock.close();
            }
            catch (IOException iOException) {}
            break block9;
            {
                catch (IOException iOException) {
                    if (this.debug >= 2) {
                        System.out.println("network communication error");
                    }
                    Object var3_2 = null;
                    try {
                        this.in.close();
                        this.out.close();
                        this.sock.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    this.in.close();
                    this.out.close();
                    this.sock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        this.open = false;
    }

    public synchronized boolean alive() {
        int n;
        try {
            this.out.writeInt(40);
            this.out.flush();
            n = this.in.readInt();
        }
        catch (IOException iOException) {
            if (this.debug >= 2) {
                System.out.println("network communication error");
            }
            return false;
        }
        return n == 1;
    }

    public synchronized void wakeUpAttachment(Attachment attachment) throws IOException, EtException {
        if (!attachment.usable || attachment.sys != this) {
            throw new EtException("Invalid attachment");
        }
        this.out.writeInt(44);
        this.out.writeInt(attachment.id);
        this.out.flush();
    }

    public synchronized void wakeUpAll(Station station) throws IOException, EtException {
        if (!station.usable || station.sys != this) {
            throw new EtException("Invalid station");
        }
        this.out.writeInt(45);
        this.out.writeInt(station.id);
        this.out.flush();
    }

    private void configCheck(StationConfig stationConfig) throws EtException {
        if (stationConfig.selectMode == 3 && stationConfig.selectClass == null) {
            throw new EtException("station config needs a select class name");
        }
        if (!(stationConfig.selectMode != 4 && stationConfig.selectMode != 5 || stationConfig.flowMode != 0 && stationConfig.blockMode != 0 && stationConfig.restoreMode != 1 && stationConfig.prescale == 1)) {
            throw new EtException("if flowMode = rrobin/equalcue, station must be parallel, nonBlocking, prescale=1, & not restoreIn\n");
        }
        if (stationConfig.cue > this.sys.numEvents) {
            throw new EtException("station configuraton cue size must be < max-#-of-events");
        }
    }

    public Station createStation(StationConfig stationConfig, String string) throws IOException, EtException, EtExistsException, EtTooManyException {
        return this.createStation(stationConfig, string, -1, -1);
    }

    public Station createStation(StationConfig stationConfig, String string, int n) throws IOException, EtException, EtExistsException, EtTooManyException {
        return this.createStation(stationConfig, string, n, -1);
    }

    public synchronized Station createStation(StationConfig stationConfig, String string, int n, int n2) throws IOException, EtException, EtExistsException, EtTooManyException {
        if (string.equals("GRAND_CENTRAL")) {
            throw new EtException("Cannot create GRAND_CENTRAL station");
        }
        if (n != -1 && n < 1) {
            throw new EtException("bad value for position");
        }
        if (n2 != -1 && n2 != -2 && n2 < 0) {
            throw new EtException("bad value for parallel position");
        }
        this.configCheck(stationConfig);
        this.out.writeInt(62);
        this.out.writeInt(1);
        this.out.writeInt(stationConfig.flowMode);
        this.out.writeInt(stationConfig.userMode);
        this.out.writeInt(stationConfig.restoreMode);
        this.out.writeInt(stationConfig.blockMode);
        this.out.writeInt(stationConfig.prescale);
        this.out.writeInt(stationConfig.cue);
        this.out.writeInt(stationConfig.selectMode);
        int n3 = 0;
        while (n3 < 4) {
            this.out.writeInt(stationConfig.select[n3]);
            ++n3;
        }
        int n4 = 0;
        if (stationConfig.selectFunction != null) {
            n4 = stationConfig.selectFunction.length() + 1;
        }
        this.out.writeInt(n4);
        int n5 = 0;
        if (stationConfig.selectLibrary != null) {
            n5 = stationConfig.selectLibrary.length() + 1;
        }
        this.out.writeInt(n5);
        int n6 = 0;
        if (stationConfig.selectClass != null) {
            n6 = stationConfig.selectClass.length() + 1;
        }
        this.out.writeInt(n6);
        int n7 = string.length() + 1;
        this.out.writeInt(n7);
        this.out.writeInt(n);
        this.out.writeInt(n2);
        try {
            if (n4 > 0) {
                this.out.write(stationConfig.selectFunction.getBytes("ASCII"));
                this.out.writeByte(0);
            }
            if (n5 > 0) {
                this.out.write(stationConfig.selectLibrary.getBytes("ASCII"));
                this.out.writeByte(0);
            }
            if (n6 > 0) {
                this.out.write(stationConfig.selectClass.getBytes("ASCII"));
                this.out.writeByte(0);
            }
            this.out.write(string.getBytes("ASCII"));
            this.out.writeByte(0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.out.flush();
        int n8 = this.in.readInt();
        int n9 = this.in.readInt();
        if (n8 == -2) {
            throw new EtTooManyException("maximum number of stations already created");
        }
        if (n8 == -3) {
            throw new EtExistsException("station already exists with different definition");
        }
        if (n8 == -1) {
            throw new EtException("trying to add incompatible parallel station, or\ntrying to add parallel station to head of existing parallel group, or\ncannot load select class");
        }
        Station station = new Station(string, n9, this);
        station.usable = true;
        if (this.debug >= 4) {
            System.out.println("creating station " + string + " is done");
        }
        return station;
    }

    public synchronized void removeStation(Station station) throws IOException, EtException {
        if (station.id == 0) {
            throw new EtException("Cannot remove GRAND_CENTRAL station");
        }
        if (!station.usable || station.sys != this) {
            throw new EtException("Invalid station");
        }
        this.out.writeInt(63);
        this.out.writeInt(station.id);
        this.out.flush();
        int n = this.in.readInt();
        if (n == -1) {
            throw new EtException("Either no such station exists or remove all attachments before removing station");
        }
        station.usable = false;
    }

    public synchronized void setStationPosition(Station station, int n, int n2) throws IOException, EtException {
        if (station.id == 0) {
            throw new EtException("Cannot move GRAND_CENTRAL station");
        }
        if (n != -1 && n < 0) {
            throw new EtException("bad value for position");
        }
        if (n == 0) {
            throw new EtException("GRAND_CENTRAL station is always first");
        }
        if (n2 != -1 && n2 != -2 && n2 < 0) {
            throw new EtException("bad value for parallelPosition");
        }
        if (!station.usable || station.sys != this) {
            throw new EtException("Invalid station");
        }
        this.out.writeInt(64);
        this.out.writeInt(station.id);
        this.out.writeInt(n);
        this.out.writeInt(n2);
        this.out.flush();
        int n3 = this.in.readInt();
        if (n3 == -1) {
            station.usable = false;
            throw new EtException("station does not exist");
        }
    }

    public synchronized int getStationPosition(Station station) throws IOException, EtException {
        if (station.id == 0) {
            return 0;
        }
        if (!station.usable || station.sys != this) {
            throw new EtException("Invalid station");
        }
        this.out.writeInt(65);
        this.out.writeInt(station.id);
        this.out.flush();
        int n = this.in.readInt();
        int n2 = this.in.readInt();
        int n3 = this.in.readInt();
        if (n == -1) {
            station.usable = false;
            throw new EtException("station does not exist");
        }
        return n2;
    }

    public synchronized int getStationParallelPosition(Station station) throws IOException, EtException {
        if (station.id == 0) {
            return 0;
        }
        if (!station.usable || station.sys != this) {
            throw new EtException("Invalid station");
        }
        this.out.writeInt(65);
        this.out.writeInt(station.id);
        this.out.flush();
        int n = this.in.readInt();
        int n2 = this.in.readInt();
        int n3 = this.in.readInt();
        if (n == -1) {
            station.usable = false;
            throw new EtException("station does not exist");
        }
        return n3;
    }

    public synchronized Attachment attach(Station station) throws IOException, EtException, EtTooManyException {
        if (!station.usable || station.sys != this) {
            throw new EtException("Invalid station");
        }
        String string = "unknown";
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.out.writeInt(60);
        this.out.writeInt(station.id);
        this.out.writeInt(-1);
        this.out.writeInt(string.length() + 1);
        try {
            this.out.write(string.getBytes("ASCII"));
            this.out.writeByte(0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.out.flush();
        int n = this.in.readInt();
        int n2 = this.in.readInt();
        if (n == -1) {
            station.usable = false;
            throw new EtException("station does not exist");
        }
        if (n == -2) {
            throw new EtTooManyException("no more attachments allowed to either station or system");
        }
        Attachment attachment = new Attachment(station, n2, this);
        attachment.usable = true;
        return attachment;
    }

    public synchronized void detach(Attachment attachment) throws IOException, EtException {
        if (!attachment.usable || attachment.sys != this) {
            throw new EtException("Invalid attachment");
        }
        this.out.writeInt(61);
        this.out.writeInt(attachment.id);
        this.out.flush();
        this.in.readInt();
        attachment.usable = false;
    }

    public synchronized boolean stationAttached(Station station, Attachment attachment) throws IOException, EtException {
        if (!station.usable || station.sys != this) {
            throw new EtException("Invalid station");
        }
        if (!attachment.usable || attachment.sys != this) {
            throw new EtException("Invalid attachment");
        }
        this.out.writeInt(80);
        this.out.writeInt(station.id);
        this.out.writeInt(attachment.id);
        this.out.flush();
        int n = this.in.readInt();
        if (n == -1) {
            station.usable = false;
            throw new EtException("station does not exist");
        }
        return n == 1;
    }

    public synchronized boolean stationExists(String string) throws IOException {
        this.out.writeInt(81);
        this.out.writeInt(string.length() + 1);
        try {
            this.out.write(string.getBytes("ASCII"));
            this.out.writeByte(0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.out.flush();
        int n = this.in.readInt();
        int n2 = this.in.readInt();
        return n == 1;
    }

    public synchronized Station stationNameToObject(String string) throws IOException, EtException {
        this.out.writeInt(81);
        this.out.writeInt(string.length() + 1);
        try {
            this.out.write(string.getBytes("ASCII"));
            this.out.writeByte(0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.out.flush();
        int n = this.in.readInt();
        int n2 = this.in.readInt();
        if (n == 1) {
            Station station = new Station(string, n2, this);
            station.usable = true;
            return station;
        }
        throw new EtException("station " + string + " does not exist");
    }

    public synchronized ArrayList newEventsList(Attachment attachment, int n, int n2, int n3, int n4) throws IOException, EtException, EtEmptyException, EtBusyException, EtTimeoutException, EtWakeUpException {
        int n5;
        if (!attachment.usable || attachment.sys != this) {
            throw new EtException("Invalid attachment");
        }
        if (n3 == 0) {
            return new ArrayList(0);
        }
        int n6 = n & 3;
        if (n6 != 0 && n6 != 1 && n6 != 2) {
            throw new EtException("bad mode argument");
        }
        if (n2 < 0 && n6 == 1) {
            throw new EtException("bad microSec argument");
        }
        if (n4 < 1) {
            throw new EtException("bad size argument");
        }
        if (n3 < 0) {
            throw new EtException("bad count argument");
        }
        if (attachment == null) {
            throw new EtException("bad attachment argument");
        }
        int n7 = 0;
        int n8 = 0;
        if (n2 > 0) {
            n7 = n2 / 1000000;
            n8 = (n2 - n7 * 1000000) * 1000;
        }
        byte[] byArray = new byte[28];
        SystemUse.intToBytes((int)25, (byte[])byArray, (int)0);
        SystemUse.intToBytes((int)attachment.id, (byte[])byArray, (int)4);
        SystemUse.intToBytes((int)n, (byte[])byArray, (int)8);
        SystemUse.intToBytes((int)n4, (byte[])byArray, (int)12);
        SystemUse.intToBytes((int)n3, (byte[])byArray, (int)16);
        SystemUse.intToBytes((int)n7, (byte[])byArray, (int)20);
        SystemUse.intToBytes((int)n8, (byte[])byArray, (int)24);
        this.out.write(byArray);
        this.out.flush();
        while (true) {
            try {
                n5 = this.in.readInt();
            }
            catch (InterruptedIOException interruptedIOException) {
                continue;
            }
            break;
        }
        if (n5 < 0) {
            if (this.debug >= -1) {
                System.out.println("error in ET system");
            }
            if (n5 == -1) {
                throw new EtException("bad mode value");
            }
            if (n5 == -7) {
                throw new EtBusyException("input list is busy");
            }
            if (n5 == -6) {
                throw new EtEmptyException("no events in list");
            }
            if (n5 == -4) {
                throw new EtWakeUpException("attachment " + attachment.id + " woken up");
            }
            if (n5 == -5) {
                throw new EtTimeoutException("timed out");
            }
        }
        int n9 = n5;
        ArrayList<Event> arrayList = new ArrayList<Event>(n9);
        byArray = new byte[4 * n9];
        this.in.readFully(byArray, 0, 4 * n9);
        int n10 = -4;
        int n11 = n4 > this.sys.eventSize ? n4 : this.sys.eventSize;
        int n12 = 0;
        while (n12 < n9) {
            Event event = new Event(n4, n11, this.isJava);
            event.id = SystemUse.bytesToInt((byte[])byArray, (int)(n10 += 4));
            event.modify = 4;
            event.owner = attachment.id;
            arrayList.add(event);
            ++n12;
        }
        return arrayList;
    }

    public synchronized Event[] newEvents(Attachment attachment, int n, int n2, int n3, int n4) throws IOException, EtException, EtEmptyException, EtBusyException, EtTimeoutException, EtWakeUpException {
        int n5;
        if (!attachment.usable || attachment.sys != this) {
            throw new EtException("Invalid attachment");
        }
        if (n3 == 0) {
            return new Event[0];
        }
        int n6 = n & 3;
        if (n6 != 0 && n6 != 1 && n6 != 2) {
            throw new EtException("bad mode argument");
        }
        if (n2 < 0 && n6 == 1) {
            throw new EtException("bad microSec argument");
        }
        if (n4 < 1) {
            throw new EtException("bad size argument");
        }
        if (n3 < 0) {
            throw new EtException("bad count argument");
        }
        if (attachment == null) {
            throw new EtException("bad attachment argument");
        }
        int n7 = 0;
        int n8 = 0;
        if (n2 > 0) {
            n7 = n2 / 1000000;
            n8 = (n2 - n7 * 1000000) * 1000;
        }
        byte[] byArray = new byte[28];
        SystemUse.intToBytes((int)25, (byte[])byArray, (int)0);
        SystemUse.intToBytes((int)attachment.id, (byte[])byArray, (int)4);
        SystemUse.intToBytes((int)n, (byte[])byArray, (int)8);
        SystemUse.intToBytes((int)n4, (byte[])byArray, (int)12);
        SystemUse.intToBytes((int)n3, (byte[])byArray, (int)16);
        SystemUse.intToBytes((int)n7, (byte[])byArray, (int)20);
        SystemUse.intToBytes((int)n8, (byte[])byArray, (int)24);
        this.out.write(byArray);
        this.out.flush();
        while (true) {
            try {
                n5 = this.in.readInt();
            }
            catch (InterruptedIOException interruptedIOException) {
                continue;
            }
            break;
        }
        if (n5 < 0) {
            if (this.debug >= -1) {
                System.out.println("error in ET system");
            }
            if (n5 == -1) {
                throw new EtException("bad mode value");
            }
            if (n5 == -7) {
                throw new EtBusyException("input list is busy");
            }
            if (n5 == -6) {
                throw new EtEmptyException("no events in list");
            }
            if (n5 == -4) {
                throw new EtWakeUpException("attachment " + attachment.id + " woken up");
            }
            if (n5 == -5) {
                throw new EtTimeoutException("timed out");
            }
        }
        int n9 = n5;
        Event[] eventArray = new Event[n9];
        byArray = new byte[4 * n9];
        this.in.readFully(byArray, 0, 4 * n9);
        int n10 = -4;
        int n11 = n4 > this.sys.eventSize ? n4 : this.sys.eventSize;
        int n12 = 0;
        while (n12 < n9) {
            eventArray[n12] = new Event(n4, n11, this.isJava);
            eventArray[n12].id = SystemUse.bytesToInt((byte[])byArray, (int)(n10 += 4));
            eventArray[n12].modify = 4;
            eventArray[n12].owner = attachment.id;
            ++n12;
        }
        return eventArray;
    }

    public synchronized ArrayList getEventsList(Attachment attachment, int n, int n2, int n3) throws IOException, EtException, EtEmptyException, EtBusyException, EtTimeoutException, EtWakeUpException {
        int n4;
        if (!attachment.usable || attachment.sys != this) {
            throw new EtException("Invalid attachment");
        }
        if (attachment.station.id == 0) {
            throw new EtException("may not get events from GRAND_CENTRAL");
        }
        if (n3 == 0) {
            return new ArrayList(0);
        }
        int n5 = n & 3;
        if (n5 != 0 && n5 != 1 && n5 != 2) {
            throw new EtException("bad mode argument");
        }
        if (n2 < 0 && n5 == 1) {
            throw new EtException("bad microSec argument");
        }
        if (n3 < 0) {
            throw new EtException("bad count argument");
        }
        if (attachment == null) {
            throw new EtException("bad attachment argument");
        }
        int n6 = n & 4;
        if (n6 == 0) {
            n6 = n & 8;
        }
        int n7 = 0;
        int n8 = 0;
        if (n2 > 0) {
            n7 = n2 / 1000000;
            n8 = (n2 - n7 * 1000000) * 1000;
        }
        byte[] byArray = new byte[28];
        SystemUse.intToBytes((int)21, (byte[])byArray, (int)0);
        SystemUse.intToBytes((int)attachment.id, (byte[])byArray, (int)4);
        SystemUse.intToBytes((int)n5, (byte[])byArray, (int)8);
        SystemUse.intToBytes((int)n6, (byte[])byArray, (int)12);
        SystemUse.intToBytes((int)n3, (byte[])byArray, (int)16);
        SystemUse.intToBytes((int)n7, (byte[])byArray, (int)20);
        SystemUse.intToBytes((int)n8, (byte[])byArray, (int)24);
        this.out.write(byArray);
        this.out.flush();
        while (true) {
            try {
                n4 = this.in.readInt();
            }
            catch (InterruptedIOException interruptedIOException) {
                continue;
            }
            break;
        }
        if (n4 < 0) {
            if (this.debug >= -1) {
                System.out.println("error in ET system");
            }
            if (n4 == -1) {
                throw new EtException("bad mode value");
            }
            if (n4 == -7) {
                throw new EtBusyException("input list is busy");
            }
            if (n4 == -6) {
                throw new EtEmptyException("no events in list");
            }
            if (n4 == -4) {
                throw new EtWakeUpException("attachment " + attachment.id + " woken up");
            }
            if (n4 == -5) {
                throw new EtTimeoutException("timed out");
            }
        }
        int n9 = this.in.readInt();
        int n10 = n4;
        ArrayList<Event> arrayList = new ArrayList<Event>(n10);
        int n11 = 40;
        byArray = new byte[n11];
        int n12 = 0;
        while (n12 < n10) {
            this.in.readFully(byArray, 0, n11);
            int n13 = SystemUse.bytesToInt((byte[])byArray, (int)0);
            int n14 = SystemUse.bytesToInt((byte[])byArray, (int)4);
            Event event = new Event(n14, n14, this.isJava);
            event.length = n13;
            int n15 = SystemUse.bytesToInt((byte[])byArray, (int)8);
            event.priority = n15 & 1;
            event.dataStatus = (n15 & 0x30) >> 4;
            event.id = SystemUse.bytesToInt((byte[])byArray, (int)12);
            event.byteOrder = SystemUse.bytesToInt((byte[])byArray, (int)16);
            int n16 = 20;
            int n17 = 0;
            while (n17 < 4) {
                event.control[n17] = SystemUse.bytesToInt((byte[])byArray, (int)(n16 += 4));
                ++n17;
            }
            event.modify = n6;
            event.owner = attachment.id;
            this.in.readFully(event.data, 0, n13);
            arrayList.add(event);
            ++n12;
        }
        return arrayList;
    }

    public synchronized Event[] getEvents(Attachment attachment, int n, int n2, int n3) throws IOException, EtException, EtEmptyException, EtBusyException, EtTimeoutException, EtWakeUpException {
        int n4;
        if (!attachment.usable || attachment.sys != this) {
            throw new EtException("Invalid attachment");
        }
        if (attachment.station.id == 0) {
            throw new EtException("may not get events from GRAND_CENTRAL");
        }
        if (n3 == 0) {
            return new Event[0];
        }
        int n5 = n & 3;
        if (n5 != 0 && n5 != 1 && n5 != 2) {
            throw new EtException("bad mode argument");
        }
        if (n2 < 0 && n5 == 1) {
            throw new EtException("bad microSec argument");
        }
        if (n3 < 0) {
            throw new EtException("bad count argument");
        }
        if (attachment == null) {
            throw new EtException("bad attachment argument");
        }
        boolean bl = false;
        int n6 = n & 4;
        if (n6 != 0) {
            bl = true;
        } else {
            n6 = n & 8;
        }
        int n7 = 0;
        int n8 = 0;
        if (n2 > 0) {
            n7 = n2 / 1000000;
            n8 = (n2 - n7 * 1000000) * 1000;
        }
        byte[] byArray = new byte[28];
        SystemUse.intToBytes((int)21, (byte[])byArray, (int)0);
        SystemUse.intToBytes((int)attachment.id, (byte[])byArray, (int)4);
        SystemUse.intToBytes((int)n5, (byte[])byArray, (int)8);
        SystemUse.intToBytes((int)n6, (byte[])byArray, (int)12);
        SystemUse.intToBytes((int)n3, (byte[])byArray, (int)16);
        SystemUse.intToBytes((int)n7, (byte[])byArray, (int)20);
        SystemUse.intToBytes((int)n8, (byte[])byArray, (int)24);
        this.out.write(byArray);
        this.out.flush();
        while (true) {
            try {
                n4 = this.in.readInt();
            }
            catch (InterruptedIOException interruptedIOException) {
                continue;
            }
            break;
        }
        if (n4 < 0) {
            if (this.debug >= -1) {
                System.out.println("error in ET system");
            }
            if (n4 == -1) {
                throw new EtException("bad mode value");
            }
            if (n4 == -7) {
                throw new EtBusyException("input list is busy");
            }
            if (n4 == -6) {
                throw new EtEmptyException("no events in list");
            }
            if (n4 == -4) {
                throw new EtWakeUpException("attachment " + attachment.id + " woken up");
            }
            if (n4 == -5) {
                throw new EtTimeoutException("timed out");
            }
        }
        int n9 = this.in.readInt();
        int n10 = n4;
        Event[] eventArray = new Event[n10];
        int n11 = 40;
        byArray = new byte[n11];
        int n12 = 0;
        while (n12 < n10) {
            this.in.readFully(byArray, 0, n11);
            int n13 = SystemUse.bytesToInt((byte[])byArray, (int)0);
            int n14 = SystemUse.bytesToInt((byte[])byArray, (int)4);
            eventArray[n12] = new Event(n14, n14, this.isJava);
            eventArray[n12].length = n13;
            int n15 = SystemUse.bytesToInt((byte[])byArray, (int)8);
            eventArray[n12].priority = n15 & 1;
            eventArray[n12].dataStatus = (n15 & 0x30) >> 4;
            eventArray[n12].id = SystemUse.bytesToInt((byte[])byArray, (int)12);
            eventArray[n12].byteOrder = SystemUse.bytesToInt((byte[])byArray, (int)16);
            int n16 = 20;
            int n17 = 0;
            while (n17 < 4) {
                eventArray[n12].control[n17] = SystemUse.bytesToInt((byte[])byArray, (int)(n16 += 4));
                ++n17;
            }
            eventArray[n12].modify = n6;
            eventArray[n12].owner = attachment.id;
            this.in.readFully(eventArray[n12].data, 0, n13);
            ++n12;
        }
        return eventArray;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized Event[] getEvents2(Attachment var1_1, int var2_2, int var3_3, int var4_4) throws EtException, EtEmptyException, EtBusyException, EtTimeoutException, EtWakeUpException, IOException {
        if (!var1_1.usable || var1_1.sys != this) {
            throw new EtException("Invalid attachment");
        }
        if (var1_1.station.id == 0) {
            throw new EtException("may not get events from GRAND_CENTRAL");
        }
        if (var4_4 == 0) {
            return new Event[0];
        }
        var5_5 = var2_2 & 3;
        if (var5_5 != 0 && var5_5 != 1 && var5_5 != 2) {
            throw new EtException("bad mode argument");
        }
        if (var3_3 < 0 && var5_5 == 1) {
            throw new EtException("bad microSec argument");
        }
        if (var4_4 < 0) {
            throw new EtException("bad count argument");
        }
        if (var1_1 == null) {
            throw new EtException("bad attachment argument");
        }
        var6_6 = false;
        var7_7 = var2_2 & 4;
        if (var7_7 != 0) {
            var6_6 = true;
        } else {
            var7_7 = var2_2 & 8;
        }
        var8_8 = 0;
        var9_9 = 0;
        if (var3_3 > 0) {
            var8_8 = var3_3 / 1000000;
            var9_9 = (var3_3 - var8_8 * 1000000) * 1000;
        }
        var10_10 = new byte[28];
        SystemUse.intToBytes((int)21, (byte[])var10_10, (int)0);
        SystemUse.intToBytes((int)var1_1.id, (byte[])var10_10, (int)4);
        SystemUse.intToBytes((int)var5_5, (byte[])var10_10, (int)8);
        SystemUse.intToBytes((int)var7_7, (byte[])var10_10, (int)12);
        SystemUse.intToBytes((int)var4_4, (byte[])var10_10, (int)16);
        SystemUse.intToBytes((int)var8_8, (byte[])var10_10, (int)20);
        SystemUse.intToBytes((int)var9_9, (byte[])var10_10, (int)24);
        this.out.write(var10_10);
        this.out.flush();
        var13_11 = new byte[4];
        while (true) {
            try {
                var11_14 = this.sockIn.read(var13_11, 0, 4);
                if (var11_14 != -1) ** GOTO lbl47
                throw new IOException("Socket connection to ET system broken.");
lbl-1000:
                // 1 sources

                {
                    var12_15 = this.sockIn.read(var13_11, var11_14, 4 - var11_14);
                    if (var12_15 == -1) {
                        throw new IOException("Socket connection to ET system broken.");
                    }
                    var11_14 += var12_15;
lbl47:
                    // 2 sources

                    ** while (var11_14 < 4)
                }
lbl48:
                // 1 sources

            }
            catch (InterruptedIOException var14_12) {
                continue;
            }
            break;
        }
        var14_13 = SystemUse.bytesToInt((byte[])var13_11, (int)0);
        if (var14_13 < 0) {
            if (this.debug >= -1) {
                System.out.println("error in ET system");
            }
            if (var14_13 == -1) {
                throw new EtException("bad mode value");
            }
            if (var14_13 == -7) {
                throw new EtBusyException("input list is busy");
            }
            if (var14_13 == -6) {
                throw new EtEmptyException("no events in list");
            }
            if (var14_13 == -4) {
                throw new EtWakeUpException("attachment " + var1_1.id + " woken up");
            }
            if (var14_13 == -5) {
                throw new EtTimeoutException("timed out");
            }
        }
        if ((var11_14 = this.sockIn.read(var13_11, 0, 4)) != -1) ** GOTO lbl71
        throw new IOException("Socket connection to ET system broken.");
lbl-1000:
        // 1 sources

        {
            var12_15 = this.sockIn.read(var13_11, var11_14, 4 - var11_14);
            if (var12_15 == -1) {
                throw new IOException("Socket connection to ET system broken.");
            }
            var11_14 += var12_15;
lbl71:
            // 2 sources

            ** while (var11_14 < 4)
        }
lbl72:
        // 1 sources

        var15_16 = SystemUse.bytesToInt((byte[])var13_11, (int)0);
        var16_17 = var14_13;
        var17_18 = new Event[var16_17];
        var22_19 = var15_16 > 65535 ? 65535 : var15_16;
        var23_20 = new byte[var22_19];
        var11_14 = this.sockIn.read(var23_20, 0, var22_19);
        if (var11_14 != -1) ** GOTO lbl84
        throw new IOException("Socket connection to ET system broken.");
lbl-1000:
        // 1 sources

        {
            var12_15 = this.sockIn.read(var23_20, var11_14, var22_19 - var11_14);
            if (var12_15 == -1) {
                throw new IOException("Socket connection to ET system broken.");
            }
            var11_14 += var12_15;
lbl84:
            // 2 sources

            ** while (var11_14 < var22_19)
        }
lbl85:
        // 1 sources

        var24_21 = 40;
        var28_22 = var11_14;
        var29_23 = 0;
        var30_24 = 0;
        var31_25 = 0;
        ** GOTO lbl138
        {
            if (var28_22 == 0) {
                var28_22 = this.sockIn.read(var23_20);
                if (var28_22 == -1) {
                    throw new IOException("Socket connection to ET system broken.");
                }
            } else {
                if (var30_24 != 0) {
                    System.arraycopy(var23_20, var30_24, var23_20, 0, var28_22);
                }
                if ((var12_15 = this.sockIn.read(var23_20, var28_22, 65535 - var28_22)) == -1) {
                    throw new IOException("Socket connection to ET system broken.");
                }
                var28_22 += var12_15;
            }
            var30_24 = 0;
            do {
                if (var28_22 < var24_21) continue block6;
                var25_26 = SystemUse.bytesToInt((byte[])var23_20, (int)var30_24);
                var26_27 = SystemUse.bytesToInt((byte[])var23_20, (int)(var30_24 += 4));
                var17_18[var31_25] = new Event(var26_27, var26_27, this.isJava);
                var17_18[var31_25].length = var25_26;
                var27_28 = SystemUse.bytesToInt((byte[])var23_20, (int)(var30_24 += 4));
                var17_18[var31_25].priority = var27_28 & 1;
                var17_18[var31_25].dataStatus = (var27_28 & 48) >> 4;
                var17_18[var31_25].id = SystemUse.bytesToInt((byte[])var23_20, (int)(var30_24 += 4));
                var17_18[var31_25].byteOrder = SystemUse.bytesToInt((byte[])var23_20, (int)(var30_24 += 4));
                var30_24 += 4;
                var32_29 = 0;
                while (var32_29 < 4) {
                    var17_18[var31_25].control[var32_29] = SystemUse.bytesToInt((byte[])var23_20, (int)(var30_24 += 4));
                    ++var32_29;
                }
                var30_24 += 4;
                var17_18[var31_25].modify = var7_7;
                var17_18[var31_25].owner = var1_1.id;
                if ((var28_22 -= var24_21) >= var25_26) {
                    System.arraycopy(var23_20, var30_24, var17_18[var31_25].data, 0, var25_26);
                    var28_22 -= var25_26;
                    var30_24 += var25_26;
                } else {
                    System.arraycopy(var23_20, var30_24, var17_18[var31_25].data, 0, var28_22);
                    var29_23 = var28_22;
                    while (var29_23 < var25_26) {
                        var12_15 = this.sockIn.read(var17_18[var31_25].data, var29_23, var25_26 - var29_23);
                        if (var12_15 == -1) {
                            throw new IOException("Socket connection to ET system broken.");
                        }
                        var29_23 += var12_15;
                    }
                    var30_24 = 0;
                    var28_22 = 0;
                }
                ++var31_25;
lbl138:
                // 2 sources

            } while (var31_25 < var16_17);
        }
        return var17_18;
    }

    public synchronized void putEventsList(Attachment attachment, List list) throws IOException, EtException {
        int n;
        Event event;
        if (!attachment.usable || attachment.sys != this) {
            throw new EtException("Invalid attachment");
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 36;
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            event = (Event)listIterator.next();
            if (event.owner != attachment.id) {
                throw new EtException("may not put event(s), not owner");
            }
            if (event.modify <= 0) continue;
            ++n3;
            n2 += n4;
            if (event.modify != 4) continue;
            n2 += event.length;
        }
        this.out.writeInt(23);
        this.out.writeInt(attachment.id);
        this.out.writeInt(n3);
        this.out.writeInt(n2);
        ListIterator listIterator2 = list.listIterator();
        while (listIterator2.hasNext()) {
            event = (Event)listIterator2.next();
            if (event.modify <= 0) continue;
            this.out.writeInt(event.id);
            this.out.writeInt(event.length);
            this.out.writeInt(event.priority | event.dataStatus << 4);
            this.out.writeInt(event.byteOrder);
            this.out.writeInt(0);
            n = 0;
            while (n < 4) {
                this.out.writeInt(event.control[n]);
                ++n;
            }
            if (event.modify != 4) continue;
            this.out.write(event.data, 0, event.length);
        }
        this.out.flush();
        n = this.in.readInt();
    }

    public synchronized void putEvents(Attachment attachment, Event[] eventArray) throws IOException, EtException {
        int n;
        if (!attachment.usable || attachment.sys != this) {
            throw new EtException("Invalid attachment");
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 36;
        int n5 = 0;
        while (n5 < eventArray.length) {
            if (eventArray[n5].owner != attachment.id) {
                throw new EtException("may not put event(s), not owner");
            }
            if (eventArray[n5].modify > 0) {
                ++n3;
                n2 += n4;
                if (eventArray[n5].modify == 4) {
                    n2 += eventArray[n5].length;
                }
            }
            ++n5;
        }
        this.out.writeInt(23);
        this.out.writeInt(attachment.id);
        this.out.writeInt(n3);
        this.out.writeInt(n2);
        int n6 = 0;
        while (n6 < eventArray.length) {
            if (eventArray[n6].modify > 0) {
                this.out.writeInt(eventArray[n6].id);
                this.out.writeInt(eventArray[n6].length);
                this.out.writeInt(eventArray[n6].priority | eventArray[n6].dataStatus << 4);
                this.out.writeInt(eventArray[n6].byteOrder);
                this.out.writeInt(0);
                n = 0;
                while (n < 4) {
                    this.out.writeInt(eventArray[n6].control[n]);
                    ++n;
                }
                if (eventArray[n6].modify == 4) {
                    this.out.write(eventArray[n6].data, 0, eventArray[n6].length);
                }
            }
            ++n6;
        }
        this.out.flush();
        n = this.in.readInt();
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void putEvents2(Attachment var1_1, Event[] var2_2) throws IOException, EtException {
        if (!var1_1.usable || var1_1.sys != this) {
            throw new EtException("Invalid attachment");
        }
        var6_3 = 0;
        var7_4 = 0;
        var8_5 = 36;
        var9_6 = 0;
        while (var9_6 < var2_2.length) {
            if (var2_2[var9_6].owner != var1_1.id) {
                throw new EtException("may not put event(s), not owner");
            }
            if (var2_2[var9_6].modify > 0) {
                ++var7_4;
                var6_3 += var8_5;
                if (var2_2[var9_6].modify == 4) {
                    var6_3 += var2_2[var9_6].length;
                }
            }
            ++var9_6;
        }
        var10_7 = new byte[65535];
        var12_8 = 16;
        SystemUse.intToBytes((int)23, (byte[])var10_7, (int)0);
        SystemUse.intToBytes((int)var1_1.id, (byte[])var10_7, (int)4);
        SystemUse.intToBytes((int)var7_4, (byte[])var10_7, (int)8);
        SystemUse.intToBytes((int)var6_3, (byte[])var10_7, (int)12);
        var13_9 = 0;
        while (var13_9 < var2_2.length) {
            block11: {
                block12: {
                    if (var2_2[var13_9].modify <= 0) break block11;
                    var11_10 = var2_2[var13_9].length;
                    SystemUse.intToBytes((int)var2_2[var13_9].id, (byte[])var10_7, (int)var12_8);
                    SystemUse.intToBytes((int)var11_10, (byte[])var10_7, (int)(var12_8 += 4));
                    SystemUse.intToBytes((int)(var2_2[var13_9].priority | var2_2[var13_9].dataStatus << 4), (byte[])var10_7, (int)(var12_8 += 4));
                    SystemUse.intToBytes((int)var2_2[var13_9].byteOrder, (byte[])var10_7, (int)(var12_8 += 4));
                    SystemUse.intToBytes((int)0, (byte[])var10_7, (int)(var12_8 += 4));
                    var14_11 = 0;
                    while (var14_11 < 4) {
                        SystemUse.intToBytes((int)var2_2[var13_9].control[var14_11], (byte[])var10_7, (int)(var12_8 += 4));
                        ++var14_11;
                    }
                    var12_8 += 4;
                    if (var2_2[var13_9].modify != 4) break block12;
                    if (var12_8 + var8_5 + var11_10 <= var10_7.length) ** GOTO lbl47
                    this.sockOut.write(var10_7, 0, var12_8);
                    var12_8 = 0;
                    if (var8_5 + var11_10 > var10_7.length / 2) {
                        this.sockOut.write(var2_2[var13_9].data, 0, var11_10);
                        this.sockOut.flush();
                    } else {
                        this.sockOut.flush();
lbl47:
                        // 2 sources

                        System.arraycopy(var2_2[var13_9].data, 0, var10_7, var12_8, var11_10);
                        var12_8 += var11_10;
                    }
                    break block11;
                }
                if (var12_8 + var8_5 > var10_7.length) {
                    this.sockOut.write(var10_7, 0, var12_8);
                    var12_8 = 0;
                    this.sockOut.flush();
                }
            }
            ++var13_9;
        }
        if (var12_8 > 0) {
            this.sockOut.write(var10_7, 0, var12_8);
            this.sockOut.flush();
        }
        var14_11 = this.in.readInt();
    }

    public synchronized void dumpEventsList(Attachment attachment, List list) throws IOException, EtException {
        Event event;
        if (!attachment.usable || attachment.sys != this) {
            throw new EtException("Invalid attachment");
        }
        int n = 0;
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            event = (Event)listIterator.next();
            if (event.owner != attachment.id) {
                throw new EtException("may not put event(s), not owner");
            }
            if (event.modify <= 0) continue;
            ++n;
        }
        this.out.writeInt(27);
        this.out.writeInt(attachment.id);
        this.out.writeInt(n);
        ListIterator listIterator2 = list.listIterator();
        while (listIterator2.hasNext()) {
            event = (Event)listIterator2.next();
            if (event.modify <= 0) continue;
            this.out.writeInt(event.id);
        }
        this.out.flush();
        int n2 = this.in.readInt();
    }

    public synchronized void dumpEvents(Attachment attachment, Event[] eventArray) throws IOException, EtException {
        if (!attachment.usable || attachment.sys != this) {
            throw new EtException("Invalid attachment");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < eventArray.length) {
            if (eventArray[n2].owner != attachment.id) {
                throw new EtException("may not put event(s), not owner");
            }
            if (eventArray[n2].modify > 0) {
                ++n;
            }
            ++n2;
        }
        this.out.writeInt(27);
        this.out.writeInt(attachment.id);
        this.out.writeInt(n);
        byte[] byArray = new byte[4 * n];
        int n3 = -4;
        int n4 = 0;
        while (n4 < eventArray.length) {
            if (eventArray[n4].modify > 0) {
                SystemUse.intToBytes((int)eventArray[n4].id, (byte[])byArray, (int)(n3 += 4));
            }
            ++n4;
        }
        this.out.write(byArray, 0, n3 + 4);
        this.out.flush();
        int n5 = this.in.readInt();
    }

    private synchronized int getIntValue(int n) throws IOException {
        this.out.writeInt(n);
        this.out.flush();
        int n2 = this.in.readInt();
        int n3 = this.in.readInt();
        return n3;
    }

    public int getNumStations() throws IOException {
        return this.getIntValue(152);
    }

    public int getStationsMax() throws IOException {
        return this.getIntValue(153);
    }

    public int getNumAttachments() throws IOException {
        return this.getIntValue(156);
    }

    public int getAttachmentsMax() throws IOException {
        return this.getIntValue(157);
    }

    public int getNumProcesses() throws IOException {
        return this.getIntValue(154);
    }

    public int getProcessesMax() throws IOException {
        return this.getIntValue(155);
    }

    public int getNumTemps() throws IOException {
        return this.getIntValue(150);
    }

    public int getTempsMax() throws IOException {
        return this.getIntValue(151);
    }

    public int getHeartbeat() throws IOException {
        return this.getIntValue(158);
    }

    public int getPid() throws IOException {
        return this.getIntValue(159);
    }

    public int getNumEvents() {
        return this.sys.numEvents;
    }

    public int getEventSize() {
        return this.sys.eventSize;
    }

    public int getLanguage() {
        return this.sys.language;
    }

    public String getHost() {
        return this.sys.host;
    }

    public int getTcpPort() {
        return this.sys.tcpPort;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int n) throws EtException {
        if (n != 0 && n != 1 && n != 2 && n != 3 && n != 4) {
            throw new EtException("bad debug argument");
        }
        this.debug = n;
    }

    public SystemOpenConfig getConfig() {
        return new SystemOpenConfig(this.openConfig);
    }

    public synchronized AllData getData() throws EtException, IOException {
        AllData allData = new AllData();
        this.out.writeInt(170);
        this.out.flush();
        int n = this.in.readInt();
        if (n != 0) {
            throw new EtException("error getting ET system data");
        }
        int n2 = this.in.readInt();
        allData.sysData.read(this.in);
        int n3 = this.in.readInt();
        allData.statData = new StationData[n3];
        int n4 = 0;
        while (n4 < n3) {
            allData.statData[n4] = new StationData();
            allData.statData[n4].read(this.in);
            ++n4;
        }
        n3 = this.in.readInt();
        allData.attData = new AttachmentData[n3];
        int n5 = 0;
        while (n5 < n3) {
            allData.attData[n5] = new AttachmentData();
            allData.attData[n5].read(this.in);
            ++n5;
        }
        n3 = this.in.readInt();
        allData.procData = new ProcessData[n3];
        int n6 = 0;
        while (n6 < n3) {
            allData.procData[n6] = new ProcessData();
            allData.procData[n6].read(this.in);
            ++n6;
        }
        return allData;
    }

    public synchronized int[] getHistogram() throws IOException, EtException {
        byte[] byArray = new byte[4 * (this.sys.numEvents + 1)];
        int[] nArray = new int[this.sys.numEvents + 1];
        this.out.writeInt(171);
        this.out.flush();
        if (this.in.readInt() != 0) {
            throw new EtException("cannot get histogram");
        }
        this.in.readFully(byArray);
        int n = 0;
        while (n < this.sys.numEvents + 1) {
            nArray[n] = SystemUse.bytesToInt((byte[])byArray, (int)(n * 4));
            ++n;
        }
        return nArray;
    }
}

