/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import org.jlab.coda.et.ListeningThread;
import org.jlab.coda.et.SystemConfig;
import org.jlab.coda.et.SystemCreate;

public class SystemUdpServer
extends Thread {
    private int port;
    private SystemCreate sys;
    private SystemConfig config;

    SystemUdpServer(SystemCreate systemCreate) {
        this.sys = systemCreate;
        this.config = this.sys.config;
        this.port = this.config.serverPort;
    }

    public void run() {
        InetAddress inetAddress;
        ListeningThread listeningThread;
        InetAddress[] inetAddressArray;
        if (this.config.debug >= 4) {
            System.out.println("Running UDP Listening Threads");
        }
        if (this.port < 1) {
            this.port = 11111;
        }
        try {
            inetAddressArray = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            this.sys.netAddresses = inetAddressArray;
        }
        catch (UnknownHostException unknownHostException) {
            if (this.config.debug >= 2) {
                System.out.println("cannot find local IP addresses");
                unknownHostException.printStackTrace();
            }
            return;
        }
        int n = 0;
        while (n < inetAddressArray.length) {
            if (this.config.debug >= 4) {
                System.out.println("Listening on interface " + inetAddressArray[n].getHostAddress() + ", port " + this.config.serverPort);
            }
            listeningThread = new ListeningThread(this.sys, inetAddressArray[n], true);
            listeningThread.start();
            ++n;
        }
        Iterator iterator = this.config.multicastAddrs.iterator();
        while (iterator.hasNext()) {
            inetAddress = (InetAddress)iterator.next();
            if (this.config.debug >= 4) {
                System.out.println("Listening for multicasts at " + inetAddress.getHostAddress() + ", port " + this.config.multicastPort);
            }
            listeningThread = new ListeningThread(this.sys, inetAddress);
            listeningThread.start();
        }
        Iterator iterator2 = this.config.broadcastAddrs.iterator();
        while (iterator2.hasNext()) {
            inetAddress = (InetAddress)iterator2.next();
            if (this.config.debug >= 4) {
                System.out.println("Listening for broadcasts at " + inetAddress.getHostAddress() + ", port " + this.config.udpPort);
            }
            listeningThread = new ListeningThread(this.sys, inetAddress);
            listeningThread.start();
        }
    }
}

