/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jlab.coda.et.EtException;

public class SystemConfig {
    int numEvents;
    int eventSize;
    int stationsMax;
    int attachmentsMax;
    int debug;
    int udpPort;
    int serverPort;
    int multicastPort;
    HashSet multicastAddrs;
    HashSet broadcastAddrs;

    public SystemConfig() {
        this.numEvents = 300;
        this.eventSize = 1000;
        this.stationsMax = 20;
        this.attachmentsMax = 50;
        this.debug = 2;
        this.udpPort = 11111;
        this.serverPort = 11111;
        this.multicastPort = 11112;
        this.multicastAddrs = new HashSet(10);
        this.broadcastAddrs = new HashSet(10);
    }

    public SystemConfig(SystemConfig systemConfig) {
        this.numEvents = systemConfig.numEvents;
        this.eventSize = systemConfig.eventSize;
        this.stationsMax = systemConfig.stationsMax;
        this.attachmentsMax = systemConfig.attachmentsMax;
        this.debug = systemConfig.debug;
        this.udpPort = systemConfig.udpPort;
        this.serverPort = systemConfig.serverPort;
        this.multicastPort = systemConfig.multicastPort;
        this.multicastAddrs = new HashSet(systemConfig.multicastAddrs);
        this.broadcastAddrs = new HashSet(systemConfig.broadcastAddrs);
    }

    public int getNumEvents() {
        return this.numEvents;
    }

    public int getEventSize() {
        return this.eventSize;
    }

    public int getStationsMax() {
        return this.stationsMax;
    }

    public int getAttachmentsMax() {
        return this.attachmentsMax;
    }

    public int getDebug() {
        return this.debug;
    }

    public int getUdpPort() {
        return this.udpPort;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public Set getMulticastAddrs() {
        return new HashSet(this.multicastAddrs);
    }

    public Set getBroadcastAddrs() {
        return new HashSet(this.broadcastAddrs);
    }

    public String[] getMulticastStrings() {
        if (this.multicastAddrs == null) {
            return null;
        }
        int n = 0;
        String[] stringArray = new String[this.multicastAddrs.size()];
        Iterator iterator = this.multicastAddrs.iterator();
        while (iterator.hasNext()) {
            stringArray[n++] = ((InetAddress)iterator.next()).getHostAddress();
        }
        return stringArray;
    }

    public String[] getBroadcastStrings() {
        if (this.broadcastAddrs == null) {
            return null;
        }
        int n = 0;
        String[] stringArray = new String[this.broadcastAddrs.size()];
        Iterator iterator = this.broadcastAddrs.iterator();
        while (iterator.hasNext()) {
            stringArray[n++] = ((InetAddress)iterator.next()).getHostAddress();
        }
        return stringArray;
    }

    public void addMulticastAddr(String string) throws EtException {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new EtException("not a multicast address");
        }
        if (!inetAddress.isMulticastAddress()) {
            throw new EtException("not a multicast address");
        }
        this.multicastAddrs.add(inetAddress);
    }

    public void addBroadcastAddr(String string) throws EtException {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new EtException("not a broadcast address");
        }
        this.broadcastAddrs.add(inetAddress);
    }

    public void removeMulticastAddr(String string) {
        this.multicastAddrs.remove(string);
    }

    public void removeBroadcastAddr(String string) {
        this.multicastAddrs.remove(string);
    }

    public void setNumEvents(int n) throws EtException {
        if (n < 1) {
            throw new EtException("must have 1 or more events");
        }
        this.numEvents = n;
    }

    public void setEventSize(int n) throws EtException {
        if (n < 1) {
            throw new EtException("events must have at least one byte");
        }
        this.eventSize = n;
    }

    public void setStationsMax(int n) throws EtException {
        if (n < 2) {
            throw new EtException("must have at least 2 stations");
        }
        this.stationsMax = n;
    }

    public void setAttachmentsMax(int n) throws EtException {
        if (n < 1) {
            throw new EtException("must be able to have at least one attachment");
        }
        this.attachmentsMax = n;
    }

    public void setDebug(int n) throws EtException {
        if (n != 0 && n != 4 && n != 3 && n != 2 && n != 1) {
            throw new EtException("bad debug value");
        }
        this.debug = n;
    }

    public void setUdpPort(int n) throws EtException {
        if (n < 1024) {
            throw new EtException("port number must be greater than 1023");
        }
        this.udpPort = n;
    }

    public void setServerPort(int n) throws EtException {
        if (n < 1024) {
            throw new EtException("port number must be greater than 1023");
        }
        this.serverPort = n;
    }

    public void setMulticastPort(int n) throws EtException {
        if (n < 1024) {
            throw new EtException("port number must be greater than 1023");
        }
        this.multicastPort = n;
    }
}

