/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jlab.coda.et.EtException;
import org.jlab.coda.et.Event;
import org.jlab.coda.et.EventList;
import org.jlab.coda.et.EventSelectable;
import org.jlab.coda.et.StationConfig;
import org.jlab.coda.et.SystemCreate;

public class StationLocal
extends Thread
implements EventSelectable {
    private SystemCreate sys;
    int id;
    String name;
    StationConfig config;
    volatile int status;
    volatile boolean killConductor;
    volatile boolean wasLast;
    private byte[] stopTransfer;
    LinkedList parallelStations;
    EventList inputList;
    EventList outputList;
    HashSet attachments;
    EventSelectable selector;

    StationLocal(SystemCreate systemCreate, String string, StationConfig stationConfig, int n) throws EtException {
        this.id = n;
        this.sys = systemCreate;
        this.name = string;
        this.config = new StationConfig(stationConfig);
        this.status = 0;
        this.stopTransfer = new byte[0];
        this.parallelStations = new LinkedList();
        this.inputList = new EventList();
        this.outputList = new EventList();
        this.attachments = new HashSet(110);
        this.selector = this;
        if (this.config.selectMode == 3) {
            try {
                Object obj = Class.forName(this.config.selectClass).newInstance();
                this.selector = (EventSelectable)obj;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new EtException("station cannot load select class " + this.config.selectClass);
            }
            catch (InstantiationException instantiationException) {
                throw new EtException("station cannot instantiate class " + this.config.selectClass);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new EtException("station cannot load class " + this.config.selectClass);
            }
            if (this.sys.config.debug >= 4) {
                System.out.println(this.name + " loaded select class " + this.config.selectClass);
            }
        }
    }

    public int getId() {
        return this.id;
    }

    private void insertStation(StationLocal stationLocal, int n, int n2) throws EtException {
        if (this.sys.stations.size() < 2 || n >= this.sys.stations.size() || n == -1) {
            this.sys.stations.add(stationLocal);
            if (stationLocal.config.flowMode == 1) {
                stationLocal.parallelStations = new LinkedList();
                stationLocal.parallelStations.add(stationLocal);
            }
        } else {
            StationLocal stationLocal2 = (StationLocal)this.sys.stations.get(n);
            if (stationLocal.config.flowMode == 1 && stationLocal2.config.flowMode == 1 && n2 != -2) {
                if (!StationConfig.compatibleParallelConfigs((StationConfig)stationLocal2.config, (StationConfig)stationLocal.config)) {
                    throw new EtException("trying to add incompatible parallel station\n");
                }
                if (n2 == 0) {
                    throw new EtException("trying to add parallel station to head of existing parallel group\n");
                }
                if (n2 == -1 || n2 > this.parallelStations.size()) {
                    stationLocal2.parallelStations.add(stationLocal);
                } else {
                    stationLocal2.parallelStations.add(n2, stationLocal);
                }
            } else {
                this.sys.stations.add(n, stationLocal);
                if (stationLocal.config.flowMode == 1) {
                    stationLocal.parallelStations = new LinkedList();
                    stationLocal.parallelStations.add(stationLocal);
                }
            }
        }
    }

    private void deleteStation(StationLocal stationLocal) {
        if (this.sys.stations.contains(stationLocal)) {
            int n = this.sys.stations.indexOf(stationLocal);
            this.sys.stations.remove(stationLocal);
            if (stationLocal.config.flowMode == 0) {
                return;
            }
            stationLocal.parallelStations.removeFirst();
            if (stationLocal.parallelStations.size() < 1) {
                stationLocal.parallelStations = null;
                return;
            }
            StationLocal stationLocal2 = (StationLocal)stationLocal.parallelStations.getFirst();
            stationLocal2.parallelStations = stationLocal.parallelStations;
            stationLocal.parallelStations = null;
            this.sys.stations.add(n, stationLocal2);
        } else {
            ListIterator listIterator = this.sys.stations.listIterator();
            while (listIterator.hasNext()) {
                StationLocal stationLocal3 = (StationLocal)listIterator.next();
                if (stationLocal3.parallelStations == null || !stationLocal3.parallelStations.remove(stationLocal)) continue;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addStation(StationLocal stationLocal, int n, int n2) throws EtException {
        int n3 = this.sys.stations.indexOf(this) + 1;
        ListIterator listIterator = this.sys.stations.listIterator(n3);
        if (listIterator.hasNext()) {
            StationLocal stationLocal2 = (StationLocal)listIterator.next();
            byte[] byArray = this.stopTransfer;
            synchronized (byArray) {
                stationLocal2.addStation(stationLocal, n, n2);
            }
        }
        byte[] byArray = this.stopTransfer;
        synchronized (byArray) {
            this.insertStation(stationLocal, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStation(StationLocal stationLocal) {
        int n = this.sys.stations.indexOf(this) + 1;
        ListIterator listIterator = this.sys.stations.listIterator(n);
        if (listIterator.hasNext()) {
            StationLocal stationLocal2 = (StationLocal)listIterator.next();
            byte[] byArray = this.stopTransfer;
            synchronized (byArray) {
                stationLocal2.removeStation(stationLocal);
            }
        }
        byte[] byArray = this.stopTransfer;
        synchronized (byArray) {
            this.deleteStation(stationLocal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveStation(StationLocal stationLocal, int n, int n2) throws EtException {
        int n3 = this.sys.stations.indexOf(this) + 1;
        ListIterator listIterator = this.sys.stations.listIterator(n3);
        if (listIterator.hasNext()) {
            StationLocal stationLocal2 = (StationLocal)listIterator.next();
            byte[] byArray = this.stopTransfer;
            synchronized (byArray) {
                stationLocal2.moveStation(stationLocal, n, n2);
            }
        }
        byte[] byArray = this.stopTransfer;
        synchronized (byArray) {
            this.deleteStation(stationLocal);
            this.insertStation(stationLocal, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeStationStatus(StationLocal stationLocal, int n) {
        int n2 = this.sys.stations.indexOf(this) + 1;
        ListIterator listIterator = this.sys.stations.listIterator(n2);
        if (listIterator.hasNext()) {
            StationLocal stationLocal2 = (StationLocal)listIterator.next();
            byte[] byArray = this.stopTransfer;
            synchronized (byArray) {
                stationLocal2.changeStationStatus(stationLocal, n);
            }
        }
        byte[] byArray = this.stopTransfer;
        synchronized (byArray) {
            stationLocal.status = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBlockMode(int n) {
        if (this.config.blockMode == n) {
            return;
        }
        byte[] byArray = this.sys.stationLock;
        synchronized (byArray) {
            EventList eventList = this.inputList;
            synchronized (eventList) {
                this.config.blockMode = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCue(int n) {
        if (this.config.cue == n) {
            return;
        }
        byte[] byArray = this.sys.stationLock;
        synchronized (byArray) {
            EventList eventList = this.inputList;
            synchronized (eventList) {
                this.config.cue = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPrescale(int n) {
        if (this.config.prescale == n) {
            return;
        }
        byte[] byArray = this.sys.stationLock;
        synchronized (byArray) {
            EventList eventList = this.inputList;
            synchronized (eventList) {
                this.config.prescale = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSelectWords(int[] nArray) {
        if (this.config.select == nArray) {
            return;
        }
        byte[] byArray = this.sys.stationLock;
        synchronized (byArray) {
            EventList eventList = this.inputList;
            synchronized (eventList) {
                this.config.select = (int[])nArray.clone();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUserMode(int n) {
        if (this.config.userMode == n) {
            return;
        }
        byte[] byArray = this.sys.stationLock;
        synchronized (byArray) {
            this.config.userMode = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRestoreMode(int n) {
        if (this.config.restoreMode == n) {
            return;
        }
        byte[] byArray = this.sys.stationLock;
        synchronized (byArray) {
            this.config.restoreMode = n;
        }
    }

    public boolean select(SystemCreate systemCreate, StationLocal stationLocal, Event event) {
        boolean bl = false;
        int n = 0;
        while (n < 4) {
            bl = n % 2 == 0 ? bl || stationLocal.config.select[n] != -1 && stationLocal.config.select[n] == event.control[n] : bl || stationLocal.config.select[n] != -1 && (stationLocal.config.select[n] & event.control[n]) != 0;
            ++n;
        }
        return bl;
    }

    private void shellSort(int n, int[] nArray, int[] nArray2) {
        int n2 = 1;
        do {
            n2 *= 3;
        } while (++n2 <= n);
        do {
            int n3 = (n2 /= 3) + 1;
            while (n3 <= n) {
                int n4 = nArray[n3];
                int n5 = nArray2[n3];
                int n6 = n3;
                while (nArray[n6 - n2] > n4) {
                    nArray[n6] = nArray[n6 - n2];
                    nArray2[n6] = nArray2[n6 - n2];
                    if ((n6 -= n2) <= n2) break;
                }
                nArray[n6] = n4;
                nArray2[n6] = n5;
                ++n3;
            }
        } while (n2 > 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Event event = null;
        boolean bl = false;
        boolean bl2 = false;
        StationLocal stationLocal = null;
        StationLocal stationLocal2 = null;
        List list = null;
        ListIterator listIterator = null;
        EventList eventList = null;
        ArrayList arrayList = new ArrayList(this.sys.config.numEvents);
        ArrayList arrayList2 = new ArrayList(this.sys.config.numEvents);
        this.status = this.name.equals("GRAND_CENTRAL") ? 3 : 2;
        while (true) {
            EventList eventList2 = this.outputList;
            synchronized (eventList2) {
                while (this.outputList.events.size() < 1) {
                    try {
                        this.outputList.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!this.killConductor) continue;
                    return;
                }
            }
            this.outputList.get(arrayList);
            boolean bl3 = false;
            byte[] byArray = this.stopTransfer;
            synchronized (byArray) {
                ListIterator listIterator2;
                int n = this.sys.stations.indexOf(this);
                if (n < 0) {
                    n = 1;
                    ListIterator listIterator3 = this.sys.stations.listIterator(1);
                    while (listIterator3.hasNext()) {
                        stationLocal2 = (StationLocal)listIterator3.next();
                        if (stationLocal2.config.flowMode == 1 && stationLocal2.parallelStations.indexOf(this) > -1) break;
                        ++n;
                    }
                }
                if (!(listIterator2 = this.sys.stations.listIterator(n + 1)).hasNext()) {
                    stationLocal = (StationLocal)this.sys.stations.getFirst();
                    EventList eventList3 = eventList = stationLocal.inputList;
                    synchronized (eventList3) {
                        eventList.putInLow(arrayList);
                        arrayList.clear();
                        eventList.notifyAll();
                    }
                }
                stationLocal = (StationLocal)listIterator2.next();
                eventList = stationLocal.inputList;
                while (arrayList.size() > 0) {
                    block89: {
                        int n2;
                        bl = false;
                        bl2 = false;
                        StationLocal stationLocal3 = null;
                        StationLocal stationLocal4 = null;
                        if (stationLocal.config.flowMode == 1) {
                            listIterator = stationLocal.parallelStations.listIterator();
                            while (listIterator.hasNext()) {
                                stationLocal2 = (StationLocal)listIterator.next();
                                if (stationLocal2.status != 3) continue;
                                bl = true;
                                stationLocal4 = stationLocal2;
                                break;
                            }
                            if (bl && (stationLocal.config.selectMode == 4 || stationLocal.config.selectMode == 5)) {
                                bl2 = true;
                            }
                        }
                        if (!bl2 && (bl || stationLocal.status == 3)) {
                            if (stationLocal.config.flowMode == 1) {
                                stationLocal = stationLocal4;
                                eventList = stationLocal.inputList;
                            }
                            block25: while (true) {
                                EventList eventList4 = eventList;
                                synchronized (eventList4) {
                                    ListIterator listIterator4;
                                    int n3;
                                    if (stationLocal.id == 0) {
                                        bl3 = true;
                                    } else if (stationLocal.config.selectMode == 1 && stationLocal.config.blockMode == 1) {
                                        int n4 = arrayList.size();
                                        if (stationLocal.config.prescale == 1) {
                                            bl3 = true;
                                            eventList.eventsTry += (long)n4;
                                        } else {
                                            n3 = stationLocal.config.prescale;
                                            long l = eventList.eventsTry;
                                            list = arrayList.subList(0, (int)((l + (long)n4) / (long)n3 - l / (long)n3));
                                            arrayList2.addAll(list);
                                            list.clear();
                                            eventList.eventsTry += (long)n4;
                                        }
                                    } else if (stationLocal.config.selectMode == 1 && stationLocal.config.blockMode == 0) {
                                        if (eventList.events.size() < stationLocal.config.cue) {
                                            int n5;
                                            n2 = stationLocal.config.cue - eventList.events.size();
                                            list = arrayList.subList(0, n2 > (n5 = arrayList.size()) ? n5 : n2);
                                            arrayList2.addAll(list);
                                            list.clear();
                                        }
                                    } else if (stationLocal.config.blockMode == 1) {
                                        n3 = stationLocal.config.prescale;
                                        listIterator4 = arrayList.listIterator();
                                        while (listIterator4.hasNext()) {
                                            event = (Event)listIterator4.next();
                                            if (!stationLocal.selector.select(this.sys, stationLocal, event) || eventList.eventsTry++ % (long)n3 != 0L) continue;
                                            arrayList2.add(event);
                                            listIterator4.remove();
                                        }
                                    } else if (stationLocal.config.blockMode == 0 && eventList.events.size() < stationLocal.config.cue) {
                                        n2 = stationLocal.config.cue - eventList.events.size();
                                        listIterator4 = arrayList.listIterator();
                                        while (listIterator4.hasNext()) {
                                            event = (Event)listIterator4.next();
                                            if (!stationLocal.selector.select(this.sys, stationLocal, event)) continue;
                                            arrayList2.add(event);
                                            listIterator4.remove();
                                            if (--n2 >= 1) {
                                                continue;
                                            }
                                            break;
                                        }
                                    }
                                    if (arrayList2.size() > 0 || bl3) {
                                        if (stationLocal.id == 0) {
                                            eventList.putInLow(arrayList);
                                            arrayList.clear();
                                            bl3 = false;
                                        } else if (bl3) {
                                            eventList.putAll(arrayList);
                                            arrayList.clear();
                                            bl3 = false;
                                        } else {
                                            eventList.putAll(arrayList2);
                                            arrayList2.clear();
                                        }
                                        eventList.notifyAll();
                                    }
                                }
                                if (!bl) continue;
                                while (listIterator.hasNext()) {
                                    stationLocal2 = (StationLocal)listIterator.next();
                                    if (stationLocal2.status == 3) {
                                        stationLocal = stationLocal2;
                                        eventList = stationLocal.inputList;
                                        continue block25;
                                    }
                                    if (stationLocal2.status != 3) continue;
                                    if (bl && arrayList.size() > 0) continue block25;
                                }
                                break block89;
                                break;
                            }
                            {
                                break block89;
                                break;
                            }
                        }
                        if (bl2 && bl) {
                            int n6;
                            int n7;
                            int n8;
                            int[] nArray;
                            int n9;
                            int n10 = 0;
                            int n11 = 0;
                            if (stationLocal.config.selectMode == 4) {
                                boolean bl4 = false;
                                stationLocal2 = stationLocal;
                                listIterator = stationLocal.parallelStations.listIterator(1);
                                while (true) {
                                    if (stationLocal2.status == 3) {
                                        if (bl4) {
                                            stationLocal3 = stationLocal2;
                                            bl4 = false;
                                        }
                                        ++n11;
                                    }
                                    if (stationLocal2.wasLast) {
                                        stationLocal2.wasLast = false;
                                        bl4 = true;
                                    }
                                    if (!listIterator.hasNext()) break;
                                    stationLocal2 = (StationLocal)listIterator.next();
                                }
                                if (stationLocal3 == null) {
                                    stationLocal3 = stationLocal4;
                                }
                                int n12 = arrayList.size() / n11;
                                int n13 = arrayList.size() % n11;
                                n2 = 0;
                                n9 = 0;
                                nArray = new int[n11];
                                int n14 = 0;
                                while (n14 < n11) {
                                    if (n14 < n13) {
                                        nArray[n14] = n12 + 1;
                                        if (n14 == n13 - 1) {
                                            n10 = n14;
                                        }
                                    } else {
                                        nArray[n14] = n12;
                                    }
                                    if (n13 == 0) {
                                        n10 = n11 - 1;
                                    }
                                    int n15 = nArray[n14];
                                    n8 = n14;
                                    n7 = 0;
                                    while (n7 < n15) {
                                        arrayList2.add(arrayList.get(n8));
                                        n8 += n11;
                                        ++n7;
                                    }
                                    ++n14;
                                }
                                stationLocal2 = stationLocal3;
                                eventList = stationLocal2.inputList;
                                n2 = 0;
                                n8 = stationLocal.parallelStations.indexOf(stationLocal3) + 1;
                                listIterator = stationLocal.parallelStations.listIterator(n8);
                                while (true) {
                                    if (stationLocal2.status == 3) {
                                        if (n2 == n10) {
                                            stationLocal2.wasLast = true;
                                        }
                                        if ((n6 = nArray[n2++]) > 0) {
                                            EventList eventList5 = eventList;
                                            synchronized (eventList5) {
                                                list = arrayList2.subList(n9, n9 + n6);
                                                eventList.putAll(list);
                                                eventList.eventsTry += (long)n6;
                                                eventList.notifyAll();
                                            }
                                            n9 += n6;
                                        }
                                    }
                                    if (n2 >= n11) break;
                                    if (listIterator.hasNext()) {
                                        stationLocal2 = (StationLocal)listIterator.next();
                                        eventList = stationLocal2.inputList;
                                        continue;
                                    }
                                    stationLocal2 = stationLocal4;
                                    eventList = stationLocal2.inputList;
                                    n8 = stationLocal.parallelStations.indexOf(stationLocal2) + 1;
                                    listIterator = stationLocal.parallelStations.listIterator(n8);
                                }
                                arrayList2.clear();
                            } else {
                                int n16 = arrayList.size();
                                int n17 = 0;
                                n9 = 0;
                                int n18 = 0;
                                int[] nArray2 = new int[this.sys.config.stationsMax + 1];
                                int[] nArray3 = new int[this.sys.config.stationsMax + 1];
                                n7 = 1;
                                while (n7 <= this.sys.config.stationsMax) {
                                    nArray2[n7] = n7;
                                    ++n7;
                                }
                                stationLocal2 = stationLocal4;
                                while (true) {
                                    if (stationLocal2.status == 3) {
                                        nArray3[n11 + 1] = stationLocal2.inputList.events.size();
                                        ++n11;
                                    }
                                    if (!listIterator.hasNext()) break;
                                    stationLocal2 = (StationLocal)listIterator.next();
                                }
                                this.shellSort(n11, nArray3, nArray2);
                                int n19 = 0;
                                int n20 = nArray3[1];
                                nArray = new int[n11];
                                while (n17 < n16) {
                                    int n21;
                                    int n22;
                                    n18 = 0;
                                    int n23 = 1;
                                    while (n23 <= n11) {
                                        if (n20 == nArray3[n23] + nArray[nArray2[n23] - 1]) {
                                            ++n18;
                                        } else {
                                            n19 = nArray3[n23];
                                            break;
                                        }
                                        ++n23;
                                    }
                                    if (n18 == n11 || n16 - n17 < (n19 - n20) * n18) {
                                        n6 = n16 - n17;
                                        n22 = n6 / n18;
                                        int n24 = n6 % n18;
                                        n2 = 0;
                                        n21 = 1;
                                        while (n21 <= n18) {
                                            if (n2++ < n24) {
                                                int n25 = nArray2[n21] - 1;
                                                nArray[n25] = nArray[n25] + (n22 + 1);
                                            } else {
                                                int n26 = nArray2[n21] - 1;
                                                nArray[n26] = nArray[n26] + n22;
                                            }
                                            ++n21;
                                        }
                                        break;
                                    }
                                    n22 = n19 - n20;
                                    n21 = 1;
                                    while (n21 <= n18) {
                                        int n27 = nArray2[n21] - 1;
                                        nArray[n27] = nArray[n27] + n22;
                                        ++n21;
                                    }
                                    n20 = n19;
                                    n17 += n22 * n18;
                                }
                                stationLocal2 = stationLocal4;
                                n2 = 0;
                                n8 = stationLocal.parallelStations.indexOf(stationLocal2) + 1;
                                listIterator = stationLocal.parallelStations.listIterator(n8);
                                while (true) {
                                    if (stationLocal2.status == 3) {
                                        if ((n6 = nArray[n2++]) < 1) {
                                            if (!listIterator.hasNext()) break;
                                            stationLocal2 = (StationLocal)listIterator.next();
                                            continue;
                                        }
                                        EventList eventList6 = eventList = stationLocal2.inputList;
                                        synchronized (eventList6) {
                                            list = arrayList.subList(n9, n9 + n6);
                                            eventList.putAll(list);
                                            eventList.eventsTry += (long)n6;
                                            eventList.notifyAll();
                                        }
                                        n9 += n6;
                                    }
                                    if (!listIterator.hasNext()) break;
                                    stationLocal2 = (StationLocal)listIterator.next();
                                }
                            }
                            arrayList.clear();
                        }
                    }
                    if (stationLocal.id == 0) break;
                    stationLocal = listIterator2.hasNext() ? (StationLocal)listIterator2.next() : (StationLocal)this.sys.stations.getFirst();
                    eventList = stationLocal.inputList;
                }
            }
        }
    }
}

