/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jlab.coda.et.AllData;
import org.jlab.coda.et.EtException;
import org.jlab.coda.et.SystemOpenConfig;
import org.jlab.coda.et.SystemUse;

/*
 * Exception performing whole class analysis ignored.
 */
public class EtMonitor {
    static int period = 3;
    static long prevGcOut;

    private static void usage() {
        System.out.println("\nUsage: java EtMonitor -f <et name> [-p <period>] [-port <server port>] [-h <host>]\n\n       -f     ET system's name\n       -p     period in seconds between data updates\n       -port  port number for a direct connection\n       -h     host the ET system resides on (defaults to local)\n        This monitor works by making a direct connection to the\n        ET system's tcp server port.\n");
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        int n = 11111;
        try {
            int n2 = 0;
            while (n2 < stringArray.length) {
                block23: {
                    if (stringArray[n2].equalsIgnoreCase("-f")) {
                        string = stringArray[++n2];
                    } else if (stringArray[n2].equalsIgnoreCase("-h")) {
                        string2 = stringArray[++n2];
                    } else {
                        if (stringArray[n2].equalsIgnoreCase("-port")) {
                            try {
                                n = Integer.parseInt(stringArray[++n2]);
                                if (n < 1024 || n > 65535) {
                                    System.out.println("Port number must be between 1024 and 65535.");
                                    EtMonitor.usage();
                                    return;
                                }
                                break block23;
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.out.println("Did not specify a proper port number.");
                                EtMonitor.usage();
                                return;
                            }
                        }
                        if (stringArray[n2].equalsIgnoreCase("-p")) {
                            try {
                                period = Integer.parseInt(stringArray[++n2]);
                                if (period < 1) {
                                    System.out.println("Period must be at least 1 second.");
                                    EtMonitor.usage();
                                    return;
                                }
                                break block23;
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.out.println("Did not specify a proper period value.");
                                EtMonitor.usage();
                                return;
                            }
                        }
                        EtMonitor.usage();
                        return;
                    }
                }
                ++n2;
            }
            if (string2 == null) {
                try {
                    string2 = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    System.out.println("Host not specified and cannot find local host name.");
                    EtMonitor.usage();
                    return;
                }
            }
            if (string == null) {
                EtMonitor.usage();
                return;
            }
            SystemOpenConfig systemOpenConfig = new SystemOpenConfig(string, string2, n);
            SystemUse systemUse = new SystemUse(systemOpenConfig, 2);
            AllData allData = new AllData();
            while (true) {
                try {
                    allData = systemUse.getData();
                    EtMonitor.display((SystemUse)systemUse, (AllData)allData);
                }
                catch (EtException etException) {
                    System.out.print("\n*****************************************\n");
                    System.out.print("*   Error getting data from ET system   *");
                    System.out.print("\n*****************************************\n");
                }
                Thread.currentThread();
                Thread.sleep(period * 1000);
            }
        }
        catch (IOException iOException) {
            System.out.println("Communication error with ET system:");
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println("ERROR:");
            exception.printStackTrace();
        }
    }

    private static void display(SystemUse systemUse, AllData allData) {
        int n;
        int n2;
        int n3;
        int n4 = 499;
        double d = 0.0;
        StringBuffer stringBuffer = new StringBuffer(n4 + 1);
        stringBuffer.append("  ET SYSTEM - (");
        stringBuffer.append(allData.sysData.etName);
        stringBuffer.append(") (host ");
        stringBuffer.append(systemUse.getHost());
        stringBuffer.append(")\n              (tcp port ");
        stringBuffer.append(allData.sysData.tcpPort);
        stringBuffer.append(") (udp port ");
        stringBuffer.append(allData.sysData.udpPort);
        stringBuffer.append(") (multicast port ");
        stringBuffer.append(allData.sysData.multicastPort);
        stringBuffer.append(")\n              (pid ");
        stringBuffer.append(allData.sysData.mainPid);
        stringBuffer.append(") (lang ");
        int n5 = systemUse.getLanguage();
        if (n5 == 2) {
            stringBuffer.append("Java) (period ");
        } else if (n5 == 0) {
            stringBuffer.append("C) (period ");
        } else if (n5 == 1) {
            stringBuffer.append("C++) (period ");
        } else {
            stringBuffer.append("unknown) (period ");
        }
        stringBuffer.append(period);
        stringBuffer.append(" sec)\n");
        System.out.println(stringBuffer.toString());
        stringBuffer.delete(0, n4);
        stringBuffer.append("  STATIC INFO - maximum of:\n");
        stringBuffer.append("    events(");
        stringBuffer.append(allData.sysData.events);
        stringBuffer.append("), event size(");
        stringBuffer.append(allData.sysData.eventSize);
        stringBuffer.append("), temps(");
        stringBuffer.append(allData.sysData.tempsMax);
        stringBuffer.append(")\n");
        stringBuffer.append("    stations(");
        stringBuffer.append(allData.sysData.stationsMax);
        stringBuffer.append("), attaches(");
        stringBuffer.append(allData.sysData.attachmentsMax);
        stringBuffer.append("), procs(");
        stringBuffer.append(allData.sysData.processesMax);
        stringBuffer.append(")\n");
        if (allData.sysData.interfaceCount > 0) {
            stringBuffer.append("    network interfaces(");
            stringBuffer.append(allData.sysData.interfaceCount);
            stringBuffer.append(")  ");
            n3 = 0;
            while (n3 < allData.sysData.interfaceCount) {
                stringBuffer.append(allData.sysData.interfaceAddresses[n3]);
                stringBuffer.append(", ");
                ++n3;
            }
            stringBuffer.append("\n");
        } else {
            stringBuffer.append("    network interfaces(0): none\n");
        }
        if (allData.sysData.multicastCount > 0) {
            stringBuffer.append("    multicast addresses(");
            stringBuffer.append(allData.sysData.multicastCount);
            stringBuffer.append(")  ");
            n3 = 0;
            while (n3 < allData.sysData.multicastCount) {
                stringBuffer.append(allData.sysData.multicastAddresses[n3]);
                stringBuffer.append(", ");
                ++n3;
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("\n  DYNAMIC INFO - currently there are:\n");
        stringBuffer.append("    processes(");
        stringBuffer.append(allData.sysData.processes);
        stringBuffer.append("), attachments(");
        stringBuffer.append(allData.sysData.attachments);
        stringBuffer.append("), temps(");
        stringBuffer.append(allData.sysData.temps);
        stringBuffer.append(")\n    stations(");
        stringBuffer.append(allData.sysData.stations);
        stringBuffer.append("), hearbeat(");
        stringBuffer.append(allData.sysData.heartbeat);
        stringBuffer.append(")\n");
        System.out.println(stringBuffer.toString());
        stringBuffer.delete(0, n4);
        stringBuffer.append("  STATIONS:\n");
        n3 = 0;
        while (n3 < allData.statData.length) {
            boolean bl;
            stringBuffer.append("    \"");
            stringBuffer.append(allData.statData[n3].name);
            stringBuffer.append("\" (id = ");
            stringBuffer.append(allData.statData[n3].num);
            stringBuffer.append(")\n      static info\n");
            if (allData.statData[n3].status == 2) {
                stringBuffer.append("        status(IDLE), ");
            } else {
                stringBuffer.append("        status(ACTIVE), ");
            }
            if (allData.statData[n3].flowMode == 0) {
                stringBuffer.append("flow(SERIAL), ");
            } else {
                stringBuffer.append("flow(PARALLEL), ");
            }
            if (allData.statData[n3].blockMode == 1) {
                stringBuffer.append("blocking(YES), ");
                bl = true;
            } else {
                stringBuffer.append("blocking(NO), ");
                bl = false;
            }
            if (allData.statData[n3].userMode == 0) {
                stringBuffer.append("user(MULTI), ");
            } else {
                stringBuffer.append("user(");
                stringBuffer.append(allData.statData[n3].userMode);
                stringBuffer.append("), ");
            }
            if (allData.statData[n3].selectMode == 1) {
                stringBuffer.append("select(ALL)\n");
            } else if (allData.statData[n3].selectMode == 2) {
                stringBuffer.append("select(MATCH)\n");
            } else if (allData.statData[n3].selectMode == 3) {
                stringBuffer.append("select(USER)\n");
            } else if (allData.statData[n3].selectMode == 4) {
                stringBuffer.append("select(RROBIN)\n");
            } else {
                stringBuffer.append("select(EQUALCUE)\n");
            }
            if (allData.statData[n3].restoreMode == 0) {
                stringBuffer.append("        restore(OUT), ");
            } else if (allData.statData[n3].restoreMode == 1) {
                stringBuffer.append("        restore(IN), ");
            } else {
                stringBuffer.append("        restore(GC), ");
            }
            stringBuffer.append("prescale(");
            stringBuffer.append(allData.statData[n3].prescale);
            stringBuffer.append("), cue(");
            stringBuffer.append(allData.statData[n3].cue);
            stringBuffer.append("), ");
            stringBuffer.append("select words(");
            n2 = 0;
            while (n2 < 4) {
                stringBuffer.append(allData.statData[n3].select[n2]);
                stringBuffer.append(", ");
                ++n2;
            }
            stringBuffer.append(")");
            if (allData.statData[n3].selectMode == 3) {
                stringBuffer.append("\n        lib = ");
                stringBuffer.append(allData.statData[n3].selectLibrary);
                stringBuffer.append(",  function = ");
                stringBuffer.append(allData.statData[n3].selectFunction);
                stringBuffer.append(",  class = ");
                stringBuffer.append(allData.statData[n3].selectClass);
                stringBuffer.append("");
            }
            System.out.println(stringBuffer.toString());
            stringBuffer.delete(0, n4);
            if (allData.statData[n3].status != 3) {
                System.out.println();
            } else {
                stringBuffer.append("      dynamic info\n");
                stringBuffer.append("        attachments: total#(");
                stringBuffer.append(allData.statData[n3].attachments);
                stringBuffer.append("),  ids(");
                n = 0;
                while (n < allData.statData[n3].attachments) {
                    stringBuffer.append(allData.statData[n3].attIds[n]);
                    stringBuffer.append(", ");
                    ++n;
                }
                stringBuffer.append(")\n");
                stringBuffer.append("        input  list: cnt = ");
                stringBuffer.append(allData.statData[n3].inListCount);
                stringBuffer.append(", events in = ");
                stringBuffer.append(allData.statData[n3].inListIn);
                if (bl && allData.statData[n3].num != 0) {
                    stringBuffer.append(", events try = ");
                    stringBuffer.append(allData.statData[n3].inListTry);
                }
                stringBuffer.append("\n");
                stringBuffer.append("        output list: cnt = ");
                stringBuffer.append(allData.statData[n3].outListCount);
                stringBuffer.append(", events out = ");
                stringBuffer.append(allData.statData[n3].outListOut);
                stringBuffer.append("\n");
                System.out.println(stringBuffer.toString());
                stringBuffer.delete(0, n4);
                if (n3 == 0) {
                    d = (allData.statData[n3].outListOut - prevGcOut) / (long)period;
                    prevGcOut = allData.statData[n3].outListOut;
                }
            }
            ++n3;
        }
        if (allData.procData.length > 0) {
            stringBuffer.append("  LOCAL USERS:\n");
            n2 = 0;
            while (n2 < allData.procData.length) {
                if (allData.procData[n2].attachments < 1) {
                    stringBuffer.append("    process id# ");
                    stringBuffer.append(allData.procData[n2].num);
                    stringBuffer.append(", # attachments(0), ");
                } else {
                    stringBuffer.append("    process id# ");
                    stringBuffer.append(allData.procData[n2].num);
                    stringBuffer.append(", # attachments(");
                    stringBuffer.append(allData.procData[n2].attachments);
                    stringBuffer.append("), attach ids(");
                    n = 0;
                    while (n < allData.procData[n2].attachments) {
                        stringBuffer.append(allData.procData[n2].attIds[n]);
                        stringBuffer.append(", ");
                        ++n;
                    }
                    stringBuffer.append("), ");
                }
                stringBuffer.append("pid(");
                stringBuffer.append(allData.procData[n2].pid);
                stringBuffer.append("), hbeat(");
                stringBuffer.append(allData.procData[n2].heartbeat);
                stringBuffer.append(")\n");
                ++n2;
            }
            System.out.println(stringBuffer.toString());
            stringBuffer.delete(0, n4);
        }
        if (allData.attData.length > 0) {
            stringBuffer.append("  ATTACHMENTS: len = " + allData.attData.length + "\n");
            n2 = 0;
            while (n2 < allData.attData.length) {
                stringBuffer.append("    att #");
                stringBuffer.append(allData.attData[n2].num);
                stringBuffer.append(", is at station(");
                stringBuffer.append(allData.attData[n2].stationName);
                stringBuffer.append(") on host(");
                stringBuffer.append(allData.attData[n2].host);
                stringBuffer.append(") at pid(");
                stringBuffer.append(allData.attData[n2].pid);
                stringBuffer.append(")\n");
                stringBuffer.append("    proc(");
                stringBuffer.append(allData.attData[n2].proc);
                stringBuffer.append("), ");
                if (allData.attData[n2].blocked == 1) {
                    stringBuffer.append("blocked(YES)");
                } else {
                    stringBuffer.append("blocked(NO)");
                }
                if (allData.attData[n2].quit == 1) {
                    stringBuffer.append(", told to quit");
                }
                stringBuffer.append("\n      events:  make(");
                stringBuffer.append(allData.attData[n2].eventsMake);
                stringBuffer.append("), get(");
                stringBuffer.append(allData.attData[n2].eventsGet);
                stringBuffer.append("), put(");
                stringBuffer.append(allData.attData[n2].eventsPut);
                stringBuffer.append("), dump(");
                stringBuffer.append(allData.attData[n2].eventsDump);
                stringBuffer.append(")");
                System.out.println(stringBuffer.toString());
                stringBuffer.delete(0, n4);
                ++n2;
            }
        }
        stringBuffer.append("\n  EVENTS OWNED BY:\n");
        stringBuffer.append("    system (");
        stringBuffer.append(allData.sysData.eventsOwned);
        stringBuffer.append("),");
        n2 = 0;
        while (n2 < allData.attData.length) {
            stringBuffer.append("  att");
            stringBuffer.append(allData.attData[n2].num);
            stringBuffer.append(" (");
            stringBuffer.append(allData.attData[n2].eventsOwned);
            stringBuffer.append("),");
            if ((n2 + 1) % 6 == 0) {
                stringBuffer.append("\n    ");
            }
            ++n2;
        }
        stringBuffer.append("\n\n");
        stringBuffer.append("  EVENT RATE of GC = ");
        stringBuffer.append(d);
        stringBuffer.append(" events/sec\n\n");
        stringBuffer.append("  IDLE STATIONS:      ");
        n = 0;
        while (n < allData.statData.length) {
            if (allData.statData[n].status == 2) {
                stringBuffer.append(allData.statData[n].name);
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append("\n");
        stringBuffer.append("  STATION CHAIN:      ");
        int n6 = 0;
        while (n6 < allData.statData.length) {
            stringBuffer.append(allData.statData[n6].name);
            stringBuffer.append(", ");
            ++n6;
        }
        stringBuffer.append("\n");
        if (n5 != 2) {
            stringBuffer.append("  LOCKED MUTEXES:     ");
            if (allData.sysData.mutex == 1) {
                stringBuffer.append("system, ");
            }
            if (allData.sysData.statMutex == 1) {
                stringBuffer.append("station, ");
            }
            if (allData.sysData.statAddMutex == 1) {
                stringBuffer.append("add_station, ");
            }
            int n7 = 0;
            while (n7 < allData.statData.length) {
                if (allData.statData[n7].mutex == 1) {
                    stringBuffer.append(allData.statData[n7].name);
                }
                if (allData.statData[n7].inListMutex == 1) {
                    stringBuffer.append(allData.statData[n7].name);
                    stringBuffer.append("-in, ");
                }
                if (allData.statData[n7].outListMutex == 1) {
                    stringBuffer.append(allData.statData[n7].name);
                    stringBuffer.append("-out, ");
                }
                ++n7;
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("\n*****************************************\n");
        System.out.println(stringBuffer.toString());
        stringBuffer.delete(0, n4);
    }
}

