/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql.msql;

import com.imaginary.sql.msql.MsqlException;
import com.imaginary.sql.msql.MsqlPooledDataSource;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class MsqlPooledConnection
implements Connection,
PooledConnection {
    private Connection connection = null;
    private MsqlPooledDataSource dataSource = null;
    private ArrayList listeners = new ArrayList();
    private boolean open = true;

    MsqlPooledConnection(MsqlPooledDataSource msqlPooledDataSource) {
        this.dataSource = msqlPooledDataSource;
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(connectionEventListener);
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.getConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            this.notifyListeners(new ConnectionEvent(this, sQLException));
            throw sQLException;
        }
    }

    public void close() throws SQLException {
        if (this.isClosed()) {
            throw new MsqlException("Connection is already closed.");
        }
        this.open = false;
        this.connection = null;
        this.notifyListeners(new ConnectionEvent(this));
    }

    public void commit() throws SQLException {
        try {
            this.getConnection().commit();
        }
        catch (SQLException sQLException) {
            this.notifyListeners(new ConnectionEvent(this, sQLException));
            throw sQLException;
        }
    }

    public Statement createStatement() throws SQLException {
        try {
            return this.getConnection().createStatement();
        }
        catch (SQLException sQLException) {
            this.notifyListeners(new ConnectionEvent(this, sQLException));
            throw sQLException;
        }
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        try {
            return this.getConnection().createStatement(n, n2);
        }
        catch (SQLException sQLException) {
            this.notifyListeners(new ConnectionEvent(this, sQLException));
            throw sQLException;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        try {
            return this.getConnection().getAutoCommit();
        }
        catch (SQLException sQLException) {
            this.notifyListeners(new ConnectionEvent(this, sQLException));
            throw sQLException;
        }
    }

    public String getCatalog() throws SQLException {
        try {
            return this.getConnection().getCatalog();
        }
        catch (SQLException sQLException) {
            this.notifyListeners(new ConnectionEvent(this, sQLException));
            throw sQLException;
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.isClosed()) {
            throw new MsqlException("Illegal attempt to reuse a closed, pooled connection.");
        }
        if (this.connection != null) {
            return this.connection;
        }
        this.connection = this.dataSource.popConnection();
        return this.connection;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.getConnection().getMetaData();
        }
        catch (SQLException sQLException) {
            this.notifyListeners(new ConnectionEvent(this, sQLException));
            throw sQLException;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        try {
            return this.getConnection().getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            this.notifyListeners(new ConnectionEvent(this, sQLException));
            throw sQLException;
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            return this.getConnection().getTypeMap();
        }
        catch (SQLException sQLException) {
            this.notifyListeners(new ConnectionEvent(this, sQLException));
            throw sQLException;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.getConnection().getWarnings();
        }
        catch (SQLException sQLException) {
            this.notifyListeners(new ConnectionEvent(this, sQLException));
            throw sQLException;
        }
    }

    public boolean isClosed() {
        return this.open ^ true;
    }

    public boolean isReadOnly() throws SQLException {
        try {
            return this.getConnection().isReadOnly();
        }
        catch (SQLException sQLException) {
            this.notifyListeners(new ConnectionEvent(this, sQLException));
            throw sQLException;
        }
    }

    public String nativeSQL(String string) throws SQLException {
        try {
            return this.getConnection().nativeSQL(string);
        }
        catch (SQLException sQLException) {
            this.notifyListeners(new ConnectionEvent(this, sQLException));
            throw sQLException;
        }
    }

    private void notifyListeners(ConnectionEvent connectionEvent) {
        SQLException sQLException = connectionEvent.getSQLException();
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            Iterator iterator = ((AbstractList)this.listeners).iterator();
            while (iterator.hasNext()) {
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)iterator.next();
                if (sQLException != null) {
                    connectionEventListener.connectionErrorOccurred(connectionEvent);
                    continue;
                }
                connectionEventListener.connectionClosed(connectionEvent);
            }
        }
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        try {
            return this.getConnection().prepareCall(string);
        }
        catch (SQLException sQLException) {
            this.notifyListeners(new ConnectionEvent(this, sQLException));
            throw sQLException;
        }
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        try {
            return this.getConnection().prepareCall(string, n, n2);
        }
        catch (SQLException sQLException) {
            this.notifyListeners(new ConnectionEvent(this, sQLException));
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        try {
            return this.getConnection().prepareStatement(string);
        }
        catch (SQLException sQLException) {
            this.notifyListeners(new ConnectionEvent(this, sQLException));
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        try {
            return this.getConnection().prepareStatement(string, n, n2);
        }
        catch (SQLException sQLException) {
            this.notifyListeners(new ConnectionEvent(this, sQLException));
            throw sQLException;
        }
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            ((AbstractCollection)this.listeners).remove(connectionEventListener);
        }
    }

    public void rollback() throws SQLException {
        try {
            this.getConnection().rollback();
        }
        catch (SQLException sQLException) {
            this.notifyListeners(new ConnectionEvent(this, sQLException));
            throw sQLException;
        }
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        try {
            this.getConnection().setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            this.notifyListeners(new ConnectionEvent(this, sQLException));
            throw sQLException;
        }
    }

    public void setCatalog(String string) throws SQLException {
        try {
            this.getConnection().setCatalog(string);
        }
        catch (SQLException sQLException) {
            this.notifyListeners(new ConnectionEvent(this, sQLException));
            throw sQLException;
        }
    }

    public void setReadOnly(boolean bl) throws SQLException {
        try {
            this.getConnection().setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            this.notifyListeners(new ConnectionEvent(this, sQLException));
            throw sQLException;
        }
    }

    public void setTransactionIsolation(int n) throws SQLException {
        try {
            this.getConnection().setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            this.notifyListeners(new ConnectionEvent(this, sQLException));
            throw sQLException;
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        try {
            this.getConnection().setTypeMap(map);
        }
        catch (SQLException sQLException) {
            this.notifyListeners(new ConnectionEvent(this, sQLException));
            throw sQLException;
        }
    }
}

