/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql.msql;

import com.imaginary.sql.msql.MsqlConnection;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class MsqlDataSource
implements DataSource,
Referenceable,
Serializable {
    private String databaseName = null;
    private String encoding = "8859_1";
    private transient PrintWriter logWriter = null;
    private int loginTimeout = 0;
    private String password = "";
    private int port = 1114;
    private String serverName = null;
    private String user = "";

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        Properties properties = new Properties();
        if (string == null) {
            string = this.user == null ? "" : this.user;
        }
        if (string2 == null) {
            this.password = this.password == null ? "" : string2;
        }
        properties.put("user", string);
        properties.put("password", string2);
        properties.put("encoding", this.encoding);
        return this.getConnection(properties);
    }

    protected Connection getConnection(Properties properties) throws SQLException {
        return new MsqlConnection(this.getURL(), this.getServerName(), this.getPort(), this.getDatabaseName(), properties);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public int getPort() {
        return this.port;
    }

    public Reference getReference() throws NamingException {
        String string = "com.imaginary.sql.msql.MsqlDataSourceFactory";
        Reference reference = new Reference(this.getClass().getName(), string, null);
        reference.add(new StringRefAddr("serverName", this.getServerName()));
        reference.add(new StringRefAddr("databaseName", this.getDatabaseName()));
        reference.add(new StringRefAddr("port", String.valueOf(this.getPort())));
        reference.add(new StringRefAddr("encoding", this.getEncoding()));
        reference.add(new StringRefAddr("user", this.getUser()));
        reference.add(new StringRefAddr("password", this.password));
        return reference;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getURL() {
        String string = "jdbc:msql://";
        string = String.valueOf(string) + this.getServerName() + ":" + this.getPort() + "/" + this.getDatabaseName();
        return string;
    }

    public String getUser() {
        return this.user;
    }

    public void setDatabaseName(String string) {
        this.databaseName = string;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.logWriter = printWriter;
    }

    public void setLoginTimeout(int n) throws SQLException {
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public void setUser(String string) {
        this.user = string;
    }
}

