/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql.msql;

import com.imaginary.sql.msql.MsqlException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class MsqlBlob
implements Blob {
    private byte[] data = null;
    private long length = -1L;

    public MsqlBlob(InputStream inputStream) throws SQLException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10240);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] byArray = new byte[10240];
            int n = bufferedInputStream.read(byArray, 0, 10240);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                byArray = new byte[10240];
                n = bufferedInputStream.read(byArray, 0, 10240);
            }
            this.data = byteArrayOutputStream.toByteArray();
            this.length = this.data.length;
        }
        catch (IOException iOException) {
            throw new MsqlException(iOException);
        }
    }

    public MsqlBlob(byte[] byArray) {
        this.data = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.data, 0, byArray.length);
        this.length = byArray.length;
    }

    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.data);
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (l >= this.length) {
            throw new MsqlException("Invalid start position.");
        }
        if ((long)n > this.length - l) {
            n = (int)(this.length - l);
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.data, (int)l, byArray, 0, n);
        return byArray;
    }

    public long length() throws SQLException {
        return this.length;
    }

    public long position(Blob blob, long l) throws SQLException {
        return this.position(blob.getBytes(0L, (int)blob.length()), l);
    }

    public long position(byte[] byArray, long l) throws SQLException {
        int n = (int)(--l);
        while (n < this.data.length) {
            if (byArray.length > this.data.length - n) break;
            if (this.data[n] == byArray[0]) {
                boolean bl = true;
                int n2 = 1;
                while (n2 < byArray.length) {
                    if (this.data[n + n2] != byArray[n2]) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
                if (bl) {
                    return n + 1;
                }
            }
            ++n;
        }
        return -1L;
    }
}

