/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.jlab.coda.et.ClientThread;
import org.jlab.coda.et.SystemCreate;

public class SystemTcpServer
extends Thread {
    private int port;
    private SystemCreate sys;

    SystemTcpServer(SystemCreate systemCreate) {
        this.sys = systemCreate;
        this.port = this.sys.config.serverPort;
    }

    public void run() {
        if (this.sys.config.debug >= 4) {
            System.out.println("Running TCP Server Thread");
        }
        if (this.port < 1) {
            this.port = 11111;
        }
        try {
            ServerSocket serverSocket = new ServerSocket(this.port);
            serverSocket.setSoTimeout(2000);
            while (true) {
                Socket socket;
                try {
                    socket = serverSocket.accept();
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (!this.sys.killAllThreads) continue;
                    return;
                }
                socket.setSoTimeout(500);
                socket.setTcpNoDelay(true);
                socket.setReceiveBufferSize(65535);
                socket.setSendBufferSize(65535);
                ClientThread clientThread = new ClientThread(this.sys, socket);
                clientThread.start();
            }
        }
        catch (SocketException socketException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

