/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.jlab.coda.et.EtException;

public class SystemOpenConfig {
    String name;
    String host;
    HashSet broadcastAddrs;
    HashSet multicastAddrs;
    int contactMethod;
    int udpPort;
    int tcpPort;
    int multicastPort;
    int ttl;
    int responsePolicy;

    public SystemOpenConfig(String string, String string2, Collection collection, Collection collection2, int n, int n2, int n3, int n4, int n5, int n6) throws EtException {
        this.name = string;
        if (string == null || string.equals("")) {
            throw new EtException("Bad ET system name");
        }
        this.host = string2;
        if (this.host == null || this.host.equals("")) {
            throw new EtException("Bad host or location name");
        }
        boolean bl = true;
        if (collection == null || collection.size() < 1) {
            this.broadcastAddrs = new HashSet(10);
        } else {
            this.broadcastAddrs = new HashSet(collection);
            bl = false;
        }
        boolean bl2 = true;
        if (collection2 == null || collection2.size() < 1) {
            this.multicastAddrs = new HashSet(10);
        } else {
            this.multicastAddrs = new HashSet(collection2);
            bl2 = false;
        }
        if (n != 0 && n != 1 && n != 3 && n != 2 && n != 4) {
            throw new EtException("Bad contact method value");
        }
        this.contactMethod = n;
        if (this.contactMethod == 2 || this.contactMethod == 4) {
            if (this.host.equals(".remote") || this.host.equals(".anywhere")) {
                throw new EtException("Need to specify an actual host name");
            }
        } else {
            if (this.contactMethod == 1 && bl) {
                throw new EtException("Need to specify a broadcast address");
            }
            if (this.contactMethod == 0 && bl2) {
                throw new EtException("Need to specify a multicast address");
            }
            if (this.contactMethod == 3 && bl && bl2) {
                throw new EtException("Need to specify a broad or multicast address");
            }
        }
        if (n3 < 1024 || n3 > 65535) {
            throw new EtException("Bad UDP port value");
        }
        this.udpPort = n3;
        if (n2 < 1024 || n2 > 65535) {
            throw new EtException("Bad TCP port value");
        }
        this.tcpPort = n2;
        if (n4 < 1024 || n4 > 65535) {
            throw new EtException("Bad multicast port value");
        }
        this.multicastPort = n4;
        if (n5 < 0 || n5 > 254) {
            throw new EtException("Bad TTL value");
        }
        this.ttl = n5;
        if (n6 != 0 && n6 != 1 && n6 != 2) {
            throw new EtException("Bad policy value");
        }
        if (this.host.equals(".remote") && n6 == 1) {
            throw new EtException("Policy value cannot be local if host is remote");
        }
        this.responsePolicy = n6;
    }

    public SystemOpenConfig(String string, String string2, Collection collection, int n) throws EtException {
        this(string, string2, collection, null, 1, 11111, n, 11112, 1, 0);
    }

    public SystemOpenConfig(String string, String string2, Collection collection, int n, int n2) throws EtException {
        this(string, string2, null, collection, 0, 11111, 11111, n, n2, 0);
    }

    public SystemOpenConfig(String string, String string2, Collection collection, int n, int n2, int n3) throws EtException {
        this(string, string2, null, collection, 0, 11111, n, n2, n3, 0);
    }

    public SystemOpenConfig(String string, String string2, int n) throws EtException {
        this(string, string2, null, null, 2, n, 11111, 11112, 1, 0);
    }

    public SystemOpenConfig(SystemOpenConfig systemOpenConfig) {
        this.name = systemOpenConfig.name;
        this.host = systemOpenConfig.host;
        this.broadcastAddrs = systemOpenConfig.getBroadcastAddrs();
        this.multicastAddrs = systemOpenConfig.getMulticastAddrs();
        this.contactMethod = systemOpenConfig.contactMethod;
        this.udpPort = systemOpenConfig.udpPort;
        this.tcpPort = systemOpenConfig.tcpPort;
        this.multicastPort = systemOpenConfig.multicastPort;
        this.ttl = systemOpenConfig.ttl;
        this.responsePolicy = systemOpenConfig.responsePolicy;
    }

    public String getEtName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public HashSet getBroadcastAddrs() {
        return (HashSet)this.broadcastAddrs.clone();
    }

    public HashSet getMulticastAddrs() {
        return (HashSet)this.multicastAddrs.clone();
    }

    public int getContactMethod() {
        return this.contactMethod;
    }

    public int getResponsePolicy() {
        return this.responsePolicy;
    }

    public int getUdpPort() {
        return this.udpPort;
    }

    public int getTcpPort() {
        return this.tcpPort;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public int getTTL() {
        return this.ttl;
    }

    public int getNumBroadcastAddrs() {
        return this.broadcastAddrs.size();
    }

    public int getNumMulticastAddrs() {
        return this.multicastAddrs.size();
    }

    public void setEtName(String string) {
        this.name = string;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void removeBroadcastAddr(String string) {
        this.broadcastAddrs.remove(string);
    }

    public void removeMulticastAddr(String string) {
        this.multicastAddrs.remove(string);
    }

    public void addBroadcastAddr(String string) throws EtException {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new EtException("not a broadcast address");
        }
        this.broadcastAddrs.add(string);
    }

    public void addMulticastAddr(String string) throws EtException {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new EtException("not a multicast address");
        }
        if (!inetAddress.isMulticastAddress()) {
            throw new EtException("not a multicast address");
        }
        this.multicastAddrs.add(string);
    }

    public void setBroadcastAddrs(Collection collection) throws EtException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                throw new EtException(string + " is not a broadcast address");
            }
        }
        this.broadcastAddrs = new HashSet(collection);
    }

    public void setMulticastAddrs(Collection collection) throws EtException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            InetAddress inetAddress;
            String string = (String)iterator.next();
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                throw new EtException("not a broadcast address");
            }
            if (inetAddress.isMulticastAddress()) continue;
            throw new EtException(string + " is not a multicast address");
        }
        this.multicastAddrs = new HashSet(collection);
    }

    public void setContactMethod(int n) throws EtException {
        if (n != 0 && n != 1 && n != 3 && n != 2 && n != 4) {
            throw new EtException("bad contact method value");
        }
        this.contactMethod = n;
    }

    public void setResponsePolicy(int n) throws EtException {
        if (n != 0 && n != 1 && n != 2) {
            throw new EtException("bad policy value");
        }
        if (this.host.equals(".remote") && n == 1) {
            throw new EtException("policy value cannot be local if host is remote");
        }
        this.responsePolicy = n;
    }

    public void setUdpPort(int n) throws EtException {
        if (n < 1024 || n > 65535) {
            throw new EtException("bad UDP port value");
        }
        this.udpPort = n;
    }

    public void setTcpPort(int n) throws EtException {
        if (n < 1024 || n > 65535) {
            throw new EtException("bad TCP port value");
        }
        this.tcpPort = n;
    }

    public void setMulticastPort(int n) throws EtException {
        if (n < 1024 || n > 65535) {
            throw new EtException("bad multicast port value");
        }
        this.multicastPort = n;
    }

    public void setTTL(int n) throws EtException {
        if (n < 0 || n > 254) {
            throw new EtException("bad TTL value");
        }
        this.ttl = n;
    }
}

